@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title $website_name | Vertrauenswürdige Plattform für Krypto-Handel" }}</title>
    <meta name="description" content="{{ "$website_title Optimiere deinen Kryptowährungsgewinn mit leistungsstarken Tools auf $website_name die Stress reduzieren, Rendite maximieren und langfristigen Erfolg sichern." }}" />
@endpush
@section('content')

<!-- Hero -->
<section id="hero" class="hero-section">
    <div class="uk-container">
        <div class="hero-inner">

            <div class="uk-grid-medium uk-grid-large" uk-grid>
                <div class="uk-width-expand@s uk-light">
                    <h1 class="home__title">
                        <b class="accent">{{$website_title}}</b><sup>TM</sup>
                    </h1>
                    <div class="home__text">
                        <p class="change-by-command">{{ "$website_title Investieren Sie Ihr Geld in das wilde Universum der Kryptowährungen und verwenden Sie alle benötigten Werkzeuge." }}</p>
                    </div>
                </div>
                <div class="uk-width-auto@s">
                    @include('frontend.de.components.form')
                </div>
            </div>

        </div>
    </div>
</section>


<!-- What is -->
<section class="waht-section uk-section">
    <div class="uk-container">
        <div class="uk-grid-large" uk-grid>
            <div class="uk-width-expand@s">
                <h2 class="title-2">{{aiTrans('Was ist')}} <b class="accent">{{$website_title}}?</b></h2>
                <p class="txt">
                    {{ aiTrans(
                        '[website_title] ist eine Handelsplattform, die entwickelt wurde, um den Bitcoin auf einen Markt zu bringen, der nach jeder Gelegenheit zum Erfolg giert. Diese Plattform genießt eine bessere Sicherheit und ein Angebot, das Sie nicht ignorieren können.',
                        $locale,
                        [
                            'website_title' => $website_title,
                        ],
                    ) }}
                </p>
                <p>
                    {{ aiTrans(
                        'Die Bequemlichkeit dieser Plattform macht es möglich, dass Händler aus allen Hintergründen und Fähigkeiten verbinden können. Diese Vielfalt an von Hintergründen ist zu einem der größten Vorteile bei [website_title], denn Sie erhalten Unterstützung von den Besten.',
                        $locale,
                        [
                            'website_title' => $website_title,
                        ],
                    ) }}
                </p>
                <a href="#hero" uk-scroll class="btn-cta btn-o">
                    {{aiTrans('MEHR LERNEN')}}
                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M6.75 5.0625C6.43934 5.0625 6.1875 4.81066 6.1875 4.5C6.1875 4.18934 6.43934 3.9375 6.75 3.9375H13.5C13.8107 3.9375 14.0625 4.18934 14.0625 4.5V11.25C14.0625 11.5607 13.8107 11.8125 13.5 11.8125C13.1893 11.8125 12.9375 11.5607 12.9375 11.25V5.85799L4.89775 13.8977C4.67808 14.1174 4.32192 14.1174 4.10225 13.8977C3.88258 13.6781 3.88258 13.3219 4.10225 13.1023L12.142 5.0625H6.75Z" fill="#FF6A00"></path>
                    </svg>
                </a>
            </div>
            <div class="uk-width-auto@s what-img">
                <img src="{{ asset('frontend/assets/de/dist') }}/images/img-1.svg" alt="">
            </div>
        </div>
    </div>

    <div class="uk-margin-large-top">
        <div class="uk-container">
            <h2 class="title-2 uk-text-center"> <b class="accent">{{aiTrans('Investieren in Bitcoin')}}</b> {{aiTrans('- Warum es Sinn macht')}}</h2>
            <p class="txt uk-text-center">{{ aiTrans(
                'Wir werden bald über die Plattform [website_title] berichten, aber zuerst möchten wir Ihnen zeigen, warum Bitcoin als Investition durchaus Sinn machen kann. Selbst die meisten Unwissenden über Kryptowährungen werden die größte ein - Bitcoin. Wahrscheinlich haben die meisten Leute den Namen schon einmal gehört.',
                $locale,
                [
                    'website_title' => $website_title,
                ],
            ) }}</p>


            <div class="uk-flex-middle" uk-grid>
                <div class="uk-width-1-2@s">
                    <img class="what-img-left" src="{{ asset('frontend/assets/de/dist') }}/images/img-2.webp" alt="">
                </div>
                <div class="uk-width-1-2@s">

                    <p>
                        {{aiTrans('Bitcoin wurde 2009 als Open-Source-Software eingeführt und war die erste der
                        Kryptowährungen. Sie wurde anfangs sehr missverstanden und wurde zu einem Preis von
                        nur 0,00099 $ pro Bitcoin eingeführt. Wenn man bedenkt, dass der höchste Wert
                        (verzeichnet im November 2021) 68.789,63 $ pro Bitcoin betrug, war das in den ersten
                        Tagen ein unglaubliches Schnäppchen. frühen Tagen.')}}
                    </p>

                    <p>
                        {{aiTrans('Heute gibt es über 25.000 andere Kryptowährungen auf dem Markt, aber was Bitcoin so
                        besonders macht, ist, dass andere dass andere Kryptowährungen Bitcoin wahrscheinlich
                        nicht übertreffen werden. Er hat den höchsten Wert von allen anderen Kryptowährungen
                        und die meisten Preise der anderen Kryptowährungen folgen dem Wert von Bitcoin.')}}
                    </p>

                    <p>
                        {{aiTrans('Bitcoin hat jetzt einen ikonischen Status in der Kryptowährungs Gemeinschaft, und er
                        erhält gute Unterstützung, um seine Stärke zu gewährleisten.')}}
                    </p>

                </div>
            </div>

            <p>
                {{aiTrans('Wir möchten Ihnen ein vollständiges Bild geben, denn Kryptowährungen, einschließlich
                Bitcoin, ein volatiler Markt sein können. Man hört oft von plötzlichen Ausschlägen und
                Einbrüchen ohne Vorwarnung. Doch diese Volatilität ermöglicht es Ihnen, mit Bitcoin Geld
                zu verdienen. Wir wollten nur sicherstellen, dass Sie das Risiko verstehen, bevor Sie
                sich darauf einlassen.')}}
            </p>

            <p>
                {{aiTrans('Jeder Handel birgt Risiken, so auch Bitcoin. Der Schlüssel zum erfolgreich zu sein, ist,
                das Risiko zu minimieren und innerhalb bestimmter Parameter.')}}
            </p>

        </div>
    </div>


    <div class="uk-margin-large-top">
        <div class="uk-container">
            <h2 class="title-2 uk-text-center">
                {{aiTrans('Warum Handel mit')}} <b class="accent"> {{$website_title}}?</b>
            </h2>
            <p>
                {{ aiTrans(
                    'Wenn Sie sich für eine Handelsplattform entscheiden, möchten Sie wissen, dass Ihr Geld an einem sicheren Ort angelegt wurde, der mit der Zeit weiter wachsen wird. Sie können den Wert einer vertrauenswürdigen Plattform, die Ihr Geld bewacht. [website_title] versucht, Ihren Bitcoin zu sichern, aber es wird Ihnen auch helfen, effiziente Geschäfte zu machen und den Prozess so weit wie möglich zu rationalisieren, damit die Plattform müheloser als andere.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>


            <div class="uk-grid-small uk-margin-medium-top" uk-grid>
                <div class="uk-width-auto">
                    <div class="icon icon-big">
                        <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-3.svg" alt="">
                    </div>
                </div>
                <div class="uk-width-expand">
                    <h3 class="block__title">{{aiTrans('Sichere Plattform')}}</h3>
                    <p>

                        {{ aiTrans(
                            'Sie fragen sich vielleicht, welche Maßnahmen wir ergreifen, um Ihr Geld sicher. Bei
                            [website_title] ist Sicherheit eine der höchsten Prioritäten. Wir verwenden die neuesten
                            und besten Praktiken für Sicherheit, um zu gewährleisten, dass Ihre Investition
                            sicher bleibt. Unsere Plattform folgt einem festgelegten Protokoll und verwendet
                            Verschlüsselung zum Schutz Ihrer Daten vor Cyber-Kriminellen.',
                            $locale,
                            [
                                'website_title' => $website_title,
                            ],
                        ) }}
                        
                    </p>
                    <p>
                        {{aitrans('Darüber hinaus können Sie auch die Zwei-Faktor-Authentifizierung verwenden
                        Authentifizierung wählen, um sicherzustellen, dass nur autorisierte Benutzer auf Ihr
                        Konto zugreifen können.')}}
                    </p>
                </div>
            </div>

            <div class="uk-grid-small uk-margin-medium-top" uk-grid>
                <div class="uk-width-auto">
                    <div class="icon icon-big">
                        <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-1.svg" alt="">
                    </div>
                </div>
                <div class="uk-width-expand">
                    <h3 class="block__title">{{aiTrans('Rationalisierung des Prozesses')}}</h3>
                    <p>

                        {{ aiTrans(
                            'Handeln Sie einfach auf unserer Plattform, wie es Ihnen passt. Alles bei [website_title]
                        wurde für eine intuitive Navigation auf der Plattform entwickelt. Analysieren Sie
                        die kombinierten Handelsdaten, um zu sehen, wann Sie die profitabelsten Trades zu
                        machen. Alle diese umfassenden Handelsdaten Handelsdaten können aus verschiedenen
                        Feeds in einer einzigen und skalierbaren Schnittstelle',
                            $locale,
                            [
                                'website_title' => $website_title,
                            ],
                        ) }}
                        
                    </p>
                </div>
            </div>

            <div class="uk-grid-small uk-margin-medium-top" uk-grid>
                <div class="uk-width-auto">
                    <div class="icon icon-big">
                        <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-2.svg" alt="">
                    </div>
                </div>
                <div class="uk-width-expand">
                    <h3 class="block__title">
                        {{ aiTrans(
                            'Wie verbessert [website_title] Ihre Handelserfahrung?',
                            $locale,
                            [
                                'website_title' => $website_title,
                            ],
                        ) }}
                        </h3>
                    <p>

                        {{ aiTrans(
                            'Sobald Sie sich bei der Plattform angemeldet haben, verbindet [website_title] Sie mit
                            einem erfahrenen Kundenbetreuer. Dieser Manager kann Sie einrichten und Ihnen bei
                            Ihren Geschäften helfen. Jeder, der versucht hat, auf einigen Plattformen zu handeln
                            einigen Plattformen zu handeln, kennt die potenziellen Schwierigkeiten, weil man mit
                            Daten überflutet werden können.',
                            $locale,
                            [
                                'website_title' => $website_title,
                            ],
                        ) }}
                        
                    </p>
                    <p>

                        {{ aiTrans(
                            'Anstatt Geschäfte zu machen, werden Sie gelähmt durch der Überanalyse von allem, was
                        man bekommt. [website_title] gibt Ihnen immer noch eine Fülle von Daten, aber sie machen
                        die Anzeige viel einfacher. Stattdessen Sie mit sinnlosen Daten zu bombardieren, die
                        Sie verwirren verwirren, nimmt [website_title] die wesentlichen Daten und stellt sie und
                        stellt sie so dar, dass Sie sie nutzen können, um informierte und profitable
                        Geschäfte zu machen.',
                            $locale,
                            [
                                'website_title' => $website_title,
                            ],
                        ) }}
                        
                    </p>
                    <p>
                        {{aiTrans('Mit den Informationen, die Ihnen die Plattform bietet, können Sie das Gesamtbild
                        besser erkennen. der Plattform. Alle Trades zeigen die Live-Aktivitäten an einem
                        einfachen Ort zu verfolgen, so dass Sie es profitabel machen können. Die Einfachheit
                        der Überwachung und Kontrolle hilft definitiv diese Plattform zu hervorzuheben.')}}
                    </p>

                </div>
            </div>

        </div>
    </div>
</section>

<!-- holder -->
<div class="holder">
    <div class="holder__content">
        <div class="holder__container">
            <div class="holder__body">
                <h2 class="title-2">{{aiTrans('Bleiben Sie am Puls des')}} <br>{{aiTrans('Kryptomarktes')}}</h2>
                <p class="txt">
                    {{aiTrans('Jeder ernsthafte Händler braucht eine robuste und umfassende Handels Plattform. Hier
                    bekommen Sie alles, einschließlich Charting, Analysen und Berichte, die entwickelt
                    wurden, um Händlern auf allen allen Ebenen eine problemlose Handelserfahrung zu
                    bieten. Diese erstklassige Handelsplattform können Sie Ihr Ohr am Puls des
                    Kryptomarktes halten Kryptomarktes, so dass Sie ihn profitabel gestalten können.')}}
                </p>
                <p>

                    {{ aiTrans(
                        '[website_title] bietet Ihnen eine umfangreiche Liste von Handelsdienstleistungen und
                    Tools für Tausende von Menschen auf der ganzen Welt. Die Entwickler dieser Plattform
                    haben es sich zum Ziel gesetzt, Ihnen die Möglichkeit zu geben verwalten, verfolgen
                    und überwachen Sie Ihre Krypto-Vermögenswerte. Wann immer Sie einen Wenn Sie einen
                    Handel abschließen, kann die Anzeige der aktuellsten Preise den Unterschied zwischen
                    einem Gewinn bei einem Verkauf und einem einem hohen Verlust. Sie brauchen die
                    aktuellsten Informationen, um gute um gute Entscheidungen über den Markt zu treffen.
                    [website_title] hilft Ihnen dabei und präzisen Datenströmen, die Sie zu einem besseren
                    die Sie zu einem besseren Händler machen.',
                        $locale,
                        [
                            'website_title' => $website_title,
                        ],
                    ) }}
                    
                </p>
                <p>

                    {{ aiTrans(
                        'Wenn Sie ein Geschäft abschließen, können die aktuellsten Preise den Unterschied
                    zwischen einem Gewinn beim Verkauf und einem oder mit einem hohen Verlust
                    davonkommen. Sie brauchen die aktuellsten Informationen um gute Entscheidungen über
                    den Markt zu treffen. [website_title] wird Ihnen helfen Ihre Bewegungen durch schnelle
                    und genaue Datenströme zu lenken die Sie zu einem besseren Trader machen werden.',
                        $locale,
                        [
                            'website_title' => $website_title,
                        ],
                    ) }}
                    
                </p>
            </div>
        </div>
    </div>
    <div class="holder__image">
        <img src="{{ asset('frontend/assets/de/dist') }}/images/img-3.webp" alt="">
    </div>
</div>

<!-- How to Begin -->
<section class="uk-section">
    <div class="uk-container">
        <h2 class="title-2 uk-text-center">
            
            {{ aiTrans(
                'Erste Schritte mit [website_title] -',
                $locale,
                [
                    'website_title' => $website_title,
                ],
            ) }}
             <b class="accent"> {{aiTrans('Wie man anfängt')}}</b>
        </h2>
        <p>
            {{ aiTrans(
                'Sie haben beschlossen, dass Sie bei [website_title] anfangen wollen, aber Sie wissen aber
            vielleicht nicht, wie Sie den Einstieg schaffen können. Wie machen Sie das? Bleiben Sie
            dran, wenn wir Ihnen die einzelnen Schritte zum Einstieg in den Trades zu machen.',
                $locale,
                [
                    'website_title' => $website_title,
                ],
            ) }}
            
        </p>

        <div class="uk-child-width-1-2@s" uk-grid="masonry: pack">

            <div>
                <div class="uk-flex-middle uk-grid-small" uk-grid>
                    <div class="uk-width-auto">
                        <div class="icon icon-big">
                            <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-4.svg" alt="">
                        </div>
                    </div>
                    <div class="uk-width-expand">
                        <h3 class="block__title">{{aiTrans('1. Ein Konto registrieren')}}</h3>
                    </div>
                </div>
                <p>

                    {{ aiTrans(
                        'Zunächst müssen Sie ein Konto bei [website_title] registrieren. Gehen Sie zu auf die
                    Anmeldeseite und schauen Sie unten auf "Neues Konto registrieren ein neues Konto".
                    Klicken Sie auf den Link, um auf die nächste Seite zu gelangen, auf der auf der
                    Sie Ihre grundlegenden Daten wie Name, Telefonnummer und E-Mail-Adresse ausfüllen
                    Telefonnummer und E-Mail-Adresse.',
                        $locale,
                        [
                            'website_title' => $website_title,
                        ],
                    ) }}
                    
                </p>
                <p>
                    {{aiTrans('Sobald Sie alle Angaben gemacht haben, klicken Sie auf die Schaltfläche Senden.
                    Sie müssen warten, bis sich ein Kundenbetreuer mit Ihnen in Verbindung setzt.')}}
                </p>
            </div>

            <div>
                <div class="uk-flex-middle uk-grid-small" uk-grid>
                    <div class="uk-width-auto">
                        <div class="icon icon-big">
                            <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-7.svg" alt="">
                        </div>
                    </div>
                    <div class="uk-width-expand">
                        <h3 class="block__title">{{aiTrans('2. Prüfen Sie, ob Sie eine Bestätigungs-E-Mail erhalten haben')}}</h3>
                    </div>
                </div>
                <p>
                    {{aiTrans('Nachdem Sie Ihre Daten eingegeben haben, müssen Sie auf eine Bestätigungs-E-Mail
                    warten. In dieser E-Mail werden Ihre Angaben bestätigt. Wir werden einen Termin
                    für ein Treffen zwischen Ihnen und einem unserer Kundenbetreuer. So können Sie
                    nahtlos Transaktionen durchführen.')}}
                </p>
                <p>
                    {{aiTrans('Während des Treffens mit dem Kundenbetreuer möchten wir Sie ermutigen so viele
                    Fragen wie möglich zu stellen, um die Plattform kennenzulernen Plattform
                    kennenzulernen, damit Sie sich leicht zurechtfinden.')}}
                </p>
                <p>
                    {{aiTrans('Wenn Sie ein Konto bei Everix erstellen, haben Sie zwei Möglichkeiten Rand. Sie
                    können entweder selbst handeln, oder Sie können einen Kontoverwalter. Der
                    Kontomanager ist besonders hilfreich für Anfänger, die sich auf dem Markt nicht
                    auskennen. Selbst Handel treiben ist gut, wenn Sie Erfahrung haben oder gerne
                    selbst handeln. selbst machen.')}}
                </p>
            </div>

            <div>
                <div class="uk-flex-middle uk-grid-small" uk-grid>
                    <div class="uk-width-auto">
                        <div class="icon icon-big">
                            <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-5.svg" alt="">
                        </div>
                    </div>
                    <div class="uk-width-expand">
                        <h3 class="block__title">{{aiTrans('3. Eine Einzahlung vornehmen')}}</h3>
                    </div>
                </div>
                <p>
                    {{aiTrans('Bevor Sie mit dem Handel beginnen können, müssen Sie eine Einzahlung vornehmen, um
                    Ihr Konto aufzufüllen. Sie müssen mindestens $250 einzahlen, bevor Sie mit dem
                    echten Handel auf der Plattform beginnen können. mit dem echten Handel auf der
                    Plattform beginnen können. Sie können entweder eine Einzahlung mit Debit- oder
                    Kreditkarte vornehmen. Meistens meisten Fällen, wenn Sie eine Einzahlung machen,
                    das Geld zeigt sich in Ihrem sofort auf Ihrem Konto. Sie brauchen nicht mehrere
                    Tage zu warten, wie wie es bei anderen Handelsplattformen der Fall ist.')}}
                </p>
                <p>
                    {{aiTrans('Um die Einzahlung vorzunehmen, gehen Sie auf Ihre Kontoseite. Klicken Sie auf den
                    Teil, auf dem "Einzahlung vornehmen" steht. Als nächstes wählen Sie Ihre
                    Zahlungsoption. Geben Sie den Betrag ein, den Sie einzahlen möchten. Füllen Sie
                    die die geforderten Angaben aus und vervollständigen Sie die
                    Sicherheitsanforderungen. Schließlich bestätigen Sie Ihre Zahlung und gehen zur
                    die Investition.')}}
                </p>
                <p>
                    {{aiTrans('Sie können sich auch für eine Banküberweisung entscheiden, was für größere
                    Einzahlungen sinnvoll sein kann. Bedenken Sie jedoch, dass eine Banküberweisung
                    länger dauern kann, je nach Bank und Land, in dem Sie Ihren Wohnsitz haben Land.')}}
                </p>
                <p>

                    {{ aiTrans(
                        'Wann immer Sie eine Einzahlung tätigen, wird [website_title] keine Gebühr aus von
                    Ihrer Einzahlung. Alle Gelder, die Sie auf Ihr Konto einzahlen bleiben unter Ihrer
                    Kontrolle. Die Plattform versucht, sicherzustellen dass eine Einzahlung so einfach
                    und unkompliziert wie möglich bleibt wie möglich',
                        $locale,
                        [
                            'website_title' => $website_title,
                        ],
                    ) }}
                    
                </p>
            </div>

            <div>
                <div class="uk-flex-middle uk-grid-small" uk-grid>
                    <div class="uk-width-auto">
                        <div class="icon icon-big">
                            <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-6.svg" alt="">
                        </div>
                    </div>
                    <div class="uk-width-expand">
                        <h3 class="block__title">{{aiTrans('4. Sie fühlen sich nicht sicher? Kein Problem')}}</h3>
                    </div>
                </div>

                <p>

                    {{ aiTrans(
                        'Angenommen, Sie trauen sich nicht, in Bitcoin zu investieren Bitcoin zu
                    investieren, weil es für Sie neu ist. Sie wollen kein Geld verlieren Geld
                    verlieren. Im Gegensatz zu anderen Plattformen, die Sie zwingen würden und
                    kostspielige Fehler zu machen, bietet [website_title] einen einen Simulator, mit dem
                    Sie Ihre Handelsstrategie testen können.',
                        $locale,
                        [
                            'website_title' => $website_title,
                        ],
                    ) }}
                    
                </p>
                <p>
                    {{aiTrans('Sie testen die Strategie an realen Marktdaten, so dass Sie lernen, wie man
                    gewinnbringend handelt, ohne ein Vermögen in der Lernkurve zu verlieren. Mit dem
                    Simulator können Sie Fehler machen, während Sie Fehler machen, vor allem wenn Sie
                    Anfänger sind, werden Sie Fehler machen.')}}
                </p>
                <p>
                    {{aiTrans('Wie funktioniert der Simulator? Er funktioniert genauso wie der reale Markt, aber
                    das Risiko, Geld zu verlieren, ist ausgeschlossen. Sie erhalten weiterhin die
                    Handelsinstrumente, Kontrollen und Anzeigen, aber der Simulator gibt Ihnen die
                    Möglichkeit, praktikable Strategien zu entwickeln, bevor Sie bevor Sie mit echtem
                    Geld handeln.')}}
                </p>
            </div>

        </div>

    </div>


    <div class="uk-margin-large-top">
        <div class="uk-container">

            <h2 class="title-2 uk-text-center"> <b class="accent">{{aiTrans('Vorteile')}}</b> 
                {{ aiTrans(
                    'von [website_title]',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}</h2>

            <p class="uk-text-center">

                {{ aiTrans(
                    'Bei [website_title] gibt es ein paar klare Vorteile, die wir gerne für Leute hervorheben
                möchten, die eine gute Bitcoin-Handelsplattform Plattform. ',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
                <br>
                {{aiTrans('Einige der Gründe, warum Sie bei uns investieren sollten, sind:')}}
            </p>


            <div class="uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-5@m uk-margin-large-top" uk-grid>

                <div>
                    <div class="benefits-box uk-text-center">
                        <div class="icon icon-big">
                            <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-8.svg" alt="">
                        </div>
                        <h3>{{aiTrans('Keine Handels- oder Plattformgebühren')}}</h3>
                    </div>
                </div>

                <div>
                    <div class="benefits-box uk-text-center">
                        <div class="icon icon-big">
                            <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-9.svg" alt="">
                        </div>
                        <h3>{{aiTrans('Navigierbare Schnittstelle')}}</h3>
                    </div>
                </div>

                <div>
                    <div class="benefits-box uk-text-center">
                        <div class="icon icon-big">
                            <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-11.svg" alt="">
                        </div>
                        <h3>{{aiTrans('Das Angebot gilt für die meisten Länder (außer den USA)')}}</h3>
                    </div>
                </div>

                <div>
                    <div class="benefits-box uk-text-center">
                        <div class="icon icon-big">
                            <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-6.svg" alt="">
                        </div>
                        <h3>{{aiTrans('Mit dem Simulator können Sie profitable Handelsstrategien entwickeln')}}</h3>
                    </div>
                </div>

                <div>
                    <div class="benefits-box uk-text-center">
                        <div class="icon icon-big">
                            <img src="{{ asset('frontend/assets/de/dist') }}/images/icon-12.svg" alt="">
                        </div>
                        <h3>{{aiTrans('Erfahrene Kundenbetreuer verfügbar')}}</h3>
                    </div>
                </div>

            </div>

            <p>
                {{ aiTrans(
                    '[website_title] rationalisiert den Handelsprozess und eliminiert viele der Probleme, die Sie
                bei anderen Plattformen haben könnten. Die Handelsplattform wurde so konzipiert, dass
                Sie die beste Sicht auf den Markt erhalten den Markt erhalten und während des Handels
                fundierte Entscheidungen treffen können.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>

        </div>
    </div>
</section>


<!-- Faq -->

<section class="faq-section uk-section">
    <div class="uk-container">

        <div uk-grid>

            <div class="uk-width-1-4@s">
                <h2 class="title-2">{{aiTrans('FAQ’s')}}</h2>
                <p>
                    {{aiTrans('Haben Sie etwas im Sinn? Kontaktieren Sie uns per E-Mail')}} <a href="mailto:support{{'@'.$website_title}}" class="accent mail-link">support<span class="domain">{{'@'.$website_title}}</span> </a>
                </p>
                <a href="#hero" uk-scroll class="btn btn-cta">
                    {{aiTrans('MEHR LERNEN')}}
                </a>

            </div>

            <div class="uk-width-expand@s">
                <ul uk-accordion="collapsible: false: ; active: false">

                    <li>
                        <a class="uk-accordion-title" href>
                            {{ aiTrans(
                                '1. Können Sie die Plattform von [website_title] kostenlos nutzen?',
                                $locale,
                                [
                                    'website_title' => $website_title,
                                ],
                            ) }}
                            </a>
                        <div class="uk-accordion-content">
                            <p>
                                {{ aiTrans(
                                    'Im Gegensatz zu anderen Plattformen, die Ihnen eine Gebühr für den Handel berechnen könnten, [website_title] hat keine Handelsgebühren und verlangt keine für die Registrierung oder versteckte Gebühren an. Sie müssen nicht einmal Geld einzahlen, um mit dem Handel zu beginnen, denn Sie können mit dem mit dem Simulator beginnen, um Ihre Handelsstrategien auszuprobieren ohne dabei Geld zu verlieren',
                                    $locale,
                                    [
                                        'website_title' => $website_title,
                                    ],
                                ) }}
                                </p>
                        </div>
                    </li>

                    <li>
                        <a class="uk-accordion-title" href>{{aiTrans('2. Sind Kryptowährungen eine gute Investition?')}}</a>
                        <div class="uk-accordion-content">
                            <p>{{aiTrans('Der Einstieg in Kryptowährungen sollte mit einem realistischen Alle Investitionen, auch Kryptowährungen, sind mit einem gewissen Risiko. Das Risiko bei Kryptowährungen bezieht sich auf die Volatilität der digitalen Vermögenswerte. Sie werden erleben, wie Kryptowährungen aus dem Nichts aufsteigen und ohne Vorwarnung abstürzen. Diese Volatilität macht eine gute Handelsmöglichkeit, wenn man weiß, was man tut. Krypto hilft Ihnen, Ihr Portfolio zu diversifizieren, aber wie stark Sie in diesen Markt investieren wollen, hängt von Ihnen ab.')}}</p>
                        </div>
                    </li>

                    <li>
                        <a class="uk-accordion-title" href>{{aiTrans('3. Wie kann ich eine Einzahlung oder Abhebung vornehmen?')}}</a>
                        <div class="uk-accordion-content">
                            <p>
                                {{ aiTrans(
                                    'Um eine Einzahlung zu tätigen, müssen Sie ein Minimum von $250. Das Geld, das
                                    Sie einzahlen, haben Sie immer unter Kontrolle. Mit [website_title] können Sie
                                    Geld einzahlen und abheben nach eigenem Ermessen. Besuchen Sie einfach das
                                    Dashboard und klicken Sie auf die Schaltfläche "Einzahlung" oder "Bargeld
                                    abheben".',
                                    $locale,
                                    [
                                        'website_title' => $website_title,
                                    ],
                                ) }}
                            </p>
                            <p>

                                {{ aiTrans(
                                    'Wenn Sie mit einer Debit- oder Kreditkarte einzahlen, sollten Sie sollte der
                                    Betrag sofort auf Ihrem Konto erscheinen. Wenn Sie eine Bank Überweisung, kann
                                    es je nach Bank und Herkunftsland länger Ihrem Herkunftsland. Abhebungen bei
                                    [website_title] geschehen mit fast genauso viel Leichtigkeit. Der Unterschied ist,
                                    dass es dass es normalerweise etwa 24 Stunden dauert, bis das Geld überwiesen
                                    ist.',
                                    $locale,
                                    [
                                        'website_title' => $website_title,
                                    ],
                                ) }}
                                
                            </p>

                        </div>
                    </li>

                    <li>
                        <a class="uk-accordion-title" href>
                            
                            
                            {{ aiTrans(
                                '4. Gibt es von [website_title] eine mobile Version?',
                                $locale,
                                [
                                    'website_title' => $website_title,
                                ],
                            ) }}</a>
                        <div class="uk-accordion-content">
                            <p>
                                {{aiTrans('Vorausgesetzt, Sie können mit einer stabilen Verbindung und einem stabilen
                                Browser arbeiten, können Sie sich direkt von Ihrem mobilen Gerät aus bei Everix
                                Edge anmelden, um um Geschäfte zu tätigen, während Sie im Büro festsitzen oder
                                auf Ihr Essen im Restaurant warten. Nehmen Sie es mit auf Reisen, damit Sie
                                keine Gelegenheiten verpassen!')}}</p>
                        </div>
                    </li>

                </ul>
            </div>

        </div>
    </div>
</section>


<section class="uk-section">
    <div class="uk-container">
        <h2 class="title-2 uk-text-center">{{$website_title}} <b class="accent">{{aiTrans('Wichtige Punkte')}}</b></h2>
        <table class="point">
            <tbody>
                <tr>
                    <td>
                        <div class="icon__row">
                            <div class="icon icon-1 icon-circle">
                                <img src="{{ asset('frontend/assets/de/dist') }}/images/money.svg" alt="" loading="lazy">
                            </div>
                            <h3 class="title-3">{{aiTrans('Plattform Kosten')}}</h3>
                        </div>
                    </td>
                    <td>
                        <p>{{aiTrans('Keine Kosten für die Erstellung eines Kontos')}}</p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="icon__row">
                            <div class="icon icon-1 icon-circle">
                                <img src="{{ asset('frontend/assets/de/dist') }}/images/mob-desc.svg" alt="" loading="lazy">
                            </div>
                            <h3 class="title-3">{{aiTrans('Plattform-Kategorie')}}</h3>
                        </div>
                    </td>
                    <td>
                        <p>{{aiTrans('Web- und mobilorientierte Plattform')}}</p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="icon__row">
                            <div class="icon icon-1 icon-circle">
                                <img src="{{ asset('frontend/assets/de/dist') }}/images/trading-assets.svg" alt="" loading="lazy">
                            </div>
                            <h3 class="title-3">{{aiTrans('Plattform Typ')}}</h3>
                        </div>
                    </td>
                    <td>
                        <p>{{aiTrans('Kryptowährungswerte')}}</p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="icon__row">
                            <div class="icon icon-1 icon-circle">
                                <img src="{{ asset('frontend/assets/de/dist') }}/images/fees.svg" alt="" loading="lazy">
                            </div>
                            <h3 class="title-3">{{aiTrans('Zugehörige Gebühren')}}</h3>
                        </div>
                    </td>
                    <td>
                        <p>{{aiTrans('Keine Gebühren')}}</p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="icon__row">
                            <div class="icon icon-1 icon-circle">
                                <img src="{{ asset('frontend/assets/de/dist') }}/images/payments.svg" alt="" loading="lazy">
                            </div>
                            <h3 class="title-3">{{aiTrans('Akzeptierte Zahlungsarten')}}</h3>
                        </div>
                    </td>
                    <td>
                        <p>{{aiTrans('Kreditkarte, Debitkarte und Banküberweisung')}}</p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="icon__row">
                            <div class="icon icon-1 icon-circle">
                                <img src="{{ asset('frontend/assets/de/dist') }}/images/countries.svg" alt="" loading="lazy">
                            </div>
                            <h3 class="title-3">{{aiTrans('Verfügbare Länder')}}</h3>
                        </div>
                    </td>
                    <td>
                        <p>{{aiTrans('In vielen Ländern der Welt erhältlich.')}}</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</section>
@endsection
