@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title $website_name | Bedingungen und Konditionen" }}</title>
    <meta name="description" content="{{ "Auf $website_title geben wir detaillierte Beschreibungen zu Ihren Rechten und Pflichten, sowie sicheren Handlungen. Sehen Sie sich unsere Nutzungsrichtlinien an." }}" />
@endpush
@section('content')
    <section class="uk-section terms">
        <div class="uk-container">

            <h1 class="title-2">{{ aiTrans('Nutzungsbedingungen') }}</h1>
            <h2 class="title-3">{{ aiTrans('1. Allgemeines') }}</h2>
            <p class="pl-16">{{ aiTrans('1.1. Willkommen bei') }} <span class="domain">{{ $website_title }}</span> (der
                "Website").</p>
            <p class="pl-16">{{ aiTrans('Unsere E-Mail') }} <a href="mailto:support{{ '@' . $website_title }}"
                    class="accent mail-link">support@<span class="domain">{{ $website_title }}</span> </a></p>
            <p class="pl-16">
                {{ aiTrans('1.2. Die Website enthält Informationen über Plattformen von Dritten (die "Drittanbieter-Plattformen") für den Handel (die "Dienste").') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('1.3. Diese Nutzungsbedingungen (die "Bedingungen") regeln Ihre ("Sie", "Ihr" oder "Benutzer") Nutzung der Website oder der Dienste. Diese Bedingungen sollten von Ihnen vor der Nutzung der Dienste in ihrer Gesamtheit sorgfältig gelesen werden. Bitte beachten Sie, dass diese Bedingungen einen rechtlich verbindlichen Vertrag zwischen Ihnen und dem Betreiber der Website darstellen, und dass Sie, wenn Sie mit einer Bestimmung dieser Bedingungen nicht einverstanden sind, die Nutzung der Website sofort einstellen müssen. Durch die Nutzung der Website stimmen Sie den Bedingungen zu, die von Zeit zu Zeit geändert werden können.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('Diese Bedingungen beinhalten unsere Datenschutzrichtlinie und durch die Zustimmung zu diesen Bedingungen bestätigen Sie, dass Sie auch unsere Datenschutzrichtlinie akzeptieren und zustimmen (Sie können unsere Datenschutzrichtlinie einsehen).') }}
            </p>
            <h2 class="title-3">{{ aiTrans('2. Berechtigung') }}</h2>
            <p class="pl-16">
                {{ aiTrans('2.1. Sie sind nur berechtigt, die Website zu nutzen, wenn Sie alle folgenden Bedingungen erfüllen:') }}
            </p>
            <p class="pl-32">{{ aiTrans('2.1.1. Sie sind mindestens 18 Jahre alt;') }}</p>
            <p class="pl-32">
                {{ aiTrans('2.1.2. Sie haben das Recht, die Autorität und die Fähigkeit, diese Bedingungen einzugehen und alle Bedingungen und Konditionen dieser Bedingungen einzuhalten;') }}
            </p>
            <p class="pl-32">
                {{ aiTrans('2.1.3. Ihnen ist es nicht untersagt, die Website und/oder die Dienste gemäß den Gesetzen des Landes, in dem Sie wohnen oder sich bei der Nutzung der Website befinden, zu nutzen.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('2.2. Wir geben keine Zusicherungen oder Gewährleistungen, ausdrücklich oder stillschweigend, hinsichtlich der Legalität der Website und/oder der Dienste und/oder der Nutzung der Website und/oder der Dienste durch Personen und sind nicht verantwortlich für eine illegale Nutzung der Website und/oder der Dienste durch den Benutzer.') }}
            </p>
            <h2 class="title-3">{{ aiTrans('3. Eingeschränkte Gebiete') }}</h2>
            <p class="pl-16">
                {{ aiTrans('3.1. Unbeschadet des Vorstehenden können wir nach eigenem Ermessen die Verfügbarkeit der Website und/oder der Dienste (oder eines Teils davon) auf: (i) Benutzer in bestimmten Gebieten (den "Eingeschränkten Gebieten") und (ii) Personen, von denen wir vernünftigerweise glauben, dass sie rechtlichen, regulatorischen, reputationsbezogenen oder wirtschaftlichen Risiken ausgesetzt sein könnten, einschränken.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('3.2. Wir können zusätzliche Anforderungen oder Bedingungen auferlegen, bevor wir Benutzer akzeptieren, die in bestimmten Ländern wohnen oder sich von dort aus anmelden, nach eigenem Ermessen. Darüber hinaus wird anerkannt, dass, wenn Benutzer in die Eingeschränkten Gebiete reisen, die Website und/oder die Dienste möglicherweise nicht verfügbar sind und/oder dort blockiert werden können.') }}
            </p>
            <h2 class="title-3">{{ aiTrans('4. Verbotene Aktivitäten') }}</h2>
            <p class="pl-16">
                {{ aiTrans('4.1. Sie verpflichten sich, die Website und die Dienste respektvoll zu nutzen, und Sie verpflichten sich, nicht zu:') }}
            </p>
            <p class="pl-32">
                {{ aiTrans('4.1.1. Einen Link zur Website herzustellen und/oder die Website zum Hochladen, Herunterladen, Verteilen, Veröffentlichen oder Übertragen von (a) Informationen oder anderen Materialien in einer Weise zu nutzen, die Rechte, einschließlich geistiger Eigentumsrechte, Datenschutzrechte oder anderer Rechte verletzt; (b) Informationen oder andere Materialien zu veröffentlichen oder zu verwenden, die aufgrund ihrer Bedrohung, Schädigung, Beleidigung, Verleumdung, Diskriminierung oder unangemessenen Inhalte verboten sind; (c) Informationen oder andere Materialien hochzuladen, die einen Virus oder andere Software enthalten, die unsere Computersysteme oder die Dritter beschädigen könnte, oder in einer Weise, die andere daran hindern könnte, die Website zu nutzen; (d) Informationen oder andere Materialien zu veröffentlichen, die gegen das Gesetz verstoßen; oder (e) Informationen oder andere Materialien zu veröffentlichen, die eine Art von Werbung ohne unsere vorherige schriftliche Genehmigung enthalten;') }}
            </p>
            <p class="pl-32">
                {{ aiTrans('4.1.2. Jegliche Zuordnungen, rechtliche Hinweise oder andere urheberrechtliche Bezeichnungen oder Etiketten auf der Website zu löschen oder zu ändern;') }}
            </p>
            <p class="pl-32">{{ aiTrans('4.1.3. Die Dienste über eine andere Schnittstelle als die Website zu nutzen;') }}</p>
            <p class="pl-32">{{ aiTrans('4.1.4. Die Nutzung der Website und/oder der Dienste durch andere Benutzer zu stören;') }}
            </p>
            <p class="pl-32">
                {{ aiTrans('4.1.5. Bots oder andere automatisierte Methoden zu verwenden, um auf die Website und/oder die Dienste zuzugreifen oder sie zu nutzen;') }}
            </p>
            <p class="pl-32">
                {{ aiTrans('4.1.6. Ohne unsere ausdrückliche Genehmigung Materialien hochzuladen oder zu übertragen (oder zu versuchen, sie hochzuladen oder zu übertragen), die als passive oder aktive Informationssammlung oder Übertragungsmechanismus fungieren, einschließlich, aber nicht beschränkt auf, Web Bugs, Cookies oder andere ähnliche Spyware-Tools;') }}
            </p>
            <p class="pl-32">
                {{ aiTrans('4.1.7. Sich an „Framing“, „Mirroring“ oder anderweitigem Simulieren des Aussehens oder der Funktion der Dienste zu beteiligen;') }}
            </p>
            <p class="pl-32">
                {{ aiTrans('4.1.8. Gegen geltende Gesetze oder Vorschriften zu verstoßen, illegale Aktivitäten zu fördern oder zu ermutigen, einschließlich, aber nicht beschränkt auf Urheberrechtsverletzungen, Markenverletzungen, Verleumdung, Verletzung der Privatsphäre, Identitätsdiebstahl, Hacking, Cracking oder Verbreitung von gefälschter Software;') }}
            </p>
            <p class="pl-32">
                {{ aiTrans('4.1.9. Änderungen vorzunehmen und/oder in irgendeiner Weise in den Quellcode der Website einzugreifen und Software und/oder Anwendungen hochzuladen, die der Website oder Dritten schaden oder diese schädigen könnten;') }}
            </p>
            <p class="pl-32">
                {{ aiTrans('4.1.10. Jegliche Software oder andere Technologie, die in der Website enthalten ist oder zur Bereitstellung der Dienste verwendet wird, zu zerlegen, dekompilieren oder anderweitig zurückzuentwickeln.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('4.2. Sie erkennen an, dass wir, ohne dass es die anderen Rechte, die wir haben, beeinträchtigt, falls wir besorgt sind, dass Ihre Nutzung der Website nicht mit den Bestimmungen dieser Bedingungen oder den geltenden Gesetzen übereinstimmt, Ihre Nutzung der Website oder der Dienste verfolgen, Ihnen den Zugriff auf die Website verwehren, Ihr Verhalten auf der Website an Dritte übertragen und alle anderen Maßnahmen ergreifen können, die wir für angemessen halten, um unser Eigentum und/oder Rechte und/oder die Rechte Dritter zu schützen.') }}
            </p>
            <h2 class="title-3">{{ aiTrans('5. Geistige Eigentumsrechte') }}</h2>
            <p class="pl-16">
                {{ aiTrans('5.1. Die Website und ihr Inhalt, einschließlich Videomaterialien, Texte, Fotos, Logos, Designs, Musik, Töne, Figuren, Marken und anderer Inhalte, die in der Website verkörpert sind, sind durch unsere oder die geistigen Eigentumsrechte Dritter geschützt.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('5.2. Zwischen uns und dem Benutzer behalten wir alle Rechte, Titel und Interessen an der Website und den Diensten. Die Nutzung der Website und/oder der Dienste verleiht dem Benutzer keine der in der Website und/oder den Diensten verkörperten geistigen Eigentumsrechte, außer dem Recht, die Website und/oder die Dienste gemäß den Bedingungen dieser Bedingungen zu nutzen.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('5.3. Der Benutzer darf die Website und/oder die Dienste nur für persönliche und nichtkommerzielle Zwecke nutzen.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('5.4. Sie dürfen weder selbst noch durch Dritte Änderungen, Dekompilierungen, Zerlegungen, Rückentwicklungen, Kopien, Übertragungen, die Erstellung abgeleiteter Werke, Vermietungen, Unterlizenzen, Verteilungen, Reproduktionen, Veröffentlichungen, Scraping, Downloads, Anzeigen, Übertragungen, Veröffentlichungen, Vermietungen oder Verkäufe in irgendeiner Form oder durch irgendein Mittel, ganz oder teilweise, für einen anderen Zweck als die Nutzung der Website oder der Dienste gemäß den Bedingungen vornehmen oder anderweitig irgendwelche Inhalte der Website ohne unsere ausdrückliche, vorherige schriftliche Genehmigung ausnutzen.') }}
            </p>
            <h2 class="title-3">{{ aiTrans('6. Haftungsbeschränkung') }}</h2>
            <p class="pl-16">
                {{ aiTrans('6.1. Ihre Nutzung der Website und/oder der Dienste erfolgt auf Ihr eigenes Risiko. Soweit gesetzlich zulässig, lehnen wir alle Gewährleistungen, ausdrücklich oder stillschweigend, in Verbindung mit der Website und den Diensten sowie Ihrer Nutzung ab, einschließlich stillschweigender Gewährleistungen für Handelsfähigkeit, Titel, Eignung für einen bestimmten Zweck oder Nichtverletzung, Nützlichkeit, Autorität, Genauigkeit, Vollständigkeit und Aktualität. Dementsprechend werden die Dienste, einschließlich aller Inhalte und Funktionen, die auf oder über die Website bereitgestellt, aufgerufen oder gesendet werden, „wie sie sind“, „wie verfügbar“ und „mit allen Fehlern“ bereitgestellt.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('6.2. Ohne das Vorstehende einzuschränken, übernehmen wir keine Haftung oder Verantwortung für (a) Fehler, Irrtümer oder Ungenauigkeiten von Inhalten, die in der Website enthalten sind; (b) Unterbrechungen oder das Ende der Übertragung zur oder von der Website oder über die Dienste; (c) Fehler, Viren, Trojanische Pferde oder ähnliches, die von Dritten an oder über die Website oder die Dienste übertragen werden können.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('6.3. Sie erklären sich damit einverstanden, uns von jeglichen Verlusten, die Ihnen und/oder Dritten direkt oder indirekt durch die Nutzung der Website und/oder der Dienste entstehen, freizustellen, und Sie tragen die alleinige Verantwortung für Ihre Entscheidungen, die auf den Inhalten der Website und/oder der Dienste beruhen.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('6.4. In keinem Fall haften wir Ihnen oder Dritten für spezielle, direkte, indirekte, zufällige, spezielle, strafende oder Folgeschäden jeglicher Art, einschließlich entgangener Gewinne oder Datenverluste, die aus Ihrer Nutzung der Website und/oder der Dienste oder anderen Materialien, die auf der Website oder im Rahmen der Dienste verfügbar sind, resultieren, unabhängig davon, ob diese auf Gewährleistung, Vertrag, unerlaubter Handlung oder einer anderen rechtlichen Theorie basieren, und unabhängig davon, ob wir auf die Möglichkeit solcher Schäden hingewiesen wurden, und in Fällen, in denen eine gerichtliche Autorität uns haftbar macht, ist die Haftung auf 100 USD begrenzt. Diese Haftungsbeschränkung gilt in vollem Umfang, soweit es das geltende Recht in der jeweiligen Gerichtsbarkeit zulässt.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('6.5. Wir sind nicht verantwortlich für Probleme oder technische Fehlfunktionen von Telefon- oder Netzwerkleitungen, Computer-Onlinesystemen, Servern oder Anbietern, Hardware, Software, Ausfälle aufgrund technischer Probleme oder Verkehrsstaus im Internet (oder Internetunzugänglichkeit) oder Inkompatibilität zwischen der Website oder den Diensten und Ihrem Browser und/oder anderen Geräten. Ohne das Vorstehende einzuschränken, übernehmen wir keine Verantwortung oder Risiken für Ihre Nutzung des Internets.') }}
            </p>
            <h2 class="title-3">{{ aiTrans('7. Dienste oder Inhalte Dritter') }}</h2>
            <p class="pl-16">
                {{ aiTrans('7.1. Während Sie die Dienste nutzen, können Sie Inhalte oder Dienste von Dritten sehen, einschließlich Werbung und Bewertungen zu den Drittanbieter-Plattformen.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('7.2. Wir kontrollieren, unterstützen oder übernehmen solche Inhalte oder Dienste nicht, und sie sind möglicherweise nicht immer genau oder aktuell.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('7.3. Dementsprechend empfehlen wir Ihnen, alle Informationen unabhängig zu überprüfen, bevor Sie sich darauf verlassen, und alle Entscheidungen oder Handlungen, die auf solchen Informationen basieren, liegen in Ihrer alleinigen Verantwortung.') }}
            </p>
            <h2 class="title-3">{{ aiTrans('8. Links') }}</h2>
            <p class="pl-16">
                {{ aiTrans('8.1. Die Website kann Links, Inhalte, Werbung, Promotions, Logos und andere Materialien von anderen Websites oder Software enthalten, die von Dritten kontrolliert oder angeboten werden (die „Links“). Wir warnen Sie, sicherzustellen, dass Sie die Risiken verstehen, die mit der Nutzung solcher Websites, Software oder Materialien verbunden sind, bevor Sie Inhalte abrufen, verwenden, sich darauf verlassen oder etwas über diese Websites oder Software erwerben. Solche Links werden ausschließlich zu Ihrem Komfort bereitgestellt, und Sie stimmen zu, dass Sie uns unter keinen Umständen für Verluste oder Schäden haftbar machen werden, die durch die Nutzung oder das Vertrauen auf Inhalte, Waren oder Dienstleistungen entstehen, die auf anderen Websites oder Software verfügbar sind.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('8.2. Die Aufnahme von Links in die Website stellt keine Billigung, Genehmigung, Sponsoring, Zugehörigkeit oder eine andere Verbindung zwischen uns und diesen Websites, Software oder deren Betreibern dar.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('8.3. Wir haben keine derart Links überprüft und sind nicht verantwortlich für Inhalte der Websites oder Software, auf die verwiesen wird. Wir warnen Sie, sicherzustellen, dass Sie die Risiken verstehen, die mit der Nutzung solcher Websites oder Software verbunden sind, bevor Sie Inhalte abrufen, verwenden, sich darauf verlassen oder etwas über diese Websites oder Software erwerben. Unter keinen Umständen werden Sie uns für Verluste oder Schäden haftbar machen, die durch die Nutzung oder das Vertrauen auf Inhalte, Waren oder Dienstleistungen entstehen, die auf anderen Websites verfügbar sind.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('8.4. Es liegt in Ihrer Verantwortung, die Bedingungen und Richtlinien solcher Drittanbieter-Websites zu überprüfen, und wir empfehlen Ihnen dringend, diese sorgfältig zu überprüfen, bevor Sie mit solchen Drittanbietern in Kontakt treten.') }}
            </p>
            <h2 class="title-3">{{ aiTrans('9. Sonstiges') }}</h2>
            <p class="pl-16">
                {{ aiTrans('9.1. Wir können nach eigenem Ermessen jederzeit die Dienste ändern, modifizieren oder einstellen und/oder neue Dienste einführen. Wir haften nicht für Verluste, die Ihnen aufgrund solcher Änderungen entstehen, und Sie haben diesbezüglich keine Ansprüche gegen uns.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('9.2. Wir können diese Bedingungen von Zeit zu Zeit ändern. Wenn wir dies tun, werden wir Ihnen durch Veröffentlichung der aktuellsten Version und Anpassung des Datums oben auf dieser Seite eine Mitteilung machen, und alle Änderungen treten sofort nach der Veröffentlichung in Kraft. Durch die fortgesetzte Nutzung der Website nach Inkrafttreten von Änderungen gelten Sie als einverstanden mit den geänderten Bedingungen.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('9.3. Der Benutzer stimmt zu, dass die Übertragung von Informationen zur oder von der Website keine Beziehung zwischen den Parteien begründet, die von den in diesen Bedingungen festgelegten abweicht.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('9.4. Diese Bedingungen und die Datenschutzrichtlinie, die von Zeit zu Zeit geändert werden, bilden die einzigen gültigen Vereinbarungen zwischen uns und dem Benutzer, und keine Erklärung, Versprechen, Zustimmung oder Verpflichtung, weder schriftlich noch mündlich, die nicht in den Bedingungen oder in der Datenschutzrichtlinie enthalten ist, wird für die Parteien verbindlich sein.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('9.5. Kein Versäumnis oder keine Verzögerung unsererseits bei der Ausübung eines Rechts, einer Befugnis oder eines Rechtsbehelfs wird als Verzicht darauf gelten, noch wird eine einmalige oder teilweise Ausübung eines solchen Rechts, einer solchen Befugnis oder eines solchen Rechtsbehelfs eine weitere oder andere Ausübung oder die Ausübung eines anderen Rechts, einer anderen Befugnis oder eines anderen Rechtsbehelfs ausschließen.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('9.6. Wenn eine Bestimmung dieser Bedingungen von einem zuständigen Gericht für nicht durchsetzbar nach geltendem Recht gehalten wird, wird diese Bestimmung von diesen Bedingungen ausgeschlossen, und der Rest dieser Bedingungen wird so interpretiert, als ob diese Bestimmung ausgeschlossen wurde, und wird in Übereinstimmung mit ihren Bedingungen durchsetzbar sein; vorausgesetzt, dass in einem solchen Fall diese Bedingungen so interpretiert werden, dass sie der Bedeutung und der Absicht der ausgeschlossenen Bestimmung, wie sie von einem solchen zuständigen Gericht festgestellt wird, in dem größtmöglichen Umfang entsprechen, der mit dem geltenden Recht vereinbar und erlaubt ist.') }}
            </p>
            <p class="pl-16">
                {{ aiTrans('9.7. Wir können alle unsere Rechte und Pflichten aus diesen Bedingungen an Dritte übertragen oder abtreten; unbeschadet des Vorstehenden können die Website und/oder die Dienste von Dritten betrieben werden. Sie dürfen in keiner Weise Ihre Rechte oder Pflichten aus diesen Bedingungen übertragen, abtreten oder verpfänden.') }}
            </p>

        </div>
    </section>
@endsection
