@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Hafðu samband við okkur" }}</title>
    <meta name="description" content="{{ "Heimsækjaðu okkur á $website_title til að fá stuðning og svar við spurningum þínum um dulritunargjaldmiðlaviðskipti. Við erum alltaf hér fyrir þig!" }}" />
@endpush
@section('content')

<section class="bnr-section">
    <div class="uk-container">
        <div class="uk-text-center">
            <h1>Hafðu samband – {{ $website_title }}</h1>
        </div>
    </div>
</section>

<section class="uk-section uk-section-muted">
    <div class="uk-container">

        <div class="uk-flex-middle" uk-grid>

            <div class="uk-width-expand@s">
                <h2 class="tg f35">
                    
                    {{ aiTrans(
                        'Þakka þér fyrir áhuga þinn á [website_title]',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </h2>
                <p>
                    {{ aiTrans(
                        'Hjá [website_title] erum við staðráðin í að veita framúrskarandi þjónustuver til að auka viðskiptaupplifun þína og opna hámarks viðskiptamöguleika þína.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
                <p>{{aiTrans('Meginmarkmið okkar er að gera þér kleift að hámarka getu kerfisins og njóta óaðfinnanlegrar, notendavænnar ferð. Til að ná þessu höfum við stofnað til samstarfs við virta miðlara sem eru virtir og með leyfi, sem tryggir að þú fáir sérfræðiaðstoð í stafrænu eignaviðskiptum þínum. Þessi virðisaukandi þjónusta er veitt þér sem kurteisi, algjörlega þér að kostnaðarlausu.')}}</p>
                <p>
                    {{ aiTrans(
                        'Vertu viss um að teymi okkar sérfræðinga er staðráðið í að mæta þörfum þínum, óháð kunnáttustigi, þekkingu eða reynslu. Við leitumst við að fara umfram það til að tryggja að þú fáir þá leiðsögn og stuðning sem nauðsynleg er fyrir farsæla og gefandi viðskiptaupplifun. Treystu á [website_title] til að vera traustur félagi þinn í gegnum viðskiptaferðina þína.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
            </div>

            <div class="uk-width-auto@s">
                <div class="contact-form">
                    <form action="" class="login-from uk-grid-small" uk-grid id="opt-form" method="post" name="optInForm">

                        <div class="uk-width-1-1@s">
                            <label for="form-fyrsta">Fyrsta {{aiTrans('nafn')}}</label>
                            <input class="uk-input" placeholder="Fyrsta nafn" data-input="fyrsta" id="form-fyrsta" name="fyrsta"
                                type="text">
                        </div>

                        <div class="uk-width-1-1@s">
                            <label for="form-eftirnafn">{{aiTrans('Eftirnafn')}}</label>
                            <input class="uk-input" placeholder="Eftirnafn" data-input="eftirnafn" id="form-eftirnafn" name="eftirnafn"
                                type="text">
                        </div>

                        <div class="uk-width-1-1@s">
                            <label for="form-email">{{aiTrans('Tölvupóstur')}}</label>
                            <input class="uk-input" placeholder="Tölvupóstur" data-input="email" id="form-email" name="email"
                                type="email">
                        </div>

                        <div class="uk-width-1-1@s">
                            <label for="form-phone">{{aiTrans('phone')}}</label>
                            <input  class="uk-input phonejs" placeholder="100 123 4567" data-input="phone"  name="phone"
                                type="text">
                        </div>

                        <div class="uk-width-1-1@s">
                            <label for="form-skilaboð">{{aiTrans('Skilaboð')}}</label>
                            <textarea class="uk-textarea" rows="5" placeholder="Skilaboð" name="skilaboð"
                                type="textarea"></textarea>
                        </div>


                        <div class="uk-width-1-1@s">
                            <button class="from-submit" data-button="submit" id="optInForm-btn">
                                {{aiTrans('Senda skilaboð')}} </button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>

</section>


<section class="uk-section uk-section-dark f17">
    <div class="uk-container">
        <h2 class="tg">{{ $website_title }} tengiliðaleiðbeiningar</h2>
        <h3 class="tg">Vinsamlegast gefðu þér tíma til að lesa í gegnum þessar leiðbeiningar um tengiliðaupplýsingar, svo að spurningunni þinni sé svarað af sérstakri þjónustudeild, í samræmi við viðfangsefnið.</h3>
        <p>*Ef þú þarft frekari upplýsingar, aðstoð við skráningu eða ef þú lendir í tæknilegum vandamálum, vinsamlegast notaðu formið hér að neðan til að hafa samband við okkur; meðlimur þjónustudeildar mun svara tafarlaust.</p>
    </div>
</section>


<section class="uk-section">
    <div class="uk-container">
        <div class="uk-grid-large uk-child-width-1-2@s" uk-grid>

            <div>
                <div class="uk-grid-small uk-flex-middle con-info" uk-grid>
                    <div class="uk-width-auto@s">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" aria-hidden="true">
                                <path d="M464 64H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zm0 48v40.805c-22.422 18.259-58.168 46.651-134.587 106.49-16.841 13.247-50.201 45.072-73.413 44.701-23.208.375-56.579-31.459-73.413-44.701C106.18 199.465 70.425 171.067 48 152.805V112h416zM48 400V214.398c22.914 18.251 55.409 43.862 104.938 82.646 21.857 17.205 60.134 55.186 103.062 54.955 42.717.231 80.509-37.199 103.053-54.947 49.528-38.783 82.032-64.401 104.947-82.653V400H48z" fill="currentColor"></path>
                            </svg></span>
                    </div>
                    <div class="uk-width-expand@s">
                        <h3>Tölvupóstur</h3>
                        <a href="mailto:support{{'@'. $website_title }}">support{{'@'. $website_title }}</a>
                    </div>
                </div>

                <div class="uk-grid-small uk-flex-middle uk-margin-medium-top con-info" uk-grid>
                    <div class="uk-width-auto@s">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 368.666 368.666" style="enable-background:new 0 0 368.666 368.666" xml:space="preserve">
                                <path d="M184.333 0C102.01 0 35.036 66.974 35.036 149.297c0 33.969 11.132 65.96 32.193 92.515 27.27 34.383 106.572 116.021 109.934 119.479l7.169 7.375 7.17-7.374c3.364-3.46 82.69-85.116 109.964-119.51 21.042-26.534 32.164-58.514 32.164-92.485C333.63 66.974 266.656 0 184.333 0zm101.462 229.355c-21.956 27.687-80.92 89.278-101.462 110.581-20.54-21.302-79.483-82.875-101.434-110.552-18.228-22.984-27.863-50.677-27.863-80.087C55.036 78.002 113.038 20 184.333 20c71.294 0 129.297 58.002 129.296 129.297 0 29.412-9.625 57.096-27.834 80.058z"></path>
                                <path d="M184.333 59.265c-48.73 0-88.374 39.644-88.374 88.374s39.645 88.374 88.374 88.374 88.374-39.645 88.374-88.374-39.644-88.374-88.374-88.374zm0 156.748c-37.702 0-68.374-30.673-68.374-68.374 0-37.702 30.673-68.374 68.374-68.374s68.373 30.673 68.374 68.374c0 37.702-30.672 68.374-68.374 68.374z"></path>
                            </svg></span>
                    </div>
                    <div class="uk-width-expand@s">
                        <h3>Staðsetning</h3>
                        WeWork 60 Anson Road: 60 Anson Road, #17-01/02 Mapletree Anson, Singapore 079914
                    </div>
                </div>
            </div>

            <div>
                <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15955.271928393904!2d103.851879!3d1.2830500000000002!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x31da190ebfae9eaf%3A0xbbf6d74ccd54d482!2sThe%20Executive%20Centre%20-%20Ocean%20Financial%20Centre!5e0!3m2!1sru!2sua!4v1727291760024!5m2!1sru!2sua" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>

        </div>
    </div>
</section>

@endsection
