@extends('layouts.app')
@push('meta')
    <title>{{"$website_title $website_name | sidans sekretesspolicy"}}</title>
    <meta name="description" content="{{ "$website_title Lär dig hur säkrar dina privata data. Vår integritetspolicy betonar din informations säkerhet och öppenhet." }}" />
@endpush
@section('content')
<div class="container terms py-4">
    <h1 class="bold text-center">{{ aiTrans('Dataskyddsmeddelande', $locale) }}</h1>
<h2 class="bold">{{ aiTrans('Syfte med meddelandet', $locale) }}</h2>
<p>{{ aiTrans('Syftet med detta dataskyddsmeddelande (”Meddelandet”) är att förklara hur', $locale) }} {{$website_title}}  {{ aiTrans('”eller (”Vi” eller ”Oss”) kommer att behandla, som personuppgiftsansvarig, dina personuppgifter som du tillhandahåller Oss när du besöker webbplatsen', $locale) }} {{$website_title}}.com {{ aiTrans('("Webbplatsen"), eller som vi får från tredje parter, för att sätta dig i kontakt med yrkesverksamma som du kan vara intresserad av.', $locale) }}</p>
<h2 class="bold">{{ aiTrans('Vilka kategorier av personuppgifter kommer att behandlas?', $locale) }}</h2>
<p>{{ aiTrans('Vi samlar in och behandlar följande kategorier av personuppgifter om dig:', $locale) }}</p>
<table class="table table-bordered">
    <thead>
        <tr>
            <td><b>{{ aiTrans('Kategori av personuppgifter', $locale) }}</b></td>
            <td><b>{{ aiTrans('Definition', $locale) }}</b></td>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>{{ aiTrans('Identitetsdata', $locale) }}</td>
            <td>{{ aiTrans('Fullständigt namn och kontaktinformation (telefonnummer och e-postadress).', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Webbläsarinformation', $locale) }}</td>
            <td>{{ aiTrans('IP-adress, tid för åtkomst, datum för åtkomst, webb- och mobil sida(r) besökta, språk som används, programvarufelrapporter och typ av webbläsare som används, information om enheten du använde, dina onlineåtgärder som samlas in automatiskt, såsom cookies, webbservrar, pixlar och web beacon.', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h2 class="bold">{{ aiTrans('Hur samlas dina uppgifter in?', $locale) }}</h2>
<p>{{ aiTrans('Vi kommer att samla in dina personuppgifter:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Direkt från dig, när du tillhandahåller dina identitetsuppgifter på vår webbplats; och/eller', $locale) }}</li>
    <li>{{ aiTrans('Indirekt:', $locale) }}
        <ul>
            <li>{{ aiTrans('när vi får identitetsuppgifter om dig från tredje parter (inklusive från investeringsutbildningsföretag, partners / affiliates / marknadsförare / digitala byråer); och/eller', $locale) }}</li>
            <li>{{ aiTrans('när vi samlar in data relaterad till din webbläsning av vår webbplats genom användning av cookies eller liknande teknologier (som definieras i cookiepolicyn).', $locale) }}</li>
        </ul>
    </li>
</ul>
<p>{{ aiTrans('Du är inte skyldig att tillhandahålla oss dina personuppgifter. Men om du inte tillhandahåller dina personuppgifter kommer det att hindra oss från att sätta dig i kontakt med yrkesverksamma som du kan vara intresserad av.', $locale) }}</p>
<h2 class="bold">{{ aiTrans('Vad är syftena och den rättsliga grunden för vår behandling?', $locale) }}</h2>
<p>{{ aiTrans('Vi behandlar dina personuppgifter för följande syften:', $locale) }}</p>
<table class="table table-bordered">
    <thead>
        <tr>
            <td><b>{{ aiTrans('Syfte', $locale) }}</b></td>
            <td><b>{{ aiTrans('Rättslig grund', $locale) }}</b></td>
            <td><b>{{ aiTrans('Kategorier av personuppgifter som behandlas', $locale) }}</b></td>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>{{ aiTrans('Dela dina personuppgifter med yrkesverksamma som erbjuder tjänster som du kan vara intresserad av', $locale) }}</td>
            <td>{{ aiTrans('Ditt samtycke', $locale) }}</td>
            <td>{{ aiTrans('Identitetsdata', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Svara på och efterkomma förfrågningar och lagliga krav från tillsynsmyndigheter eller andra myndigheter i eller utanför ditt hemland.', $locale) }}</td>
            <td>{{ aiTrans('Följa tillämpliga lagar och regler.', $locale) }}</td>
            <td>{{ aiTrans('Identitetsdata', $locale) }}<br>{{ aiTrans('Webbläsarinformation', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Hävda och försvara våra rättigheter', $locale) }}</td>
            <td>{{ aiTrans('Vår legitima intresse att försvara oss gentemot våra användare (inklusive dig), rättsliga, administrativa och/eller brottsbekämpande myndigheter.', $locale) }}</td>
            <td>{{ aiTrans('Identitetsdata', $locale) }}<br>{{ aiTrans('Webbläsarinformation', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Säkerställa att vår webbplats fungerar och dess säkerhet', $locale) }}</td>
            <td>{{ aiTrans('Vårt legitima intresse att säkerställa en väl fungerande och säker webbplats.', $locale) }}</td>
            <td>{{ aiTrans('Webbläsarinformation', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h2 class="bold">{{ aiTrans('Vem kommer mina personuppgifter att delas med?', $locale) }}</h2>
<p>{{ aiTrans('Vi kommer att dela dina personuppgifter:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Inom vår grupp;', $locale) }}</li>
    <li>{{ aiTrans('Med våra partners, för deras egna behandlingssyften, inklusive att ge dig information om deras tjänster och produkter som du kan vara intresserad av, förutsatt att du har gett ditt föregående samtycke för sådan delning. Sådana partners inkluderar investeringsutbildningsföretag, databrokers och medlare;', $locale) }}</li>
    <li>{{ aiTrans('Med tredje parter som tillhandahåller oss tjänster såsom lagring och hosting, analytiska, tekniska och diagnostiska tjänster;', $locale) }}</li>
    <li>{{ aiTrans('Med våra juridiska rådgivare, särskilt för att följa våra lagstadgade skyldigheter, i synnerhet när det gäller redovisning, revision och intern kontroll;', $locale) }}</li>
    <li>{{ aiTrans('Som en del av försäljningen av hela eller delar av vårt företag och dess tillgångar till en tredje part eller som en del av en företagsomstrukturering eller omstrukturering (inklusive upplösning eller likvidation); och', $locale) }}</li>
    <li>{{ aiTrans('Där det krävs eller tillåts enligt tillämplig lag, till statliga myndigheter, domstolar, externa rådgivare och liknande tredje parter.', $locale) }}</li>
</ul>
<h2 class="bold">{{ aiTrans('Överföringar av data över gränser', $locale) }}</h2>
<p>{{ aiTrans('Vi överför dina personuppgifter utanför det europeiska ekonomiska området (”EEA”). Vissa mottagare är belägna i länder för vilka Europakommissionen har utfärdat tillräcklighetsbeslut, nämligen till Israel. Överföringen erkänns därmed som att tillhandahålla en tillräcklig nivå av dataskydd ur ett europeiskt dataskyddsperspektiv (Art. 45 GDPR).', $locale) }}</p>
<p>{{ aiTrans('Vissa mottagare av dina personuppgifter kan vara belägna i ett annat land för vilket Europakommissionen inte har utfärdat ett beslut som säkerställer att detta land har en tillräcklig nivå av dataskydd.', $locale) }}</p>
<p>{{ aiTrans('Genom att ingå lämpliga dataöverföringsavtal baserade på standardavtalsklausuler (2021/914/EU) som hänvisas till i Art. 46 (2) (c) GDPR eller andra lämpliga medel, som är tillgängliga via kontaktuppgifterna nedan har vi fastställt att alla andra mottagare som ligger utanför EEA kommer att tillhandahålla en tillräcklig nivå av dataskydd för personuppgifterna och att lämpliga tekniska och organisatoriska säkerhetsåtgärder finns på plats för att skydda personuppgifter mot oavsiktlig eller olaglig förstörelse, oavsiktlig förlust eller ändring, obehörig avslöjande eller åtkomst, och mot alla andra olagliga former av behandling. Eventuella vidareöverföringar (inklusive våra dotterbolag utanför EEA) är föremål för lämpliga vidareöverföringskrav enligt tillämplig lag.', $locale) }}</p>
<h2 class="bold">{{ aiTrans('Behållning', $locale) }}</h2>
<p>{{ aiTrans('Vi kommer endast att lagra insamlade personuppgifter så länge som strikt nödvändigt för att uppnå syftena med behandlingen som anges i detta meddelande och i enlighet med tillämplig dataskyddslag. När vi inte längre behöver använda dina personuppgifter, kommer de att raderas och/eller anonymiseras så att individer inte längre kan identifieras utifrån dem (sparat i den utsträckning som lagring krävs för att uppfylla juridiska eller reglerande skyldigheter eller för att föra eller försvara juridiska krav).', $locale) }}</p>
<h2 class="bold">{{ aiTrans('Dina rättigheter', $locale) }}</h2>
<p>{{ aiTrans('Enligt tillämplig dataskyddslag har du följande rättigheter:', $locale) }}</p>
<ol>
    <li>
        <p><b>{{ aiTrans('Rätt till åtkomst:', $locale) }}</b> {{ aiTrans('Du har rätt att få bekräftelse från oss om huruvida personuppgifter som rör dig behandlas, och om så är fallet, att begära åtkomst till de personuppgifterna. Åtkomstinformationen inkluderar – bland annat – syftena med behandlingen, kategorierna av berörda personuppgifter och mottagarna eller kategorierna av mottagare till vilka personuppgifterna har eller kommer att avslöjas.', $locale) }}</p>
        <p>{{ aiTrans('Du har rätt att få en kopia av de personuppgifter som behandlas. För ytterligare kopior som begärs av dig kan vi ta ut en rimlig avgift baserad på administrativa kostnader.', $locale) }}</p>
    </li>
    <li>
        <p><b>{{ aiTrans('Rätt till rättelse:', $locale) }}</b> {{ aiTrans('Du har rätt att få oss att rätta felaktiga personuppgifter som rör dig. Beroende på syftena med behandlingen har du rätt att få ofullständiga personuppgifter kompletterade, inklusive genom att ge en kompletterande upplysning.', $locale) }}</p>
    </li>
    <li>
        <p><b>{{ aiTrans('Rätt till radering (rätt att bli glömd):', $locale) }}</b> {{ aiTrans('Du har rätt att begära att vi raderar dina personuppgifter.', $locale) }}</p>
    </li>
    <li>
        <p><b>{{ aiTrans('Rätt till begränsning av behandling:', $locale) }}</b> {{ aiTrans('Du har rätt att begära begränsning av behandlingen av dina personuppgifter. I detta fall kommer de respektive uppgifterna att märkas och får endast behandlas av oss för vissa syften.', $locale) }}</p>
    </li>
    <li>
        <p><b>{{ aiTrans('Rätt till dataportabilitet:', $locale) }}</b> {{ aiTrans('Du har rätt att ta emot de personuppgifter som rör dig som du har tillhandahållit oss i ett strukturerat, allmänt använt och maskinläsbart format och du har rätt att överföra dessa personuppgifter till en annan enhet utan hinder från oss.', $locale) }}</p>
    </li>
    <li>
        <p><b>{{ aiTrans('Rätt att invända:', $locale) }}</b> {{ aiTrans('Du har rätt att invända, av skäl som rör din specifika situation, när som helst mot behandlingen av dina personuppgifter av oss och vi kan krävas att inte längre behandla dina personuppgifter. Om du har rätt att invända och du utövar denna rätt, kommer dina personuppgifter inte längre att behandlas för sådana syften av oss. Utövandet av denna rätt kommer inte att medföra några kostnader. Sådan rätt att invända kanske inte finns, särskilt om behandlingen av dina personuppgifter är nödvändig för att vidta åtgärder före ingåendet av ett avtal eller för att fullgöra ett redan ingått avtal.', $locale) }}</p>
    </li>
    <li>
        <p><b>{{ aiTrans('Rätt att återkalla ditt samtycke:', $locale) }}</b> {{ aiTrans('Där behandlingen av dina personuppgifter är baserad på ditt samtycke har du rätt att när som helst återkalla ditt samtycke. En sådan rätt att återkalla ditt samtycke påverkar inte lagligheten av behandlingen baserat på ditt samtycke som du tidigare har gett oss, före återkallelsen.', $locale) }}</p>
    </li>
    <li>
        <p><b>{{ aiTrans('Rätt till dina uppgifter efter din död:', $locale) }}</b> {{ aiTrans('Du har rätt att ge instruktioner angående lagring, radering och kommunikation av personuppgifter som rör dig efter din död.', $locale) }}</p>
    </li>
</ol>
<p>{{ aiTrans('Observera att dessa rättigheter kan vara begränsade enligt tillämplig lokal dataskyddslag.', $locale) }}</p>
<p>{{ aiTrans('Om du vill utöva någon av dessa rättigheter, vänligen kontakta oss som anges i avsnittet Kontakta oss nedan.', $locale) }}</p>
<p>{{ aiTrans('Du har också rätt att lämna in ett klagomål till den franska behöriga dataskyddsmyndigheten, som är CNIL.', $locale) }}</p>
<h2 class="bold">{{ aiTrans('Kontakta oss', $locale) }}</h2>
<p>{{ aiTrans('Individer som har några frågor om detta meddelande bör', $locale) }} <a href="{{route('contact',$country)}}">{{ aiTrans('kontakta oss', $locale) }}</a></p>
<h2 class="bold">{{ aiTrans('Ändringar av integritetspolicyn', $locale) }}</h2>
<p>{{ aiTrans('Denna integritetspolicy kan komma att ändras. Du kommer att informeras på lämpligt sätt om sådana ändringar.', $locale) }}</p>
</div>
@endsection
