<?php

namespace App\Http\Resources\API\Core;

use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class CarTypeResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'title' => $this->title,
            'image' => (!empty($this->getFirstMediaUrl('image'))) ? $this->getFirstMediaUrl('image') : 'https://images.unsplash.com/photo-1617704548623-340376564e68',
        ];
    }
}
