<?php

namespace App\Http\Resources\API\Order;

use App\Domain\Order\OrderStatus\Enums\WenchOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\WenchRequestsStatusEnum;
use App\Http\Resources\API\Driver\DriverResourcesWench;
use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class WenchRequestResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $is_active = ($this->status != WenchRequestsStatusEnum::order_finished()->label &&
            ($this->order?->status == WenchOrderStatusEnum::truck_is_on_its_way_to_you()->label ||
                $this->order?->status == WenchOrderStatusEnum::your_car_is_on_its_way_to_branch()->label ||
                $this->order?->status == WenchOrderStatusEnum::the_car_is_on_way_to_you()->label));
        return [
            'id' => $this->id,
            'is_return' => $this->is_return,
            'is_active_to_view_in_map' => $is_active,
            'pickup_address' => $this->return_address ?? '',
            'pickup_lat' => $this->pickup_lat,
            'pickup_lng' => $this->pickup_lng,
            'return_address' => $this->return_address ?? '',
            'return_lat' => $this->return_lat,
            'return_lng' => $this->return_lng,
            'driver' => new DriverResourcesWench($this->driver),
            'status' => $this->status,
            'created_at' => $this->created_at->translatedFormat('D, M j, Y g:i A'),
        ];
    }

}
