<?php

namespace App\Support\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;
use Stichoza\GoogleTranslate\GoogleTranslate;

class TranslateToArabic extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'translate:google';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $file = File::get(base_path('lang' . DIRECTORY_SEPARATOR . 'trans.json'));
        $translations = [];
        foreach (json_decode($file) as $key => $value) {
            $translations[$key] = GoogleTranslate::trans($key, 'ar');
        }

        \Storage::disk('local')->put('ar.json', json_encode($translations, JSON_UNESCAPED_UNICODE));
        return Command::SUCCESS;
    }
}
