<script src='https://api.tomtom.com/maps-sdk-for-web/cdn/6.x/6.18.0/maps/maps-web.min.js'></script>

<script
        src="https://maps.googleapis.com/maps/api/js?key={{env('GOOGLE_MAP_KEY')}}&libraries=places&language={{App()->getLocale()}}&callback=initialize"
        async defer></script>

<script>

    $(document).ready(function () {
        navigator.geolocation.getCurrentPosition(function () {
        }, function () {
        }, {});
        navigator.geolocation.getCurrentPosition(function (position) {
            let currentLat = $('#latitude').val();
            let currentLong = $('#longitude').val();
            let currentAddress = $('#location_address').val();
            // change it when is empty only
            if (currentLat === '') {
                $('#latitude').val(position.coords.latitude);
            }
            if (currentLong === '') {
                $('#longitude').val(position.coords.longitude);
            }

            $.ajax({
                url: '{{ url('/save-location') }}',
                type: 'post',
                data: {lat: position.coords.latitude, lng: position.coords.longitude},
                success: function (response) {
                    if (currentAddress === '') {
                        $('#location_address').val(response.address);
                    }
                    initialize();
                }
            });
        }, function (error) {
            $('#CurrentlocationError').text(`Couldn't access your location \n Reason: ${error.message}`);
        }, {
            enableHighAccuracy: true
        });

        $('#getCurrentLocation').on('click', function (e) {
            e.preventDefault();
            //The working next statement.
            navigator.geolocation.getCurrentPosition(function (position) {
                $('#latitude').val(position.coords.latitude);
                $('#longitude').val(position.coords.longitude);

                $.ajax({
                    url: '{{ url('/save-location') }}',
                    type: 'post',
                    data: {lat: position.coords.latitude, lng: position.coords.longitude},
                    success: function (response) {
                        $('#location_address').val(response.address);
                        initialize();
                    }
                });
            }, function (error) {
                $('#CurrentlocationError').text(`Couldn't access your location \n Reason: ${error.message}`);
            }, {
                enableHighAccuracy: true
            });
        });
    });


    function initialize() {
        $('form').on('keyup keypress', function (e) {
            var keyCode = e.keyCode || e.which;
            if (keyCode === 13) {
                e.preventDefault();
                return false;
            }
        });

        const locationInputs = document.getElementsByClassName("map-input");


        var DefaultLat = {{Cookie::get('lat') ?? '24.774265'}};
        var DefaultLng = {{Cookie::get('lng') ?? '46.738586'}};


        const autocompletes = [];
        const geocoder = new google.maps.Geocoder;
        for (let i = 0; i < locationInputs.length; i++) {
            const input = locationInputs[i];
            const fieldKey = input.id.replace("-input", "");
            const isEdit = document.getElementById("latitude").value != ''
                && document.getElementById("longitude").value != '';

            const latitude = parseFloat(document.getElementById("latitude").value) || DefaultLat;
            const longitude = parseFloat(document.getElementById("longitude").value) || DefaultLng;

            var map = new google.maps.Map(document.getElementById('address-map'), {
                center: {lat: latitude, lng: longitude},
                zoom: 15
            });

            var marker = new google.maps.Marker({
                map: map,
                position: {lat: latitude, lng: longitude},
                draggable: true
            });

            marker.setVisible(true);

            const autocomplete = new google.maps.places.Autocomplete(input);
            autocomplete.key = fieldKey;
            autocompletes.push({input: input, map: map, marker: marker, autocomplete: autocomplete});

        }

        for (let i = 0; i < autocompletes.length; i++) {
            const input = autocompletes[i].input;
            const autocomplete = autocompletes[i].autocomplete;
            const map = autocompletes[i].map;
            const marker = autocompletes[i].marker;

            google.maps.event.addListener(autocomplete, 'place_changed', function () {

                marker.setVisible(true);
                const place = autocomplete.getPlace();

                geocoder.geocode({'placeId': place.place_id}, function (results, status) {

                    if (status === google.maps.GeocoderStatus.OK) {
                        const street_address = results[0].formatted_address;
                        const lat = results[0].geometry.location.lat();
                        const lng = results[0].geometry.location.lng();
                        setLocationCoordinates(autocomplete.key, lat, lng, street_address);
                    }
                });

                if (!place.geometry) {
                    window.alert("No details available for input: '" + place.name + "'");
                    input.value = "";
                    return;
                }

                if (place.geometry.viewport) {
                    map.fitBounds(place.geometry.viewport);
                } else {
                    map.setCenter(place.geometry.location);
                    map.setZoom(17);
                }
                marker.setPosition(place.geometry.location);
                marker.setVisible(true);

            });

            google.maps.event.addListener(marker, 'position_changed', function () {

                var latpos = marker.getPosition().lat();
                var lngpos = marker.getPosition().lng();
                document.getElementById("latitude").value = latpos;
                document.getElementById("longitude").value = lngpos;
                geocodePosition(marker.getPosition());
            });

            function geocodePosition(pos) {
                //addresses = ; // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                // console.log(geocoder.getFromLocation(pos.lat(), pos.lng(), 1));
                geocoder.geocode({latLng: pos}, function (results, status) {
                    // This is checking to see if the Geoeode Status is OK before proceeding
                    if (status == google.maps.GeocoderStatus.OK) {
                        updateMarkerAddress(results[0].formatted_address);
                    }
                });
            }


            function updateMarkerAddress(str) {
                //document.getElementById("place_name").value = str;
                document.getElementById("location_address").value = str;
            }
        }
    }

    function setLocationCoordinates(key, lat, lng, street_address) {

        const latitudeField = document.getElementById("latitude");
        const longitudeField = document.getElementById("longitude");
        const place_name = document.getElementById('location_address');
        latitudeField.value = lat;
        longitudeField.value = lng;
        place_name.value = street_address;
    }
</script>

