@if( $field['data'] == 'multilang')
    @foreach(langs() as $lang)
        <div class="{{$field['class']}}">
            <div class="form-group row no-gutters">
                <label
                    class="col-sm-12 col-form-label text-left {{ $errors->has(dotted_string($field['name'])) ? 'text-danger' : '' }}">
                    {{ __($field['label']) }} {{ $lang }}
                </label>

                <div class="col-sm-12">

                    @if($field['type'] == 'file')
                        {!! Form::{$field['type']}($field['name'],['class'=>'form-control']) !!}

                        @if(\setting($field['name']))
                            <img src="{{ Storage::url(\setting($field['name'])) }}" class="mt-5 col-sm-3 card-img-top img-responsive"
                                 style="max-width: 200px;" alt="">
                        @endif
                    @else
                        {!! Form::{$field['type']}($field['name'],old($field['name'],\setting($field['name'])),['class'=>'form-control mt-3']) !!}
                    @endif

                    @error(dotted_string($field['name']))
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>
    @endforeach
@else
    <div class="{{$field['class']}}">
        <div class="form-group row no-gutters">
            <label
                class="col-sm-12 col-form-label text-left {{ $errors->has(dotted_string($field['name'])) ? 'text-danger' : '' }}">
                {{ __($field['label']) }}
            </label>
            <div class="col-sm-12 ">
                @if($field['type'] == 'file')
                    {!! Form::{$field['type']}($field['name'],['class'=>'form-control']) !!}
                    @if(\setting($field['name']))
                        @if($field['data'] == 'image')
                        <img src="{{ Storage::url(\setting($field['name'])) }}" class="mt-5 col-sm-3 card-img-top img-responsive"
                             style="max-width: 200px;" alt="logo">
                        @else
                            <a href="{{ Storage::url(\setting($field['name'])) }}" target="_blank"
                            class="btn btn-primary mt-3"> @lang('Preview')</a>
                        @endif
                    @endif
                @else
                    {!! Form::{$field['type']}($field['name'],old($field['name'],\setting($field['name'])),['class'=>'form-control mt-3']) !!}
                @endif
                @error(dotted_string($field['name']))
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        </div>
    </div>
@endif
