@extends('ui::layout.master')
@push('header')
    <!-- Include CodeMirror library CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/codemirror.min.css">
    <!-- Include CodeMirror theme CSS (Monokai theme) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/theme/monokai.min.css">
    <style>
        /* Style the code editor elements with a border */
        .CodeMirror {

            border: 1px solid black;
        }
    </style>
@endpush
@push('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.62.0/codemirror.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.62.0/mode/css/css.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.62.0/mode/javascript/javascript.min.js"></script>



    <script>
        $(document).ready(function () {
            // Initialize CodeMirror for CSS code editor
            let cssEditors = document.querySelectorAll('.css-code-editor');

            cssEditors.forEach(editor => {
                // Initialize CodeMirror for each CSS code editor
                let cssEditor = CodeMirror.fromTextArea(editor, {
                    mode: 'text/css',
                    lineNumbers: false,
                    theme: 'monokai', // Set the dark theme here
                    smartIndent: true,
                    autofocus: true
                });
            });


            let JsEditors = document.querySelectorAll('.js-code-editor');

            JsEditors.forEach(editor => {
                // Initialize CodeMirror for each CSS code editor
                let jsEditor = CodeMirror.fromTextArea(editor, {
                    mode: 'text/javascript',
                    lineNumbers: false,
                    theme: 'monokai', // Set the dark theme here
                    smartIndent: true,
                    autofocus: true
                });
            });
        });

    </script>
    <script src="{{asset('vendor/hsmfawaz/ui/metronic/assets/plugins/custom/tinymce/tinymce.bundle.js')}}"></script>

    <script>

        let options = {
            selector: ".tinymce",
            height: "480",
            plugins: "code",
            toolbar: ' undo redo styleselect bold italic alignleft aligncenter alignright alignjustify | bullist numlist outdent indent code'

        };

        tinymce.init(options);
        $(document).ready(function (e) {
            $('a[data-bs-toggle="tab"]').on("click", function () {
                let newUrl;
                let hash = $(this).attr("href");
                hash = hash.substring(1, hash.length);
                newUrl = '{{url()->current()}}/?tab=' + hash;
                history.replaceState(null, null, newUrl);
            });
            $('.nav-tabs a[href="#{{request('tab')}}"]').tab('show');

            $("#crud-modal-form input").on("invalid", function () {
                //find tab id
                let $closest = $(this).closest('.tab-pane');
                let id = $closest.attr('id');
                //goto tab id
                $('.nav-tabs a[href="#' + id + '"]').tab('show');
            });

            @if($errors->any())
            $('.nav-tabs a[href="#{{request('tab')}}"]').tab('show');
            @endif
        });

    </script>
@endpush
@section('content')
    @section('actions')
        <button form="crud-modal-form" type="submit" class="btn btn-success mx-2 px-5">
            {{ __('Save Data') }}
        </button>
        <a href="{{ route('dashboard.core.settings.index')}}"
           class="btn btn-secondary btn-back">
            <!-- {{ __('Go Back') }} -->

            <i class="fas fa-arrow-left"></i>
        </a>
    @endsection
    <div class="card">
        <div class="col-span-12">
            <div class=" card-body ">
                @if (session('status'))
                    <div class="alert alert-success">
                        {{ session('status') }}
                    </div>
                @endif
                {!! Form::open(['route' => 'dashboard.core.settings.store', 'files' => true,'id'=>'crud-modal-form']) !!}
                {!! csrf_field() !!}
                @php $i=0; @endphp
                @php $tabcount=0; @endphp
                @if(count(config('setting_fields', [])) )
                    <ul class="nav nav-custom nav-tabs nav-line-tabs nav-line-tabs-2x border-0 fs-4 fw-bold mb-n2"
                        id="nav-tabs" role="tablist">
                        @foreach(config('setting_fields') as $section => $fields)

                            @php $tabcount++; @endphp
                            <li class="nav-item">
                                <a class="nav-link text-active-primary pb-4 @if($tabcount == 1) active @endif"
                                   id="home-tab-{{$section}}" data-bs-toggle="tab"
                                   href="#{{ $fields['tab'] }}">

                                    {{ __($fields['title']) }}
                                </a>
                            </li>
                        @endforeach
                    </ul>
                    <div class="tab-content">
                        @foreach(config('setting_fields') as $section => $fields)
                            @php $i++; @endphp
                            <div class="tab-pane fade @if($i == 1) active show @endif" id="{{ $fields['tab'] }}"
                                 role="tab-panel">
                                <div class="row">
                                    @foreach($fields['elements'] as $field)
                                        @include('dashboard.core.settings.fields.' . $field['file_type'] )
                                    @endforeach
                                </div>
                            </div>
                            <!-- end panel for  -->
                        @endforeach
                    </div>
                @endif

                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection

