
<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title ™ | Site Oficial Português 2025"); ?></title>
    <meta name="description" content="<?php echo e("O que é o $website_title Temos o prazer de anunciar o lançamento da nova versão do $website_title – a plataforma definitiva para negociação de criptomoedas."); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header"><?php echo e($website_title); ?></h1>
        <h3 class="hero-subtitle">
           <span class="change-by-command"><?php echo e("A renovação do mercado de criptomoedas: a mais nova atualização do $website_title"); ?></span>
            </h3>
        <div class="main-cols">
            <div class="video-col"><img src="dist/images/poster_index.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" srcset="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/poster_index-p-500.webp 500w, <?php echo e(asset('frontend/assets/pt/dist')); ?>/images/poster_index.webp 733w" alt="<?php echo e($website_title); ?> - Revolucionando o comércio de criptomoedas: apresentando a atualização mais recente do <?php echo e($website_title); ?>" width="710" height="399" class="main-image"></div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        <?php echo $__env->make('frontend.pt.components.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <div class="w-form-done">
                            <div><?php echo e(aiTrans('Thank you! Your submission has been received!')); ?></div>
                        </div>
                        <div class="w-form-fail">
                            <div><?php echo e(aiTrans('Oops! Something went wrong while submitting the form.')); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>
<div class="trading w-clearfix wf-section">
    <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/trade-image.webp" width="500" alt="<?php echo e($website_title); ?> - O que é o <?php echo e($website_title); ?>?" class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            <?php echo e(aiTrans(
                "O que é o [website_title]?",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </h2>
        <div class="trading-text">
            <?php echo e(aiTrans(
                "Temos o prazer de anunciar o lançamento da nova versão do [website_title] – a plataforma definitiva para negociação de criptomoedas. Com recursos avançados, tecnologia de ponta e uma interface amigável, o novo [website_title] foi projetado para levar sua experiência de negociação para o próximo nível. O software de negociação poderoso e intuitivo é capaz de aproveitar as pequenas diferenças de preço das moedas digitais entre as diferentes bolsas. Em seguida, ele comprará criptos a um preço baixo e depois os venderá a um preço mais alto. O resultado final são pequenas quantias de lucro que resultam em grandes lucros para o usuário.",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button"><?php echo e(aiTrans("Registrar agora")); ?></a>
        </div>
        <h2 class="trading-title"><?php echo e(aiTrans('Como faço para começar a negociar on-line?')); ?></h2>
        <div class="trading-text"><?php echo e(aiTrans('O comércio on-line, a compra e venda básica de ativos financeiros pela Internet, pode ser feito por praticamente qualquer pessoa, independentemente de sua experiência anterior nos mercados financeiros globais. Embora seja simples começar, se você planeja ser lucrativo, a negociação on-line pode ser um desafio. Para começar a negociar on-line, você precisará de um computador e uma conexão confiável com a Internet. Depois de se registrar para uma conta de negociação com uma plataforma respeitável, você poderá começar a negociar assim que sua conta for ativada e financiada. Curiosamente, embora seja fácil começar a negociar, é muito mais difícil ter sucesso como trader. Há uma abundância de riscos envolvidos que você deve estar ciente. Grande parte da negociação tem a ver com planejamento metódico, análise precisa do mercado, compreensão dos fatores que afetam os preços dos ativos, bem como tentativa e erro. Alguns mercados de ativos também podem ser bastante voláteis, o que pode tornar seu risco de perda muito maior se você não tiver as habilidades para aproveitar as muitas oportunidades comerciais lucrativas que a volatilidade pode oferecer. Apesar dos desafios, com os avanços tecnológicos na tecnologia algorítmica, esse tipo de software comercial tornou mais fácil do que nunca começar a negociar online com mais precisão. O algoritmo do aplicativo analisará os mercados para identificar oportunidades de negociação e, com essas informações, você poderá tomar decisões de negociação mais inteligentes com base na análise do mercado. Desta forma, mesmo os comerciantes novatos podem começar a negociar seus ativos preferidos online.')); ?></div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button"><?php echo e(aiTrans("Registrar agora")); ?></a>
            <div class="trading-bg2"></div>
        </div>
    </div>
    <div class="trading-bg-1"></div>
</div>
<div class="not-scam w-clearfix wf-section">
    <div class="not-scam-bg-1"></div>
    <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/not-scam-img.webp" alt="<?php echo e($website_title); ?> - <?php echo e($website_title); ?> é uma farsa?" class="img-float-right not-scam-img">
    <div class="container w-container">
        <h3 class="not-scam-title">
            <?php echo e(aiTrans(
                "[website_title] é uma farsa?",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </h3>
        <p class="not-scam-text">
            <?php echo e(aiTrans(
                "Não não é. [website_title] não promete lucros garantidos de negociação de criptografia porque não é um software de negociação automatizado. O aplicativo é apenas um assistente de negociação. Ele foi projetado para ajudar os investidores a negociar criptomoedas com confiança. O aplicativo fornece informações baseadas em dados em tempo real para os comerciantes, ajudando-os a tomar decisões rápidas e precisas quando estão negociando suas criptomoedas favoritas online. Além disso, o aplicativo é seguro e não compromete nenhum dado pessoal ou financeiro de seus clientes.",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </p>
        <div class="button-wrapper">
            <a href="#formTop" class="button white w-button"><?php echo e(aiTrans("REGISTRAR AGORA")); ?></a>
        </div>
    </div>
</div>
<div class="improve-your-trading w-clearfix wf-section">
    <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/improve-your-trading-img.webp" alt="<?php echo e($website_title); ?> - Como o aplicativo <?php echo e($website_title); ?> melhora sua negociação?" class="img-float-right improve-your-trading-img">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            <?php echo e(aiTrans(
                "Como o aplicativo [website_title] melhora sua negociação?",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </h2>
        <div class="improve-your-trading-text">
            <?php echo e(aiTrans(
                "Não importa o nível de habilidade que você tenha na negociação online, você poderá se beneficiar dos poderosos recursos de negociação oferecidos pelo aplicativo [website_title]. Primeiro, no entanto, você precisará entender como o software funciona. O [website_title] é capaz de analisar os mercados através do uso de um algoritmo altamente sofisticado que incorpora grandes quantidades de dados de mercado, bem como alguns indicadores técnicos importantes para identificar configurações de negociação de alta probabilidade. Você também poderá ajustar os parâmetros na interface de design intuitivo do software. Basta ajustar como o software opera de acordo com seu próprio nível de habilidade, tolerância a riscos e preferências. O software permite que até mesmo traders iniciantes comecem a negociar nos mercados sem ter que se preocupar em cometer um erro ao analisar os movimentos de preços nos mercados e saber quando entrar em uma negociação. Além disso, outro grande recurso é que, à medida que você começa a progredir como trader, pode querer adotar uma abordagem mais prática. Nessa situação, o software ainda pode ser bastante útil para confirmar sua própria análise de mercado antes de entrar em uma negociação. Mesmo em um nível de habilidade mais alto, você ainda pode acabar se encontrando em situações em que pode estar muito nervoso ou animado para tomar decisões lógicas de negociação. Nesse caso, você pode usar a análise de mercado fornecida pelo aplicativo. Isso permite que você evite o erro de negociação emocional, garantindo que você esteja entrando em negociações baseadas em análises de mercado baseadas em dados. Uma das melhores coisas sobre [website_title] é que é totalmente gratuito registrar sua nova conta. Inscreva-se agora e comece a negociar nos mercados.",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button"><?php echo e(aiTrans('Abra uma conta gratuita agora')); ?></a>
        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>
<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>
        <h2 class="features-title">
            <?php echo e(aiTrans(
                "Principais características do [website_title]",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </h2>
        <div class="features-text">
            <?php echo e(aiTrans(
                "[website_title] 3.0 é a versão mais recente do nosso poderoso aplicativo de negociação, projetado para ajudar os investidores a acessar e aproveitar ao máximo as oportunidades de negociação de alta qualidade nos mercados de criptomoedas. Nossas tecnologias financeiras avançadas combinam mais de 15 ferramentas de análise técnica para ajudar os traders a identificar os pontos ideais de entrada e saída de preços ao negociar suas moedas digitais favoritas online. O novo [website_title] oferece suporte a uma gama mais ampla de criptomoedas, oferecendo mais opções quando se trata de negociação. Esteja você interessado em Bitcoin, Ethereum ou outras criptomoedas populares, você pode negociá-los no novo [website_title].",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </div>
        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/feature1-icon.webp" alt="<?php echo e($website_title); ?> - Algoritmos de Negociação Avançados" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title"><?php echo e(aiTrans('Algoritmos de Negociação Avançados')); ?></h3>
                    </div>
                    <div class="features-list-item-text"><?php echo e(aiTrans('Nossos algoritmos de negociação estão mais avançados do que nunca, permitindo que você aproveite os movimentos do mercado em tempo real. Com algoritmos sofisticados de aprendizado de máquina, [website_title] pode analisar dados de mercado e fazer previsões sobre movimentos futuros de preços, dando a você uma vantagem em suas negociações.', $locale , ['website_title' => $website_title])); ?></div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/feature2-icon.webp" alt="<?php echo e($website_title); ?> - Interface de usuário aprimorada" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title"><?php echo e(aiTrans('Interface de usuário aprimorada')); ?></h3>
                    </div>
                    <div class="features-list-item-text">
                        
                        <?php echo e(aiTrans(
                            "Redesenhamos completamente nossa interface de usuário, tornando-a mais intuitiva e fácil de usar. Seja você um iniciante ou um trader experiente, você achará o novo [website_title] fácil de navegar e usar.",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/feature3-icon.webp" alt="<?php echo e($website_title); ?> - Segurança melhorada" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title"><?php echo e(aiTrans('Segurança melhorada')); ?></h3>
                    </div>
                    <div class="features-list-item-text">
                        <?php echo e(aiTrans(
                            "A segurança é nossa principal prioridade na [website_title], e a nova plataforma inclui uma variedade de recursos avançados de segurança para manter seus fundos e informações pessoais seguros. Nossa plataforma é protegida com criptografia SSL e autenticação de dois fatores, e usamos os mais recentes protocolos de segurança para proteger seus dados.",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </div>
                </div>
            </div>
        </div>
        <div class="button-wrapper margin-0-auto">
            <a href="#formTop" class="button w-button"><?php echo e(aiTrans("REGISTRAR AGORA")); ?></a>
        </div>
    </div>
    <div class="featues-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            <?php echo e(aiTrans(
                "Como você se inscreve com [website_title]?",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text"><?php echo e(aiTrans('Passo um')); ?></div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title"><?php echo e(aiTrans('Cadastro')); ?></h3>
                    </div>
                    <div>
                        <?php echo e(aiTrans(
                            "O primeiro passo é preencher o formulário de inscrição que você pode encontrar em nosso site. Você será solicitado a fornecer informações básicas, como seu nome, sobrenome, endereço de e-mail e número de telefone. Depois de receber o e-mail de confirmação e clicar no link de confirmação, você será registrado e sua nova conta será ativada. Isso significa que você terá acesso total ao aplicativo de negociação [website_title].",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text"><?php echo e(aiTrans('Passo dois')); ?></div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title"><?php echo e(aiTrans('Financiamento')); ?></h3>
                    </div>
                    <div>
                        <?php echo e(aiTrans(
                            "Depois de ativar sua nova conta, você precisará depositar fundos em sua conta. A negociação requer capital para manter suas posições no mercado. Você será obrigado a investir uma quantia mínima de dinheiro para fazer negociações usando o aplicativo [website_title]. Quanto mais você investir, mais lucro potencial poderá obter. No entanto, isso também significa um risco aumentado de perda. Iniciantes são aconselhados a pisar levemente no início e investir apenas o requisito de depósito mínimo. Isso permitirá que você aprenda o básico dos mercados de negociação antes de investir mais fundos.",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text"><?php echo e(aiTrans('Passo três')); ?></div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title"><?php echo e(aiTrans('Negociação')); ?></h3>
                    </div>
                    <div><?php echo e(aiTrans('Por fim, você precisará ajustar os parâmetros de negociação no software. O aplicativo pode ser personalizado para se adequar à sua própria tolerância a riscos, preferências e metas de negociação. Isso garantirá que você tenha a melhor experiência de negociação possível. Assim que terminar de configurar seus parâmetros de negociação, você estará pronto para começar a fazer negócios usando nosso poderoso algoritmo e análise de mercado.')); ?></div>
                </div>
            </div>
        </div>
        <div class="button-wrapper steps-action-button">
            <a href="#formTop" class="button white w-button"><?php echo e(aiTrans('Inscreva-se agora para começar')); ?></a>
        </div>
    </div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
        <h2 class="faq-title"><?php echo e(aiTrans('Perguntas frequentes')); ?></h2>
        <p class="faq-text"><?php echo e(aiTrans('Muito provavelmente, você ainda tem algumas preocupações sobre como nosso aplicativo de negociação funciona. Se você é um trader iniciante, provavelmente também terá dúvidas sobre como deve começar. A seguir estão algumas das perguntas que ouvimos com mais frequência dos traders.')); ?></p>
        <div class="faq-accordion">
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">1</div>
                    <h3 class="heading">
                        <?php echo e(aiTrans(
                            "Qual é a nova versão do [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        <?php echo e(aiTrans(
                            "A nova versão do [website_title] é uma versão atualizada da popular plataforma de negociação de criptomoedas, projetada para fornecer aos traders ferramentas e recursos ainda mais poderosos para ajudá-los a ter sucesso no mercado de criptomoedas.",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">2</div>
                    <h3 class="heading">
                        <?php echo e(aiTrans(
                            "Quais são os novos recursos que a nova versão do [website_title] oferece?",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        <?php echo e(aiTrans(
                            "A nova versão do [website_title] oferece uma variedade de novos recursos, incluindo ferramentas avançadas de gerenciamento de risco, dados de mercado em tempo real, tabelas e gráficos personalizáveis e análise de notícias e eventos.",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">3</div>
                    <h3 class="heading">
                        <?php echo e(aiTrans(
                            "A nova versão do [website_title] é segura de usar?",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        <?php echo e(aiTrans(
                            "Sim, a nova versão do [website_title] é segura de usar. A plataforma usa medidas de segurança avançadas para proteger os dados e transações do usuário, e nossa equipe de especialistas monitora a plataforma 24 horas por dia, 7 dias por semana, para garantir que ela seja segura e confiável.",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">4</div>
                    <h3 class="heading">
                        <?php echo e(aiTrans(
                            "Posso personalizar minha experiência de negociação com a nova versão do [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        <?php echo e(aiTrans(
                            "Sim, a nova versão do [website_title] permite que você personalize sua experiência de negociação, incluindo tabelas e gráficos personalizáveis que permitem visualizar dados de mercado e tendências facilmente.",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">5</div>
                    <h3 class="heading">
                        <?php echo e(aiTrans(
                            "A nova versão do [website_title] é adequada para iniciantes?",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        <?php echo e(aiTrans(
                            "Sim, a nova versão do [website_title] é adequada para iniciantes. A plataforma é amigável e fácil de navegar, e nossa equipe de especialistas está disponível para fornecer orientação e suporte para traders em todos os níveis de experiência.",
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button"><?php echo e(aiTrans("REGISTRAR AGORA")); ?>!</a>
        </div>
    </div>
    <div class="faq-bg-2"></div>
    <div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            <?php echo e(aiTrans(
                "[website_title] Destaques",
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </h2>
        <div class="high-table">
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/highlight-1.webp" alt="Destaques" class="high-img">
                    <div class="high-text"><?php echo e(aiTrans('Tipo')); ?></div>
                </div>
                <div class="td">
                    <div class="high-text"><?php echo e(aiTrans('Robô de negociação de IA')); ?></div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/highlight-2.webp" alt="Destaques" class="high-img">
                    <div class="high-text"><?php echo e(aiTrans('Custo do aplicativo')); ?></div>
                </div>
                <div class="td">
                    <div class="high-text"><?php echo e(aiTrans('Livre')); ?></div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/highlight-3.webp" alt="Destaques" class="high-img">
                    <div class="high-text">Tarifas</div>
                </div>
                <div class="td">
                    <div class="high-text"><?php echo e(aiTrans('Não')); ?></div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/highlight-4.webp" alt="Destaques" class="high-img">
                    <div class="high-text"><?php echo e(aiTrans('Conta de Demonstração')); ?></div>
                </div>
                <div class="td">
                    <div class="high-text"><?php echo e(aiTrans('Sim')); ?></div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/highlight-2.webp" alt="Destaques" class="high-img">
                    <div class="high-text"><?php echo e(aiTrans('Ativos')); ?></div>
                </div>
                <div class="td">
                    <div class="high-text"><?php echo e(aiTrans('BTC, ETH, XRP, DASH e outros')); ?></div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="<?php echo e(asset('frontend/assets/pt/dist')); ?>/images/highlight-6.webp" alt="Destaques" class="high-img">
                    <div class="high-text"><?php echo e(aiTrans('Proteção de dados do usuário')); ?></div>
                </div>
                <div class="td">
                    <div class="high-text"><?php echo e(aiTrans('Sim')); ?></div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sev666/public_html/alpha-spectre-app.com/resources/views/frontend/pt/home.blade.php ENDPATH**/ ?>