
<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title | Política Privacidad: Información Esencial"); ?></title>
    <meta name="description" content="<?php echo e("Conoce cómo $website_title trabaja para resguardar tu información personal y garantizar tu seguridad. Detallamos todas las medidas en nuestra Política de Privacidad."); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="contact_page ready">
        <div class="container terms py-4">
            <h1 class="bold text-center"><?php echo e(aiTrans('Aviso de Privacidad de Datos')); ?></h1>
            <h2><?php echo e(aiTrans('Propósito del Aviso')); ?></h2>
            <p><?php echo e(aiTrans('El propósito de este aviso de privacidad de datos')); ?> (el <b>"Aviso"</b>)
                <?php echo e(aiTrans('es detallar cómo')); ?> <?php echo e($website_title); ?> (<b>"<?php echo e($website_title); ?>"</b> o <b>"Nosotros"</b> o
                <b>"Nuestro"</b>)
                <?php echo e(aiTrans('gestionará, como controlador de datos, sus datos personales que nos proporciona cuando visita el sitio web')); ?>

                <?php echo e($website_title); ?> (el <b>"Sitio web"</b>),
                <?php echo e(aiTrans('o que recibimos de terceros, para conectarlo con profesionales que puedan ser de su interés.')); ?>

            </p>
            <h2><?php echo e(aiTrans('¿Cómo Recopilamos sus Datos?')); ?></h2>
            <p><?php echo e(aiTrans('Recopilamos sus datos personales:')); ?></p>
            <ul>
                <li><?php echo e(aiTrans('Directamente de usted, cuando ingresa sus datos de identificación en nuestro sitio web; y/o')); ?>

                </li>
                <li><?php echo e(aiTrans('Indirectamente:')); ?>

                    <ul>
                        <li><?php echo e(aiTrans('al recibir datos de identificación sobre usted de terceros')); ?></li>
                        <li><?php echo e(aiTrans('recopilando datos relacionados con su navegación en nuestro sitio web mediante cookies o tecnologías similares (consulte nuestra política de cookies para más detalles).')); ?>

                        </li>
                    </ul>
                </li>
            </ul>
            <p><?php echo e(aiTrans('El suministro de sus datos personales no es obligatorio, pero si decide no hacerlo, puede impedirnos conectarlo con profesionales que podrían coincidir con sus intereses.')); ?>

            </p>
            <h2><?php echo e(aiTrans('¿Qué Categorías de Datos Personales serán Procesados?')); ?></h2>
            <p><?php echo e(aiTrans('[website_title] recopila y procesa las siguientes categorías de datos personales sobre usted:', $locale, ['website_title' => $website_title])); ?>

            </p>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <td><b><?php echo e(aiTrans('Categoría de Datos Personales')); ?></b></td>
                        <td><b><?php echo e(aiTrans('Definición')); ?></b></td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo e(aiTrans('Datos de Identificación')); ?></td>
                        <td><?php echo e(aiTrans('Incluye su nombre completo y datos de contacto (número de teléfono y dirección de correo electrónico).')); ?>

                        </td>
                    </tr>
                    <tr>
                        <td><?php echo e(aiTrans('Información de Navegación')); ?></td>
                        <td><?php echo e(aiTrans('Detalles como la dirección IP, las horas y fechas de acceso, las páginas visitadas en nuestros sitios web y móviles, las preferencias de idioma, los informes de fallos de software, el tipo de navegador, la información relacionada con el dispositivo y las actividades en línea recopiladas automáticamente, por ejemplo, a través de cookies, registros de servidores web, píxeles y balizas web.')); ?>

                        </td>
                    </tr>
                </tbody>
            </table>
            <h2><?php echo e(aiTrans('¿Cuáles son los Objetivos y la Base Legal de Nuestro Procesamiento?')); ?></h2>
            <p><?php echo e(aiTrans('[website_title] procesa sus datos personales para los siguientes objetivos:', $locale, ['website_title' => $website_title])); ?>

            </p>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <td><b><?php echo e(aiTrans('Objetivo')); ?></b></td>
                        <td><b><?php echo e(aiTrans('Base Legal')); ?></b></td>
                        <td><b><?php echo e(aiTrans('Categorías de Datos Personales Procesados')); ?></b></td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo e(aiTrans('Ponerlo en contacto con profesionales que ofrecen servicios que pueden ser de su interés')); ?>

                        </td>
                        <td><?php echo e(aiTrans('Su autorización')); ?></td>
                        <td><?php echo e(aiTrans('Datos de identificación')); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(aiTrans('Gestión de solicitudes y cumplimiento de requisitos legales de reguladores u otras autoridades, tanto nacionales como internacionales.')); ?>

                        </td>
                        <td><?php echo e(aiTrans('Cumplimiento de obligaciones legales y normativas aplicables.')); ?></td>
                        <td><?php echo e(aiTrans('Datos de identificación')); ?><br><?php echo e(aiTrans('Información de navegación')); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(aiTrans('Defender y proteger nuestros derechos')); ?></td>
                        <td><?php echo e(aiTrans('Nuestro interés legítimo en resguardar nuestros derechos frente a los usuarios (incluyéndote a ti), organismos judiciales, administrativos, y/o fuerzas del orden.')); ?>

                        </td>
                        <td><?php echo e(aiTrans('Datos de identificación')); ?><br><?php echo e(aiTrans('Información de navegación')); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(aiTrans('Mantener la operatividad y seguridad de nuestro sitio web')); ?></td>
                        <td><?php echo e(aiTrans('Nuestro interés legítimo en asegurar un sitio web seguro y eficiente.')); ?></td>
                        <td><?php echo e(aiTrans('Información de navegación')); ?></td>
                    </tr>
                </tbody>
            </table>

            <h2><?php echo e(aiTrans('Sus derechos en cuanto a privacidad de datos')); ?></h2>
            <p><?php echo e(aiTrans('De acuerdo con la legislación vigente sobre protección de datos, usted tiene una gama completa de derechos, entre ellos:')); ?>

            </p>
            <ol>
                <li><b><?php echo e(aiTrans('Derecho de acceso :')); ?></b>
                    <?php echo e(aiTrans('Puede solicitar a [website_title] si se están procesando sus datos personales y, de ser así, acceder a estos datos. Esto incluye información sobre los propósitos del procesamiento, las categorías de datos personales procesados y los posibles destinatarios de los datos.')); ?><br><?php echo e(aiTrans('Tiene derecho a una copia de los datos procesados. Para copias adicionales, podemos cobrar una tarifa nominal basada en los costos administrativos.', $locale, ['website_title' => $website_title])); ?>

                </li>
                <li><b><?php echo e(aiTrans('Derecho de rectificación :')); ?></b>
                    <?php echo e(aiTrans('Si sus datos personales son incorrectos, tiene derecho a que se corrijan. Para los fines del procesamiento, también tiene derecho a completar los datos personales incompletos, incluso mediante declaraciones adicionales.')); ?>

                </li>
                <li><b><?php echo e(aiTrans('Derecho de supresión ("Derecho al olvido") :')); ?></b>
                    <?php echo e(aiTrans('Puede solicitar a [website_title] que elimine sus datos personales bajo ciertas condiciones.', $locale, ['website_title' => $website_title])); ?>

                </li>
                <li><b><?php echo e(aiTrans('Derecho a limitar el procesamiento :')); ?></b>
                    <?php echo e(aiTrans('Puede solicitar que se restrinja el procesamiento de sus datos personales. En este caso, los datos serán marcados y procesados por nosotros solo para fines específicos.')); ?>

                </li>
                <li><b><?php echo e(aiTrans('Derecho a la portabilidad de los datos :')); ?></b>
                    <?php echo e(aiTrans('Tiene derecho a recibir sus datos personales, que ha proporcionado a [website_title], en un formato estructurado, de uso común y legible por máquina, y tiene derecho a transmitir esos datos a otro controlador sin impedimento de nuestra parte.', $locale, ['website_title' => $website_title])); ?>

                </li>
                <li><b><?php echo e(aiTrans('Derecho de oposición :')); ?></b>
                    <?php echo e(aiTrans('Puede oponerse al procesamiento de sus datos personales en función de su situación específica, en cualquier momento. En caso de oposición, dejaremos de procesar sus datos para los objetivos impugnados, a menos que podamos demostrar motivos legítimos imperiosos para el procesamiento que prevalecen sobre sus intereses, derechos y libertades, o para el establecimiento, ejercicio o defensa de reclamaciones legales.')); ?>

                </li>
                <li><b><?php echo e(aiTrans('Derecho a retirar el consentimiento :')); ?></b>
                    <?php echo e(aiTrans('Si el procesamiento de los datos se basa en su consentimiento, puede retirar este consentimiento en cualquier momento, sin que ello afecte a la legalidad del procesamiento basado en el consentimiento antes de su retirada.')); ?>

                </li>
                <li><b><?php echo e(aiTrans('Derecho post-mortem a los datos :')); ?></b>
                    <?php echo e(aiTrans('Tiene derecho a establecer directrices con respecto al manejo de sus datos personales después de su fallecimiento.')); ?>

                </li>
            </ol>

            <p><?php echo e(aiTrans('Nota : El ejercicio de estos derechos puede estar sujeto a ciertas condiciones y limitaciones en virtud del derecho local de protección de datos.')); ?>

            </p>
            <p><?php echo e(aiTrans('Para ejercer alguno de estos derechos, por favor contáctenos como se indica en la sección "Contáctenos" a continuación.')); ?>

            </p>
            <p><?php echo e(aiTrans('También tiene derecho a presentar una queja ante la autoridad francesa competente en materia de protección de datos, la CNIL.')); ?>

            </p>

            <h2><?php echo e(aiTrans('Prácticas de compartición de datos')); ?></h2>
            <p><?php echo e(aiTrans('Sus datos personales pueden ser compartidos de la siguiente manera:')); ?></p>
            <ul>
                <li><?php echo e(aiTrans('Dentro de nuestro grupo de empresas;')); ?></li>
                <li><?php echo e(aiTrans('Con nuestros socios, para sus objetivos de procesamiento, siempre que haya consentido a esta compartición, para informarle sobre los servicios/productos que podrían ser de su interés;')); ?>

                </li>
                <li><?php echo e(aiTrans('Con los proveedores de servicios que ayudan a nuestras operaciones (por ejemplo, almacenamiento, alojamiento, análisis, soporte técnico);')); ?>

                </li>
                <li><?php echo e(aiTrans('Con nuestros asesores legales, para cumplir con nuestras obligaciones legales, incluyendo contabilidad, auditoría y controles internos;')); ?>

                </li>
                <li><?php echo e(aiTrans('En el contexto de una venta de negocio, transferencia de activos a un tercero, o durante la reestructuración o reorganización de la empresa;')); ?>

                </li>
                <li><?php echo e(aiTrans('Cuando esté mandatado o autorizado por la ley, a organismos gubernamentales, tribunales, asesores externos, y terceros similares.')); ?>

                </li>
            </ul>

            <h2><?php echo e(aiTrans('Transferencias de datos transfronterizas')); ?></h2>
            <p><?php echo e(aiTrans('Los datos personales recopilados por [website_title] pueden ser transferidos fuera del Espacio Económico Europeo (EEE). Las transferencias a países reconocidos por la Comisión Europea como que ofrecen una protección adecuada (por ejemplo, Israel) se consideran como que garantizan un nivel adecuado de protección de datos. Para las transferencias a países no reconocidos como que ofrecen una protección adecuada, aseguramos la protección de los datos mediante cláusulas contractuales estándar u otros mecanismos aprobados, garantizando garantías adecuadas.', $locale, ['website_title' => $website_title])); ?>

            </p>

            <h2><?php echo e(aiTrans('Políticas de retención de datos')); ?></h2>
            <p><?php echo e(aiTrans('Conservamos sus datos personales solo durante el tiempo necesario para los objetivos definidos en este Aviso, en conformidad con las leyes aplicables. Cuando ya no necesitemos sus datos personales, serán eliminados o anonimizados.')); ?>

            </p>

            <h2><?php echo e(aiTrans('Contáctenos')); ?></h2>
            <p><?php echo e(aiTrans('Si tiene alguna consulta sobre este Aviso, no dude en comunicarse con nosotros en')); ?> <a
                    href="<?php echo e(route('home', $country)); ?>"><?php echo e(aiTrans('[website_title]', $locale, ['website_title' => $website_title])); ?></a>.
            </p>

            <h2><?php echo e(aiTrans('Actualizaciones del Aviso')); ?></h2>
            <p><?php echo e(aiTrans('Este Aviso de privacidad puede ser modificado ocasionalmente. Le notificaremos sobre cualquier cambio significativo conforme a lo estipulado por la ley.')); ?>

            </p>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mb/public_html/new.crizymp.xyz/resources/views/frontend/es/privacy.blade.php ENDPATH**/ ?>