
<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title での個人情報の取扱いに関する方針"); ?></title>
    <meta name="description" content="<?php echo e("$website_title が提供する個人情報と情報セキュリティのポリシーについて、ここで詳しく説明します。確認してください。"); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="banner uk-text-center">
    <h1>個人情報保護方針</h1>
</div>

<section class="section2">
    <div class="uk-container">
        <div>
            <p><?php echo e(aiTrans('私たちはあなたの個人データとあなたのプライバシーを保護することを約束します。')); ?></p>
            <p>
                <?php echo e(aiTrans(
                    'このプライバシーポリシーは、当社のウェブサイト [website_title]（「ウェブサイト」）に関連してお客様から当社に提供された情報を当社がどのように管理、収集、保存、使用するかをお知らせするために作成されました。',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
            <p><?php echo e(aiTrans('私たちは以下の原則を尊重します：')); ?></p>
            <ul>
                <li aria-level="1"><b><?php echo e(aiTrans('あなたに関する個人データの収集と処理に関して透明性を保ちます。')); ?></b></li>
            </ul>
            <p><?php echo e(aiTrans('個人データの処理について十分な情報に基づいた決定を下せるように、必要なすべての情報を常に把握しておくことが重要です。 これを行うために、私たちはあなたの個人データの処理に関する関連情報を適切な方法で適切な時期に提供するように設計されたさまざまな技術と手段を使用します。')); ?></p>
            <p><?php echo e(aiTrans('また、特定の情報を提供する必要があると当社が判断した場合は、適切な時間と場所で提供します。')); ?></p>
            <p class="gt-block"><?php echo e(aiTrans('また、法的な制限に従い、ご不明な点がございましたら、お気軽にお問い合わせください。 これを行うには、次のアドレスに電子メールを送信してお問い合わせください。')); ?>&nbsp;info<?php echo e('@'.$website_title); ?></p>
            <ul>
                <li aria-level="1"><b><?php echo e(aiTrans('ポリシーに示されている目的でのみ、お客様の個人データを取り扱います。')); ?></b></li>
            </ul>
            <p><?php echo e(aiTrans('当社がお客様の個人データを処理する目的には、とりわけ、お客様が当社のWebサイトを利用できるようにし、そこに含まれるサービス（「サービス」）を提供すること、当社のWebサイトでのユーザーエクスペリエンスを改善すること、当社のサービスを改善することが含まれます。ウェブサイト）、当社の権利と利益を保護し、ユーザーへの当社のサービスの提供をサポートする商業的および管理的活動を実行し、および/または法的および/または規制上の要件を遵守します。')); ?></p>
            <p><?php echo e(aiTrans('さらに、私たちはあなたの個人的なニーズと好みを理解するためにあなたの個人データを処理します。')); ?></p>
            <ul>
                <li aria-level="1"><b><?php echo e(aiTrans('あなたに関する個人データに関連するあなたの権利を尊重するために重要なリソースを投資してください：')); ?></b></li>
            </ul>
            <ul>
                <li>
                    <ul>
                        <li aria-level="1"><?php echo e(aiTrans('データ主体としての権利を行使できるように、重要なリソースを適用します。 したがって、お客様の個人データを確認したり、変更、削除、特定または一般的な目的での使用を停止したり、お客様または第三者に転送したりする場合は、いつでもご連絡いただけます。 私たちは法律に従ってあなたの願いを実行します。')); ?></li>
                    </ul>
                </li>
            </ul>
            <ul>
                <li aria-level="1"><b><?php echo e(aiTrans("あなたに関する個人データの保護：")); ?></b></li>
            </ul>
            <p><?php echo e(aiTrans('お客様の個人データの絶対的な保護をお約束することはできませんが、お客様の個人データのセキュリティを確保することを目的とした幅広い手段と手段を使用し、今後も使用することをお約束します。')); ?></p>
            <p><?php echo e(aiTrans('私たちの完全なプライバシーポリシー。')); ?></p>
            <ol>
                <li><b><?php echo e(aiTrans('適用範囲は？')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('このポリシーでは、当社が自然人に関して収集する個人データの種類、および収集、使用、第三者との共有、保護、処理などの方法について説明します。')); ?></p>
            <p><?php echo e(aiTrans('このポリシーでは、「個人データ」とは、特定された、または特定可能な自然人に関連する情報を指します。 識別可能な自然人とは、直接、または私たちが持っている、または私たちがアクセスできる追加情報と組み合わせて識別できる人のことです。')); ?></p>
            <p><?php echo e(aiTrans('このポリシーでは、個人データの「取り扱い」とは、個人データに対して実行されるすべての操作または一連の操作を指します。これには、収集、登録、編成、構造化、保存、適合または変更、回復、相談、使用、送信による開示が含まれます。 、放送またはその他の方法で利用可能にされる、個人データの調整または組み合わせ、制限、消去または破壊。')); ?></p>
            <p><?php echo e(aiTrans('当社のサービスは一般の人々を対象としており、18歳未満の子供を対象としていません。 18歳未満の人から故意に情報を収集または要求したり、そのような個人が当社のサービスにアクセスすることを故意に許可したりすることはありません。 お子様に関する情報が収集されたことが判明した場合、そのような情報をできるだけ早く削除するための合理的な措置を講じます。')); ?></p>
            <ol start="2">
                <li><b><?php echo e(aiTrans('私たちはいつあなたの個人データを収集しますか？')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('当社は、お客様が当社のサービスを使用する、当社のサービスチャネルを使用する、ウェブサイトを使用する、および/または当社に連絡するたびに、お客様の個人データを収集します。 お客様が積極的に個人データを当社に提供する場合もあれば、当社のサービスおよび/または当社のサービスチャネルの使用を調査および分析することにより、お客様に関する個人データを収集する場合もあります。')); ?></p>
            <ol start="3">
                <li><b><?php echo e(aiTrans('会社に個人データを提供する義務はなく、その影響')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('あなたは私たちにあなた自身の個人情報を提供する義務はありません。 ただし、場合によっては、そのような個人データの提供を怠ると、当社がお客様にサービスを提供できなくなったり、お客様がWebサイトを使用できなくなったり、当社のサービスおよびWebサイトが誤動作したりすることがあります。')); ?></p>
            <ol start="4">
                <li><b><?php echo e(aiTrans('私たちはあなたについてどのような個人データを収集しますか？')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('個人データ当社は、お客様がWebサイトを閲覧するたびに収集します。この情報には、オンラインアクティビティログ、トラフィック情報（IPアドレス、アクセス時間、アクセス日など）が含まれます。使用する言語、ソフトウェアのクラッシュレポート、使用するブラウザの種類、使用したデバイスに関する情報。この情報の一部は、個人を特定できない場合があるため、個人データを構成するものではありません。')); ?></p>
            <p><?php echo e(aiTrans('私たちがあなたから受け取る個人データ：あなたが私たちに連絡するときにあなた自身の自由意志で私たちに提供する個人データ。')); ?></p>
            <p><?php echo e(aiTrans('お客様が第三者に送信するために特別に提供する個人データ：この情報には、お客様の名前と電子メールアドレスが含まれます。')); ?></p>
            <ol start="5">
                <li><b><?php echo e(aiTrans('個人データの処理の目的とその法的根拠')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('当社は、このセクションに記載されているXNUMXつ以上の目的のために、適切な法的根拠に従って、お客様の個人データを処理します。')); ?></p>
            <p><?php echo e(aiTrans('当社は、そのような取り扱いの法的根拠がない限り、お客様の個人データを処理しません。 当社がお客様の個人データを処理するための法的根拠は次のとおりです。')); ?></p>
            <ol>
                <li aria-level="1"><b><?php echo e(aiTrans('あなたは、XNUMXつまたは複数の特定の目的のためにあなたの個人データを処理することに同意しました。')); ?>&nbsp;</b><?php echo e(aiTrans('これは、お客様がWebサイトを通じてお客様のデータを具体的に提供し、第三者に提示する場合を指します。')); ?></li>
                <li aria-level="1"><b><?php echo e(aiTrans('当社または第三者が追求する正当な利益のために必要な扱いとなります。')); ?></b>。 <?php echo e(aiTrans('例として、当社のサービスを改善するため、または法的請求の行使または防御のため。')); ?></li>
                <li aria-level="1"><b><?php echo e(aiTrans('当社が従う法的義務を履行するためには、この扱いが必要です。')); ?></b>.</li>
            </ol>
            <p class="gt-block"><?php echo e(aiTrans('いつでもメールアドレスに通知を送信してお問い合わせいただけます')); ?>&nbsp;info<?php echo e('@'. $website_title); ?>、<?php echo e(aiTrans('当社が実施したレビューに関する情報を受け取るため。 これは、当社または第三者が追求する正当な利益のためにそのような処理が必要であるため、当社がお客様の個人データを処理する可能性があると結論付けることができるようにするためです。')); ?></p>
            <p><?php echo e(aiTrans('以下のリストは、当社がお客様に関する個人データを処理する目的と、そのような処理の法的根拠を説明しています。')); ?></p>
            <table>
                <tbody>
                    <tr>
                        <td>
                            <p class="gt-block"><b>#</b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('目的')); ?></b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('法的根拠')); ?></b></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="gt-block"><b>1</b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('あなたの要求に応じてあなたのデータを第三者に提示するため')); ?></b></p>
                            <p><?php echo e(aiTrans('お客様が特に要求した場合、第三者に提示するためにお客様の個人データを収集する場合があります。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('あなたは、XNUMXつまたは複数の特定の目的のためにあなたの個人データを処理することに同意しました。')); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="gt-block"><b>2</b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('お問い合わせ、ご要望、クレームに対応するため')); ?></b></p>
                            <p><?php echo e(aiTrans('お客様の個人データの処理は、本サービスの使用に関してお客様が行うクエリに応答するために必要です。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('治療は、当社または第三者が追求する正当な利益のために必要です。')); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="gt-block"><b>3</b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('法的義務または司法または行政命令を遵守するため')); ?></b></p>
                            <p><?php echo e(aiTrans('当社は、さまざまな法的義務を遵守するためにお客様の個人データを処理します。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('当社が従う法的義務を履行するためには、この扱いが必要です。')); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="gt-block"><b>4</b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('私たちのサービスを改善するために')); ?></b></p>
                            <p><?php echo e(aiTrans('当社は、サービスを改善するためにお客様の個人データを使用する場合があります。 このような処理には、とりわけ、サービスに関して取得された障害ログまたはその他の誤動作レポートが含まれます。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('治療は、当社または第三者が追求する正当な利益のために必要です。')); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="gt-block"><b>5</b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('詐欺を防止するために、当社のサービスの乱用')); ?></b></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('治療は、当社または第三者が追求する正当な利益のために必要です。')); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="gt-block"><b>6</b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('当社のサービスの提供をサポートするさまざまな活動を実行および維持するため。')); ?></b></p>
                            <p><?php echo e(aiTrans('このような活動には、バックオフィス機能、事業開発活動、戦略的意思決定、監視メカニズムなどが含まれます。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('治療は、当社または第三者が追求する正当な利益のために必要です。')); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="gt-block"><b>7</b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('統計を含む分析を実行するには')); ?></b></p>
                            <p><?php echo e(aiTrans('さまざまな分析手段（統計を含む）を使用して、さまざまな問題について決定を下します。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('治療は、当社または第三者が追求する正当な利益のために必要です。')); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="gt-block"><b>8</b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('法的請求の開始、行使、防御を含む、当社の利益、権利、資産、および第三者の利益を保護するため')); ?></b></p>
                            <p><?php echo e(aiTrans('当社は、当社の契約条件およびポリシーを含む法律、規制、または合意に従って、当社の利益、権利、資産、または第三者の利益を保護するために、お客様に関する個人データを処理する場合があります。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('治療は、当社または第三者が追求する正当な利益のために必要です。')); ?></p>
                        </td>
                    </tr>
                </tbody>
            </table>
            <ol start="6">
                <li><b><?php echo e(aiTrans('個人データの第三者への転送')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('当社はまた、ホスティングおよびストレージプロバイダー、IPアドレス情報、ユーザーエクスペリエンス分析、調査、分析、技術および診断サービスなどのサービスを提供するサードパーティとお客様の個人データを共有する場合があります。')); ?></p>
            <p><?php echo e(aiTrans('さらに、あなたは私たちがあなたに関する特定の個人データをサードパーティのビットコイン取引プラットフォームに提出することを具体的に要求することができます。 そのような場合、私たちはあなたがこの目的のために私たちに提供する個人データをそのような第三者に共有し、あなたの個人データの彼らの使用は彼ら自身のプライバシーポリシーの対象となります。')); ?></p>
            <p><?php echo e(aiTrans('当社はまた、お客様に関する個人データを関連エンティティおよびビジネスパートナーと共有する場合があります。これらのエンティティは、当社がユーザーに提供するサービスおよび製品のレベルを向上および改善するためのリソースをお客様に提供します。')); ?></p>
            <p><?php echo e(aiTrans('当社は、お客様に関する個人データを政府、地方、公的および規制当局と共有する場合があります。また、法的請求の開始、行使、防御など、当社の利益、権利、資産、および第三者の利益を保護するためにそのような開示が必要な場合も同様です。 。')); ?></p>
            <p><?php echo e(aiTrans('さらに、当社および/または当社が属する企業グループの企業の潜在的な購入者または投資家、または貸し手に、または同様の取引の場合（会社の資産の売却）会社および/または会社が属する会社グループの会社）、および/または会社および/または会社の合併、再編成、統合または破産に関連してそれが会社の一部である会社のグループの会社。')); ?></p>
            <ol start="7">
                <li><b><?php echo e(aiTrans('クッキーとサードパーティのサービス')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('当社は、分析会社や当社のWebサイトに広告を配信する会社など、Cookieやその他のテクノロジーを使用する可能性のある特定のサードパーティサービスを使用する場合があり、それらの慣行およびプロバイダーには独自のポリシーが適用されます。')); ?></p>
            <p><?php echo e(aiTrans('Cookie（小さなテキストファイル）は、Webサイトにアクセスまたはアクセスするために使用するデバイスにインストールされます。 Cookieを使用すると、ユーザーエクスペリエンスを向上させ、ユーザーの好みや設定を記憶し、ユーザーが関心を持つ可能性のある製品やサービスをパーソナライズして提供するために、ユーザーとユーザーの行動に関する情報を収集できます。 Cookieを使用して、統計を収集し、分析を実行することもできます。')); ?></p>
            <p><?php echo e(aiTrans('当社が使用する可能性のあるCookieの一部はセッションCookieであり、一時的にデバイスにダウンロードされ、Webブラウザーを閉じるまで持続しますが、その他のCookieは永続的なCookieであり、閲覧を停止した後もデバイスに残ります。あなたが再びそれを訪問するとき、ウェブサイトがあなたをリピーターとして思い出すのを手伝ってください。')); ?></p>
            <p class="gt-block"><b>クッキーの種類：</b></p>
            <p><?php echo e(aiTrans('使用できるCookieは、機能に応じて次のように分類されます。')); ?>&nbsp;</p>
            <table>
                <tbody>
                    <tr>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('クッキーの種類')); ?></b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('目的')); ?></b></p>
                        </td>
                        <td>
                            <p class="gt-block"><b><?php echo e(aiTrans('追加情報')); ?></b></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p><?php echo e(aiTrans('厳密に必要なクッキー')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('これらのCookieは、Webサイトをナビゲートし、要求した機能を使用できるようにするために厳密に必要です。 それらは、あなたが要求したコンテンツ、製品、サービスを提供するために使用されます。')); ?></p>
                            <p><?php echo e(aiTrans('これらのCookieは、デバイスが情報をダウンロードまたは送信して、Webサイトをナビゲートし、その機能を使用して、以前にアクセスしたページに戻ることができるようにするために不可欠です。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('これらのCookieは、ユーザー名や最終ログイン日などの個人データを収集し、Webサイトに接続していることを識別します。')); ?></p>
                            <p><?php echo e(aiTrans('これらのCookieは、Webブラウザを閉じると削除されます（セッションCookie）。')); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p><?php echo e(aiTrans('機能性Cookie')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('これらのCookieは、お客様がWebサイトに戻ったときにお客様を認識し、お客様の選択や好みを記憶できるようにするために使用されます。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('これらのCookieは、Webブラウザーを閉じても存続し、該当する有効期限まで存続します。')); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p><?php echo e(aiTrans('パフォーマンスCookie')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('これらのCookieは、ユーザーエクスペリエンスを向上させるために、Webサイトのパフォーマンスに関する集計統計を提供し、そのようなパフォーマンスをテストおよび改善するために使用されます。 さらに、それらは私達がウェブサイト上で分析機能を実行することを可能にします。')); ?></p>
                        </td>
                        <td>
                            <p><?php echo e(aiTrans('これらのCookieは、特定された、または特定可能な自然人に関連しない匿名データを収集します。')); ?></p>
                            <p><?php echo e(aiTrans('これらのCookieはさまざまな期間有効です。 ブラウザを閉じると削除されるものもあれば、有効期間が無期限のものもあります。')); ?></p>
                        </td>
                    </tr>
                </tbody>
            </table>
            <p><?php echo e(aiTrans('クッキーのブロックと排除')); ?></p>
            <p><?php echo e(aiTrans('ブラウザの設定を変更して、一部またはすべてのCookieをブロックおよび削除できます。 いくつかのより人気のあるWebブラウザーでこれを行う方法については、次のリンクを参照してください。')); ?></p>
            <ul>
                <li aria-level="1"><a href="https://support.mozilla.org/en-US/kb/Cookies">Firefoxの</a></li>
                <li aria-level="1"><a href="https://support.microsoft.com/en-gb/help/17442/windows-internet-explorer-delete-manage-cookies">インターネットエクスプローラ</a></li>
                <li aria-level="1"><a href="https://support.google.com/chrome/bin/answer.py?hl=en&amp;answer=95647">Google Chrome</a></li>
                <li aria-level="1"><a href="https://support.apple.com/en-ph/guide/safari/sfri11471/mac">Safari</a></li>
            </ul>
            <p><?php echo e(aiTrans('ただし、その場合、ウェブサイトの一部または全部が意図したとおりに機能しない場合がありますので、あらかじめご了承ください。')); ?></p>
            <p class="gt-block"><b><?php echo e(aiTrans('オンライン追跡通知')); ?></b></p>
            <p class="gt-block"><b><?php echo e(aiTrans('現時点では、このサービスは追跡禁止の兆候を許可していません。')); ?></b></p>
            <ol start="8">
                <li><b><?php echo e(aiTrans('個人データの保護')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('当社は、本ポリシーに示されている個人データの処理の目的を達成するために必要な期間、または法律、規制、ポリシー、および当社に適用される命令によって要求されるより長い期間、お客様の個人データを保持します。')); ?></p>
            <p><?php echo e(aiTrans('お客様の個人情報が必要以上に長く保管されないようにするため、当社は定期的に保有する個人情報を確認し、個人情報が消去される可能性があるかどうかを調査します。')); ?></p>
            <ol start="9">
                <li><b><?php echo e(aiTrans('第三国または国際機関への個人データの転送')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('あなたに関する個人データは、第三国（つまり、あなたの居住地以外の管轄区域）または国際機関に転送される場合があります。 そのような状況では、会社はあなたの個人データの保護を保証し、利害関係者が彼らの権利を行使し、効果的な法的救済を得ることができることを保証するために適切なセキュリティ対策を採用します。')); ?></p>
            <p><?php echo e(aiTrans('EEA（欧州経済領域）の居住者である場合、以下の条件のいずれかが満たされた場合、これらのセーフガードと保護が利用可能になることに注意してください。')); ?></p>
            <ul>
                <li aria-level="1"><?php echo e(aiTrans('転送は、EU委員会が欧州議会の規則（EU）45/3の第2016条（679）に従って転送された個人データに適切なレベルの保護を提供すると決定した、第三国または国際機関への転送です。 27年2016月XNUMX日の理事会（「GDPR」）の、EU-USプライバシーシールドフレームワークに従った譲渡を含みます。')); ?></li>
                <li aria-level="1"><?php echo e(aiTrans('譲渡は、RGPDの第46条、セクション2、レターa）に従って、公的機関または団体間の法的拘束力のある強制力のある手段に従います。 また')); ?></li>
                <li aria-level="1"><?php echo e(aiTrans('転送は、GDPRの第46条、セクション2、文字c）に従ってEU委員会が採用した標準のデータ保護条項に準拠しています。 EU委員会によって採択された条項は、次のURLで参照できます。&nbsp;<a href="https://ec.europa.eu/info/law/law-topic/data-protection/data-transfers-outside-eu/model-contracts-transfer-personal-data-third-countries_en">https://ec.europa.eu/info/law/law-topic/data-protection/data-transfers-outside-eu/model-contracts-transfer-personal-data-third-countries_en</a>.&nbsp;')); ?></li>
                <li aria-level="1"><?php echo e(aiTrans('次のアドレスに電子メールを送信することにより、第三者または国際機関に転送されるお客様の個人データを保護するために当社が使用するセーフガードの詳細を提供するように当社に要求できます。')); ?> &nbsp;info<?php echo e('@'.$website_title); ?></li>
            </ul>
            <ol start="10">
                <li><b><?php echo e(aiTrans('個人データの保護')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('当社は、適切な技術的および組織的措置を適用して、個人データの適切なレベルのセキュリティを保証します。特に、偶発的または違法な破壊、紛失、改ざん、不正な開示、または送信された個人データへのアクセスなど、治療によってもたらされるリスクを考慮に入れます。保存またはその他の方法で処理されます。')); ?></p>
            <p><?php echo e(aiTrans('当社の管理が及ばない法的またはその他の義務により、お客様に関する個人データを公的機関などの第三者に転送する必要がある場合があります。 そのような状況では、当社は、そのような第三者によってお客様に関する個人データに提供される保護のレベルを制限的に管理します。')); ?></p>
            <p><?php echo e(aiTrans('インターネットを介した個人データの転送は、完全に安全ではありません。 したがって、当社は、インターネットを介して当社に転送される場合、お客様の個人データの保護を保証することはできません。')); ?></p>
            <ol start="11">
                <li><b><?php echo e(aiTrans('サードパーティのWebサイトへのリンク')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('ウェブサイトは、サードパーティのウェブサイトおよび/またはアプリケーションへのリンクを提供する場合があります。 当社は、かかるウェブサイトおよびアプリケーション、ならびにかかるウェブサイトおよびアプリケーションによるお客様の個人データの収集および/または処理を管理せず、かかるウェブサイトおよびアプリケーション、あるいはそれらのプライバシーおよびデータ保護のポリシーおよび活動について責任を負いません。 このポリシーは、そのようなWebサイトおよび/またはアプリケーションを通じて実行されるアクションには適用されません。')); ?></p>
            <p><?php echo e(aiTrans('そのような第三者のウェブサイトおよび/またはアプリケーションにアクセスするときはいつでも、そのようなウェブサイトおよび/またはアプリケーションを使用する前、およびあなた自身に関する個人データを開示する前に、それらのプライバシーポリシーを注意深く確認することをお勧めします。')); ?></p>
            <ol start="12">
                <li><b><?php echo e(aiTrans('このポリシーの変更')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('当社は、このポリシーの条件を随時変更する場合があります。 このポリシーを変更する場合は常に、更新されたポリシーをWebサイトに掲載することにより、そのような変更を通知します。 さらに、本ポリシーに大幅な変更を加える場合は、そのような変更を通知するのに合理的に適切であると当社が考える通信手段を通じて、およびそのような変更の通知をWebサイトに掲載することにより、そのような変更を通知するよう努めます。 特に明記されていない限り、すべての変更は、更新されたポリシーが当社のWebサイトに公開された時点で有効になります。')); ?></p>
            <ol start="13">
                <li><b><?php echo e(aiTrans('あなたに関する個人データに関するあなたの権利')); ?></b></li>
            </ol>
            <p><?php echo e(aiTrans('一般に、お客様は、当社がお客様の個人データを収集しているかどうかの確認を要求し、そのようなデータの確認を要求し、必要に応じてコンテンツを修正し、不要になった個人データを削除する権利を有します。 また、個人データの特定の処理に対する同意を制限することもできます。')); ?></p>
            <p><?php echo e(aiTrans('EEAの居住者である場合は、次のセクションをお読みください。')); ?></p>
            <p class="gt-block">あなたは、あなたに関する個人データに関して以下の権利を有します。 これらの権利を行使するには、次の電子メールアドレスに権利を行使するように要求を送信できます。&nbsp;info<?php echo e('@'.$website_title); ?></p>
            <p class="gt-block"><b><?php echo e(aiTrans('アクセス権')); ?></b></p>
            <p><?php echo e(aiTrans('お客様は、お客様の個人データが処理されているかどうかの確認、および処理されている場合は、個人データおよび以下の情報へのアクセスを会社から受け取る権利があります。（1）治療の目的。 （2）問題の個人データのカテゴリー。 （3）個人データが開示された、または開示される予定の受信者または受信者のカテゴリ、特に欧州経済領域（EEA）または国際機関以外の第三国の受信者。 （4）可能であれば、個人データの予想される保持期間、または不可能な場合は、当該期間を決定するために使用される基準。 （5）個人データの修正または削除を当社に要求する権利、またはお客様に関する個人データの処理を制限する権利、またはそのような処理に反対する権利の存在。 （6）監督当局に請求を行う権利。 （7）個人データがお客様から収集されていない場合、その出所に関する入手可能な情報。 （8）プロファイリングの存在。 （9）個人データがEEA外の第三国または国際機関に転送される場合、転送に関する適切な保護手段。')); ?></p>
            <p><?php echo e(aiTrans('会社は、処理中の個人データのコピーをお客様に提供し、お客様が要求するその他のコピーに対して妥当な料金を請求する場合があります。 電子的にリクエストする場合、特にリクエストしない限り、情報は一般的に使用される電子形式で提供されます。')); ?></p>
            <p><?php echo e(aiTrans('個人データのコピーを取得する権利は、他者の権利と自由に悪影響を及ぼしてはなりません。 したがって、要求が他者の権利と自由を害する場合、当社はあなたの要求に応答しないか、限られた方法で応答する場合があります。&nbsp;')); ?></p>
            <p class="gt-block"><b><?php echo e(aiTrans('修正の権利')); ?></b></p>
            <p><?php echo e(aiTrans('あなたには、あなたに関する不正確な個人データの修正を会社から取得する権利があります。 治療の目的を考慮して、あなたは補足的な声明を提供することを含め、あなたに関する不完全な個人データを完成させる権利があります。')); ?></p>
            <p class="gt-block"><b><?php echo e(aiTrans('消去の権利')); ?></b></p>
            <p><?php echo e(aiTrans('以下のいずれかの理由が当てはまる場合、お客様は当社からお客様に関する個人データの削除を取得する権利を有します。（a）別のモードで収集または処理された目的に関連して個人データが不要になった場合; （b）治療の根拠となる同意を撤回し、治療に他の法的理由がない場合。 （c）お客様は、特定の状況に関連する理由により、当社または第三者が追求する正当な利益に基づくお客様の個人データの処理にいつでも異議を唱え、正当な理由はありません。処理; （d）ダイレクトマーケティングの目的であなたに関する個人データの処理に反対する場合。 （e）個人データが違法に処理された。 または（f）欧州連合の法的義務または当社が従う加盟国の法律を遵守するために、お客様の個人データを消去する必要があります。')); ?></p>
            <p><?php echo e(aiTrans('この権利は、治療が必要な場合には適用されません。（a）欧州連合または当社が対象とする加盟国の法律に従って治療を必要とする法的義務を履行するため。 または（b）法的請求の確立、行使、または弁護のため。')); ?></p>
            <p class="gt-block"><b><?php echo e(aiTrans('治療制限の権利')); ?></b></p>
            <p><?php echo e(aiTrans('お客様は、以下のいずれかの状況が発生した場合、当社からお客様の個人データの処理の制限を取得する権利を有します。（a）当社が正確性を検証できる期間、お客様が個人データの正確性に異議を唱える場合。あなたに関する個人データの; （b）処理が違法であり、お客様はお客様の個人データの消去に反対し、代わりにその使用の制限を要求します。 （c）当社は、治療の目的でお客様の個人データを必要としなくなりましたが、法的請求の確立、行使、または防御のためにお客様が個人データを必要とします。 （d）当社または第三者が追求する正当な利益のためにお客様の個人データの処理が必要な場合、当社がお客様の利益、権利および自由に優先する処理のやむを得ない正当な理由を示さない限り、または法的請求の確立、行使、または防御。 または（e）お客様の個人データが、そのようなダイレクトマーケティングに関連する限り、プロファイリングを含むダイレクトマーケティングの目的で処理される場合。')); ?></p>
            <p><?php echo e(aiTrans('お客様の要求の結果としてお客様の個人データの処理が制限された場合、そのような個人データは、保管を除き、お客様の同意がある場合、または法的請求の確立、行使、防御、または別の自然人または法人の権利、または欧州連合または加盟国の重要な公益のため。')); ?></p>
            <p class="gt-block"><b><?php echo e(aiTrans('データの移植性に対する権利')); ?></b></p>
            <p><?php echo e(aiTrans('お客様は、当社に提供したお客様の個人データを、構造化され、一般的に使用され、機械で読み取り可能な形式で受け取る権利と、次の場合に、当該個人データを別のデータ管理者に送信する権利を有します。 ）治療はあなたの同意またはあなたが当事者である契約に基づいており、（b）治療は自動化された手段によって実行されます。')); ?></p>
            <p><?php echo e(aiTrans('データの移植性に対する権利を行使する際、技術的に可能な場合はいつでも、あなたはあなたに関係する個人データを会社から別のデータ管理者に直接送信する権利があります。 データの移植性に対するあなたの権利の行使は、あなたの削除する権利によって、あなたの権利および会社の権利を害することなく理解されます。 さらに、データの移植性に対する権利は、他の人々の権利と自由に悪影響を与えることはありません。')); ?></p>
            <p class="gt-block"><b><?php echo e(aiTrans('異議の権利')); ?></b></p>
            <p><?php echo e(aiTrans('お客様は、特定の状況に関連する理由により、当社または第三者が追求する正当な利益に基づく個人データの処理にいつでも異議を唱える権利を有します。これには、それらの正当な利益に基づくプロファイリングも含まれます。 この場合、お客様の利益、権利、自由に優先する扱い、または法的請求の確立、行使、防御について説得力のある正当な理由が示されない限り、お客様の個人データの処理を停止します。')); ?></p>
            <p><?php echo e(aiTrans('お客様は、ダイレクトマーケティングに関連する限り、プロファイリングを含むダイレクトマーケティングの目的での個人データの処理にいつでも異議を唱える権利を有します。')); ?></p>
            <p class="gt-block"><b><?php echo e(aiTrans('同意を撤回する権利')); ?></b></p>
            <p><?php echo e(aiTrans('個人データの処理について当社に与えた同意は、撤回前の同意に基づく処理の合法性に影響を与えることなく、いつでも撤回することができます。')); ?></p>
            <p class="gt-block"><b><?php echo e(aiTrans('監督当局に請求を行う権利')); ?></b></p>
            <p><?php echo e(aiTrans('あなたには、欧州連合での個人データの処理に関連する自然人の基本的権利と自由を保護するために、加盟国によって設立された監督当局に請求を提出する権利があります。')); ?></p>
            <p><?php echo e(aiTrans('このセクション13に示されているように、お客様に関する個人データに関するお客様の権利は、欧州連合または当社が対象とする加盟国の法律によって制限される場合があります。')); ?></p>
            <p><?php echo e(aiTrans('当社は、このセクション13に記載されているお客様の権利に従って、要求された情報を遅滞なく、いずれにしても、要求を受け取ってからXNUMXか月以内に提供します。 この期間は、リクエストの複雑さと数を考慮して、必要に応じてさらにXNUMXか月延長できます。 この延長については、リクエストを受け取ってからXNUMXか月以内に、遅延の理由とともにお知らせします。')); ?></p>
            <p><?php echo e(aiTrans('このセクション13に記載されているお客様の権利に従って要求された情報は、このセクション13に別段の記載がない限り、無料で提供されます。情報または通信を提供する、または要求されたアクションを実行するための管理コストを考慮に入れて、料金を請求します。合理的な料金。 または（b）リクエストの処理を拒否します。')); ?></p>
            <p><?php echo e(aiTrans('リクエストを行った自然人の身元について合理的な疑いがある場合、会社は、このセクション13に記載されているあなたの権利に従ってリクエストを履行するために、あなたの身元を確認するために必要な追加情報の提供を求める場合があります。')); ?></p>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mb/public_html/new.crizymp.xyz/resources/views/frontend/ja/privacy.blade.php ENDPATH**/ ?>