
<?php $__env->startPush('meta'); ?>

    <title><?php echo e("$website_title - (En sikker handelsplatform)"); ?></title>
    <meta name="description" content="<?php echo e("$website_title er en omfattende handelsapp, der styrker handlende på alle niveauer med avancerede værktøjer og ekspertsupport."); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <section class="uk-section uk-section-large hero-section">
        <div class="uk-container">
            <div class="hero-inner">

                <div class="uk-text-center hero-meta">
                    <h1 class="change-by-command"><?php echo e("Indtast  $website_title  programmet og  $website_title  tilstedeværelsen"); ?></h1>
                    <h2 class="uk-visible@s"><span class="change-by-command "><?php echo e("Strømlinet handel lige ved hånden"); ?></span> </h2>
                    <div class=" uk-visible@s">
                        <p class="change-by-command"><?php echo e("$website_title  programmet og  $website_title  tilstedeværelsen venter på dig"); ?></p>
                    </div>
                </div>



                <div class="uk-flex-middle uk-grid-small uk-margin-medium-top" uk-grid>

                    <div class="uk-width-expand@s uk-text-center uk-text-left@s uk-visible@s">
                        <img src="<?php echo e(asset('frontend/assets/da/dist')); ?>/images/screens-2.png" alt="">
                    </div>

                    <div class="uk-width-auto@s">
                        <div class="hero-form">
                            <h2>
                                <?php echo e(aiTrans('Tilmeld dig [website_title] gratis', $locale, ['website_title' => $website_title])); ?>

                            </h2>
                            <?php echo $__env->make('frontend.da.components.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="uk-text-center uk-hidden@s uk-margin-small-top">

                            <h2><?php echo e(aiTrans('Strømlinet handel lige ved hånden')); ?></h2>
                            <p>
                                <?php echo e(aiTrans(
                                    'Vi introducerer [website_title] , din alt-i-en-handelswebsted, perfekt strømlinet til
                                            hurtig,
                                            jævn og problemfri handel.',
                                    $locale,
                                    ['website_title' => $website_title],
                                )); ?>

                            </p>
                            <img class="uk-margin-xlarge-top"
                                src="<?php echo e(asset('frontend/assets/da/dist')); ?>/images/screens-2.png" alt="">
                        </div>

                    </div>

                </div>

            </div>
        </div>
    </section>

    <div class="uk-container">
        <div class="hero-notic">
            <p class="has-text-color">
                <?php echo e(aiTrans(
                    'Ansvarsfraskrivelse:[website_title] er et innovativt
                    softwareværktøj, der forbinder handlende med mæglere for kryptovaluta, Forex, CFD’er, aktier og mere. Husk,
                    at
                    investering og handel medfører risici, så invester ansvarligt og inden for dine midler. Gennemfør grundig
                    research,
                    vurder risici, og planlæg dit budget med omhu. Bemærk, at vores software foreslår mæglere tilfældigt baseret
                    på
                    aftaler med partnere. Sørg for, at din tildelte mægler opfylder de krævede standarder og regler.',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

            </p>
        </div>
    </div>


    <section class="uk-section">
        <div class="uk-container">
            <div class="uk-grid-medium" uk-grid>

                <div class="uk-width-1-2@s">
                    <img src="<?php echo e(asset('frontend/assets/da/dist')); ?>/images/cryptocurrency-trading-platform-1.jpeg"
                        alt="">
                </div>
                <div class="uk-width-expand@s">
                    <h2>
                        <?php echo e(aiTrans('Hvad er [website_title] ?', $locale, ['website_title' => $website_title])); ?>

                    </h2>
                    <p>
                        <?php echo e(aiTrans(
                            'Vi vil gerne byde dig velkommen til en handelsrevolution! [website_title] er en helt ny,
                            banebrydende
                            handelsapp, der kommer til at ændre, hvordan du handler, uanset om det er Crypto eller andre
                            aktiver.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                    </p>
                    <p><?php echo e(aiTrans('Vores app er en autohandelsapp, der bruger sofistikeret kunstig intelligens kombineret med algoritmer
                        til at sende dig lukrative handelsadvarsler i henhold til specifikke kriterier. Designet til at være
                        praktisk og let at bruge, drag fordel af en avanceret grænseflade, der er nem at navigere og egnet
                        til alle handlende, fra nybegyndere til meget erfarne erhvervsdrivende.')); ?>

                    </p>

                </div>

            </div>
        </div>
    </section>

    <section class="uk-section uk-section-muted">
        <div class="uk-container">
            <h2><?php echo e(aiTrans('| Sikker, sikker og fremragende!')); ?></h2>
            <p>
                <?php echo e(aiTrans(
                    '[website_title] giver dig en 100 % sikker oplevelse, der er meget tilgængelig, og da det hele er på din
                    mobile enhed, er det også bærbart. Handl fra din håndflade, når som helst du vil, hvor som helst du vil, og
                    slutt dig til det voksende [website_title] fællesskab, der alle drager fordel af mulighederne i XBT og
                    andre forskellige aktiver. Det handler lige ved hånden!',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

            </p>
            <a class="cu-button" href="#"><strong><?php echo e(aiTrans('Åbn din sikre konto her')); ?></strong></a>
        </div>
    </section>

    <section class="uk-section">
        <div class="uk-container">

            <div class="uk-text-center">
                <p><?php echo e(aiTrans('Selvom du er nybegynder, er denne app det rigtige for dig, især Cryptocurrency, som hurtigt er ved at
                                    blive et enormt
                                    anerkendt og anerkendt aktiv i handelsverdenen. Det er blevet handlet med succes i over ti år og vil
                                    fortsætte med
                                    at tage store spring fremad. Vores app er for alle, for dygtige investorer og begyndere – også selvom du
                                    først lige
                                    har opdaget Crypto eller andre former for handel.')); ?>

                </p>
                <p>
                    <?php echo e(aiTrans(
                        'Alle kan bruge [website_title] , til automatiseret handel, manuel handel eller en kombination af
                                            begge
                                            typer (hybrid
                                            handel), [website_title] er den perfekte handelspartner, alt i din hule hånd! Handl trygt og
                                            sikkert hele
                                            dagen og
                                            hele natten, vores app er på vagt 24/7 med kundesupport der for dig, hvis du har brug for det. Dette er
                                            din chance
                                            for at opnå store overskud, potentielt nyde økonomisk frihed og nå toppen af ​​handelssucces!',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                </p>
            </div>

            <div class="uk-child-width-1-3@s uk-grid-large uk-margin-large-top uk-grid-match" uk-grid>

                <div>
                    <div class="border-box">
                        <div class="box-ico">
                            <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" height="1em"
                                    width="1em" viewBox="0 0 512 512">
                                    <path fill="#a7d1d2"
                                        d="M466.5 83.7l-192-80a48.15 48.15 0 00-36.9 0l-192 80C27.7 91.1 16 108.6 16 128c0 198.5 114.5 335.7 221.5 380.3 11.8 4.9 25.1 4.9 36.9 0C360.1 472.6 496 349.3 496 128c0-19.4-11.7-36.9-29.5-44.3zM256.1 446.3l-.1-381 175.9 73.3c-3.3 151.4-82.1 261.1-175.8 307.7z">
                                    </path>
                                </svg></span>
                        </div>
                        <h3><?php echo e(aiTrans('Fuldstændig Auto-Trade Mode og Manuel Mode')); ?></h3>
                        <p>
                            <?php echo e(aiTrans(
                                'Der er to tilstande forbundet med [website_title] , en fuldautomatisk handelstilstand og en
                                manuel
                                tilstand. Ved at
                                bruge den automatiserede tilstand aktiverer du appen til at udføre alle handler på dine vegne,
                                der er ikke behov for
                                menneskelig indgriben.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <p><?php echo e(aiTrans('Den manuelle tilstand advarer dig, når der er en lukrativ handelsmulighed, gennem de involverede
                            AI-algoritmer – du beslutter, om du vil satse dine penge eller ej! Så enkelt er det.')); ?>


                        </p>
                    </div>
                </div>

                <div>
                    <div class="border-box">
                        <div class="box-ico">
                            <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" height="1em"
                                    width="1em" viewBox="0 0 496 512">
                                    <path fill="#a7d1d2"
                                        d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 96c48.6 0 88 39.4 88 88s-39.4 88-88 88-88-39.4-88-88 39.4-88 88-88zm0 344c-58.7 0-111.3-26.6-146.5-68.2 18.8-35.4 55.6-59.8 98.5-59.8 2.4 0 4.8.4 7.1 1.1 13 4.2 26.6 6.9 40.9 6.9 14.3 0 28-2.7 40.9-6.9 2.3-.7 4.7-1.1 7.1-1.1 42.9 0 79.7 24.4 98.5 59.8C359.3 421.4 306.7 448 248 448z">
                                    </path>
                                </svg></span>
                        </div>
                        <h3><?php echo e(aiTrans('Premium kunstig intelligens algoritmer')); ?></h3>
                        <p>
                            <?php echo e(aiTrans(
                                '[website_title] er drevet af sofistikerede algoritmer, der involverer kunstig intelligens
                                (AI).
                                Appen arbejder konstant på dine vegne, scanner alle markederne i realtid og analyserer tidligere
                                markedsmønstre for at vurdere mulighederne for at tjene penge. Når den har gjort sit arbejde,
                                gør den dig enten opmærksom på de tilgængelige muligheder, eller hvis du vælger den automatiske
                                version, fungerer den på dine vegne. Du behøver ikke at gøre noget; det virker for dig.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="border-box">
                        <div class="box-ico">
                            <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" height="1em"
                                    width="1em" viewBox="0 0 512 512">
                                    <path fill="#a7d1d2"
                                        d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm144 276c0 6.6-5.4 12-12 12h-92v92c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12v-92h-92c-6.6 0-12-5.4-12-12v-56c0-6.6 5.4-12 12-12h92v-92c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v92h92c6.6 0 12 5.4 12 12v56z">
                                    </path>
                                </svg></span>
                        </div>
                        <h3><?php echo e(aiTrans('For alle handlende, begyndere, mellemliggende og avancerede')); ?></h3>
                        <p>
                            <?php echo e(aiTrans(
                                'Det er lige meget, hvor du er i din handelsrejse, om du er en nybegynder, en erhvervsdrivende med
                                en vis erfaring eller en meget avanceret erhvervsdrivende – [website_title] er perfekt for
                                enhver
                                at bruge. Udnyt det fantastiske udvalg af handelsfunktioner, der er nemme at forstå og designet
                                til fornøjelig, hurtig og enkel handel.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>

            </div>

            <div class="uk-text-center uk-margin-medium-top">
                <p>
                    <?php echo e(aiTrans(
                        'Du bestemmer tempoet, mens vores app gør alt arbejdet for dig – arbejder altid inden for reglerne og
                                            forskrifterne, med sikkerhed og sikkerhed vores højeste prioritet. Tilmeld dig her og bliv en del af
                                            [website_title] -fællesskabet i dag.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                </p>
            </div>

        </div>
    </section>


    <section class="uk-section uk-section-muted">
        <div class="uk-container">

            <div class="uk-grid-collapse uk-flex-middle" uk-grid>
                <div class="uk-width-1-2@s">
                    <img src="<?php echo e(asset('frontend/assets/da/dist')); ?>/images/shutterstock_2148931699.jpg" alt="">
                </div>
                <div class="uk-width-1-2@s">
                    <div class="pad">
                        <h3>
                            <?php echo e(aiTrans('Er [website_title] pålidelig?', $locale, ['website_title' => $website_title])); ?>

                        </h3>
                        <p><?php echo e(aiTrans('Vores app er helt legitim, sikker og sikker, og vi overholder alle regler og regler. Der kan dog
                            være
                            nogle fup-apps, der efterligner vores egen app. Vi råder dig til omhyggeligt at tjekke software
                            eller e-mails, du modtager, for at sikre dig, at de er ægte, før du bruger dem. Lige nu er du på
                            den
                            rigtige hjemmeside, alle personlige oplysninger holdes sikre ved hjælp af krypteret software, og
                            vi
                            deler kun dine oplysninger med vores betroede mæglerpartnere, som vil støtte dig under din
                            handelsrejse – tjek altid alt, hvad du modtager fremadrettet, og brug kun vores app.')); ?>

                        </p>
                    </div>
                </div>
            </div>

            <div class="uk-grid-collapse uk-flex-middle" uk-grid>
                <div class="uk-width-1-2@s">
                    <div class="pad">
                        <h3>
                            <?php echo e(aiTrans('Kunstig intelligens og [website_title]', $locale, ['website_title' => $website_title])); ?>

                        </h3>
                        <p>
                            <?php echo e(aiTrans(
                                'Det smukke ved kunstig intelligens og kraftfulde algoritmer er, at når de er veldesignede, gør de
                                alt
                                på dine vegne. [website_title] bruger den nyeste, bedste kunstig intelligens-teknologi
                                kombineret
                                med avancerede algoritmer for at hjælpe dig med at handle så succesfuldt som muligt (bemærk, der
                                er
                                altid risiko forbundet med handel). Vi stræber også konstant efter at forbedre os, så vi altid
                                er på
                                forkant, et skridt foran alt andet lignende på markedet.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <p>
                            <?php echo e(aiTrans(
                                'Vores kunstige intelligens leverer indsigt i markedet i realtid sammen med dybdegående analyser,
                                så
                                du holder dig informeret hvert trin på vejen. Plus, det bliver konstant opdateret med nye
                                værktøjer,
                                instrumenter og funktioner, hvilket sikrer, at du har adgang til de mest opdaterede instrumenter
                                til
                                at understøtte din handel. Se, hvordan markedet klarer sig i realtid, tag bedre beslutninger og
                                nyd
                                sikker, sikker handel gennem [website_title] . Hvis du ønsker at tjene penge – er du i
                                gode
                                hænder.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>


                        </p>
                    </div>
                </div>
                <div class="uk-width-1-2@s order-1">
                    <img src="<?php echo e(asset('frontend/assets/da/dist')); ?>/images/shutterstock_2037091874.jpg" alt="">
                </div>
            </div>

            <div class="uk-grid-collapse uk-flex-middle" uk-grid>
                <div class="uk-width-1-2@s">
                    <img src="<?php echo e(asset('frontend/assets/da/dist')); ?>/images/shutterstock_767263567.webp" alt="">
                </div>
                <div class="uk-width-1-2@s">
                    <div class="pad">
                        <h3><?php echo e(aiTrans('Vores kunstige intelligens og algoritmer gør din handelsrejse bedre')); ?></h3>
                        <p><?php echo e(aiTrans('Med avanceret teknologi, mulighederne for enten manuel eller automatiseret handel, kunne du ikke
                            bruge en bedre handelsapp – vi står med garanti hoved og skuldre over vores konkurrenter.')); ?>

                        </p>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <section class="uk-section">
        <div class="uk-container">

            <div class="uk-text-center">
                <h2 class="heading-bt"><?php echo e($website_title); ?><?php echo e(aiTrans(' er:')); ?></h2>
            </div>

            <div class="uk-grid-large" uk-grid>
                <div class="uk-width-2-5@s"><img
                        src="<?php echo e(asset('frontend/assets/da/dist')); ?>/images/bd8d7140-f685-4734-9308-fbc673360ce2-1.png"
                        alt=""></div>

                <div class="uk-width-expand@s">

                    <ul class="check-ul">
                        <li><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                    height="1em" width="1em" viewBox="0 0 512 512">
                                    <path fill="#a7d1d2"
                                        d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z">
                                    </path>
                                </svg></span>
                            <span><?php echo e(aiTrans('Den moderne tilgang til handel.')); ?></span>
                        </li>

                        <li><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true"
                                    role="img" height="1em" width="1em" viewBox="0 0 512 512">
                                    <path fill="#a7d1d2"
                                        d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z">
                                    </path>
                                </svg></span>
                            <span><?php echo e(aiTrans('Bruger altid avanceret teknologi og tilbyder mere end 100 omsættelige Crypto-aktiver og
                                    alle andre aktiver.')); ?></span>
                        </li>

                        <li><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true"
                                    role="img" height="1em" width="1em" viewBox="0 0 512 512">
                                    <path fill="#a7d1d2"
                                        d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z">
                                    </path>
                                </svg></span>
                            <span><?php echo e(aiTrans('For alle niveauer af handlende, fra begyndere til erfarne og derimellem.')); ?></span>
                        </li>

                        <li><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true"
                                    role="img" height="1em" width="1em" viewBox="0 0 512 512">
                                    <path fill="#a7d1d2"
                                        d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z">
                                    </path>
                                </svg></span>
                            <span><?php echo e(aiTrans('Bruger historiske optegnelser til at spore mønstre og spotte muligheder for at tjene penge.')); ?></span>
                        </li>

                        <li><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true"
                                    role="img" height="1em" width="1em" viewBox="0 0 512 512">
                                    <path fill="#a7d1d2"
                                        d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z">
                                    </path>
                                </svg></span>
                            <span>
                                <?php echo e(aiTrans(
                                    'Med en dokumenteret resultater, bruger foreninger, handlende og mæglere allerede
                                        [website_title] trygt.',
                                    $locale,
                                    ['website_title' => $website_title],
                                )); ?>

                            </span>
                        </li>

                        <li><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true"
                                    role="img" height="1em" width="1em" viewBox="0 0 512 512">
                                    <path fill="#a7d1d2"
                                        d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z">
                                    </path>
                                </svg></span>
                            <span><?php echo e(aiTrans('Kundesupport tilgængelig 24 timer i døgnet, 7 dage om ugen, 365 dage om året.')); ?></span>
                        </li>

                        <li><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true"
                                    role="img" height="1em" width="1em" viewBox="0 0 512 512">
                                    <path fill="#a7d1d2"
                                        d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z">
                                    </path>
                                </svg></span>
                            <span><?php echo e(aiTrans('GRATIS at bruge, ingen gebyrer, ingen opsætningsomkostninger og ingen kommission
                                    involveret.')); ?>

                            </span>
                        </li>

                    </ul>
                </div>
            </div>

            <div class="uk-text-center uk-margin-medium-top">
                <a class="cu-button" href="#"><strong>
                        <?php echo e(aiTrans('Tilmeld dig her for din GRATIS [website_title] konto', $locale, [
                            'website_title' => $website_title,
                        ])); ?>

                    </strong></a>

            </div>

        </div>
    </section>

    <section class="uk-section uk-section-muted sec-border2">

        <div class="uk-container">

            <div class="uk-text-center">
                <h2>
                    <?php echo e(aiTrans('Find ud af, hvordan [website_title] virker', $locale, ['website_title' => $website_title])); ?>

                </h2>
                <p><?php echo e(aiTrans('Vi har din opmærksomhed! Fantastisk, find nu ud af, hvordan denne enestående app fungerer, og begynd
                                    potentielt at tjene mange penge gennem handel med aktiver og digitale aktiver.')); ?>

                </p>
            </div>

            <div class="uk-child-width-1-3@s uk-grid-large uk-margin-large-top uk-grid-match" uk-grid>

                <div>
                    <div class="border-box">
                        <div class="box-ico">
                            <span class="gb-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" height="15" width="15" fill="none"
                                    viewBox="0 0 15 15">
                                    <path fill="currentColor"
                                        d="M4 1.5V4H1.5A1.5 1.5 0 000 5.5v8A1.5 1.5 0 001.5 15h8a1.5 1.5 0 001.5-1.5V11h2.5A1.5 1.5 0 0015 9.5v-8A1.5 1.5 0 0013.5 0h-8A1.5 1.5 0 004 1.5zM5.5 1a.5.5 0 00-.5.5V4h4.5A1.5 1.5 0 0111 5.5V10h2.5a.5.5 0 00.5-.5v-8a.5.5 0 00-.5-.5h-8zm0 10A1.5 1.5 0 014 9.5V5H1.5a.5.5 0 00-.5.5v8a.5.5 0 00.5.5h8a.5.5 0 00.5-.5V11H5.5z"
                                        clip-rule="evenodd" fill-rule="evenodd"></path>
                                </svg>
                            </span>
                        </div>
                        <h3><?php echo e(aiTrans('TILMELD DIG GRATIS')); ?></h3>
                        <p>
                            <?php echo e(aiTrans(
                                'Det koster ikke noget at tilmelde sig [website_title] . Du skal blot udfylde
                                registreringsformularen øverst på siden med nogle grundlæggende oplysninger, herunder dit navn,
                                e-mailadresse, telefonnummer og bopælsland. Når formularen er indsendt og accepteret, kan du
                                begynde at bruge [website_title] appen og begynde at tjene penge (husk, at der altid er en
                                vis
                                risiko forbundet med handel, gør din due diligence inden du begiver dig ud på din handelsrejse).',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>


                        </p>
                    </div>
                </div>

                <div>
                    <div class="border-box">
                        <div class="box-ico">
                            <span class="gb-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" height="15" width="15" fill="none"
                                    viewBox="0 0 15 15">
                                    <path fill="currentColor"
                                        d="M4 4V1.5A1.5 1.5 0 015.5 0h8A1.5 1.5 0 0115 1.5v8a1.5 1.5 0 01-1.5 1.5H11v2.5A1.5 1.5 0 019.5 15h-8A1.5 1.5 0 010 13.5v-8A1.5 1.5 0 011.5 4H4zm6 1v5H5V5h5z"
                                        clip-rule="evenodd" fill-rule="evenodd"></path>
                                </svg>
                            </span>
                        </div>
                        <h3><?php echo e(aiTrans('AKTIVERING AF DIN KONTO')); ?></h3>
                        <p><?php echo e(aiTrans('Dernæst skal din konto aktiveres, når det er gjort, kan du placere din første handel (eller appen
                            vil gøre det på dine vegne, hvis du foretrækker det, når du vælger den automatiserede version).
                            Det mindste beløb, du kan indbetale, er $250 (du kan også indbetale flere penge). Det er dine
                            investeringspenge, brug dem til at handle og hæve eventuelle gevinster til enhver tid, eller
                            geninvester dem! Mange af vores forhandlere bruger midlerne til yderligere at finansiere deres
                            handelsrejse eller geninvestere deres fortjeneste.')); ?>

                        </p>

                    </div>
                </div>

                <div>
                    <div class="border-box">
                        <div class="box-ico">
                            <span class="gb-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" height="15" width="15" fill="none"
                                    viewBox="0 0 15 15">
                                    <path fill="currentColor"
                                        d="M4 4H1.5A1.5 1.5 0 000 5.5v8A1.5 1.5 0 001.5 15h8a1.5 1.5 0 001.5-1.5V11h2.5A1.5 1.5 0 0015 9.5v-8A1.5 1.5 0 0013.5 0h-8A1.5 1.5 0 004 1.5V4zm1-2.5a.5.5 0 01.5-.5h8a.5.5 0 01.5.5v8a.5.5 0 01-.5.5h-8a.5.5 0 01-.5-.5v-8z"
                                        clip-rule="evenodd" fill-rule="evenodd"></path>
                                </svg>
                            </span>
                        </div>
                        <h3><?php echo e(aiTrans('START AT HANDLE ENHVER AKTIV')); ?></h3>
                        <p><?php echo e(aiTrans('Dernæst, med kontoaktivering bekræftet og din indbetaling på plads, kan du starte din allerførste
                            handel. Du kan også lære om, hvordan du handler med succes gennem vores område med
                            uddannelsesressourcer, som har et væld af information om markedet, historiske mønstre, data,
                            indsigt og analyser. Din betroede mæglerpartner vil organisere alt for dig, forbinde din app til
                            deres platform og komme i gang. Appen scanner ikke kun markedet for muligheder, men hvis du
                            ønsker det, vil den automatisk handle på dine vegne. Foretrækker du en manuel oplevelse? Intet
                            problem, brug bare den manuelle funktion i stedet for!')); ?>

                        </p>
                    </div>
                </div>


            </div>

            <div class="uk-text-center uk-margin-medium-top">
                <a class="cu-button"
                    href="#"><strong><?php echo e(aiTrans('Registrer din konto her og begynd at handle i dag!')); ?></strong></a>
            </div>

        </div>

    </section>

    <section class="uk-section">
        <div class="uk-container">

            <div class="uk-text-center">
                <h2 class="heading-bb"><?php echo e(aiTrans('Funktioner')); ?></h2>
            </div>

            <div class="border-grid uk-child-width-1-3@s uk-grid-collapse uk-margin-large-top uk-grid-match" uk-grid>

                <div>
                    <div class="box-border box-bt">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                <path
                                    d="M511.935 469.013a8.446 8.446 0 00-.592-2.928c-.051-.124-.139-.22-.195-.341a8.39 8.39 0 00-.944-1.648l-57.938-74.491V145.067c-.015-14.132-11.468-25.585-25.6-25.6H409.6V25.6C409.585 11.468 398.132.015 384 0H128c-14.132.015-25.585 11.468-25.6 25.6v93.867H85.333c-14.132.015-25.585 11.468-25.6 25.6v244.538L1.796 464.096a8.39 8.39 0 00-.944 1.648c-.057.121-.144.217-.195.341a8.442 8.442 0 00-.592 2.928c-.005.112-.065.206-.065.32V486.4c.015 14.132 11.468 25.585 25.6 25.6h460.8c14.132-.015 25.585-11.468 25.6-25.6v-17.067c0-.114-.06-.208-.065-.32zM119.467 25.6A8.544 8.544 0 01128 17.067h256a8.544 8.544 0 018.533 8.533v324.267H119.467V25.6zM76.8 145.067a8.544 8.544 0 018.533-8.533H102.4v213.333h-8.533a8.533 8.533 0 000 17.066h324.267c4.713 0 8.533-3.82 8.533-8.533s-3.82-8.533-8.533-8.533H409.6V136.533h17.067a8.544 8.544 0 018.533 8.533V384H76.8V145.067zm-4.358 256h367.117l46.462 59.733H25.979l46.463-59.733zM494.933 486.4a8.544 8.544 0 01-8.533 8.533H25.6a8.544 8.544 0 01-8.533-8.533v-8.533h477.867v8.533z">
                                </path>
                                <path
                                    d="M392.533 426.667H119.467c-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533h273.067a8.533 8.533 0 10-.001-17.066zM85.333 426.667H76.8c-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533h8.533c4.713 0 8.533-3.82 8.533-8.533s-3.82-8.533-8.533-8.533zM435.2 426.667h-8.533c-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533h8.533c4.713 0 8.533-3.82 8.533-8.533s-3.82-8.533-8.533-8.533zM290.133 179.2c0 4.713 3.82 8.533 8.533 8.533s8.533-3.82 8.533-8.533c0-21.097-18.491-38.622-42.667-42.024V128c0-4.713-3.82-8.533-8.533-8.533s-8.533 3.82-8.533 8.533v9.176c-24.176 3.402-42.667 20.927-42.667 42.024s18.491 38.622 42.667 42.024v50.933c-14.68-2.862-25.6-12.797-25.6-24.691a8.533 8.533 0 00-17.066 0c0 21.097 18.491 38.622 42.667 42.024v9.176c0 4.713 3.82 8.533 8.533 8.533s8.533-3.82 8.533-8.533v-9.176c24.176-3.402 42.667-20.927 42.667-42.024s-18.491-38.622-42.667-42.024v-50.933c14.68 2.862 25.6 12.797 25.6 24.691zm-42.666 24.691c-14.68-2.862-25.6-12.798-25.6-24.691 0-11.894 10.92-21.829 25.6-24.691v49.382zm42.666 43.576c0 11.894-10.92 21.829-25.6 24.691v-49.382c14.68 2.861 25.6 12.797 25.6 24.691zM170.667 34.133h-25.6c-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533h25.6c4.713 0 8.533-3.82 8.533-8.533s-3.82-8.533-8.533-8.533zM153.6 68.267h-8.533c-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533h8.533c4.713 0 8.533-3.82 8.533-8.533s-3.82-8.533-8.533-8.533zM264.533 76.8A8.533 8.533 0 00256 68.267h-68.267c-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533H256a8.533 8.533 0 008.533-8.533zM204.8 51.2h25.6c4.713 0 8.533-3.82 8.533-8.533s-3.82-8.533-8.533-8.533h-25.6c-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533z">
                                </path>
                            </svg></span>
                        <h3>
                            <?php echo e(aiTrans('Prisen [website_title]', $locale, ['website_title' => $website_title])); ?>

                        </h3>
                        <p>
                            <?php echo e(aiTrans(
                                'Prisen for at bruge [website_title] er nul! Det koster absolut ingenting. Det koster ikke
                                noget at
                                registrere sig, alle handelsaktiviteter er gratis at bruge, og vi ønsker, at du skal nyde, hvad
                                vi har at tilbyde for nul kroner! Derudover tager vi ingen provision.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border box-bt">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-cloud-arrow-down" fill="currentColor" height="16" width="16">
                                <path
                                    d="M7.646 10.854a.5.5 0 0 0 .708 0l2-2a.5.5 0 0 0-.708-.708L8.5 9.293V5.5a.5.5 0 0 0-1 0v3.793L6.354 8.146a.5.5 0 1 0-.708.708l2 2z"
                                    fill-rule="evenodd"></path>
                                <path
                                    d="M4.406 3.342A5.53 5.53 0 0 1 8 2c2.69 0 4.923 2 5.166 4.579C14.758 6.804 16 8.137 16 9.773 16 11.569 14.502 13 12.687 13H3.781C1.708 13 0 11.366 0 9.318c0-1.763 1.266-3.223 2.942-3.593.143-.863.698-1.723 1.464-2.383zm.653.757c-.757.653-1.153 1.44-1.153 2.056v.448l-.445.049C2.064 6.805 1 7.952 1 9.318 1 10.785 2.23 12 3.781 12h8.906C13.98 12 15 10.988 15 9.773c0-1.216-1.02-2.228-2.313-2.228h-.5v-.5C12.188 4.825 10.328 3 8 3a4.53 4.53 0 0 0-2.941 1.1z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Intet behov for at downloade')); ?></h3>
                        <p><?php echo e(aiTrans('Der er ingen grund til at downloade webversioner, fordi alt er internetbaseret, så det kan bruges
                            fra enhver browser, der er tilsluttet, og fra enhver enhed hvor som helst.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border box-bt box-br">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-cart-check" fill="currentColor" height="16" width="16">
                                <path
                                    d="M11.354 6.354a.5.5 0 0 0-.708-.708L8 8.293 6.854 7.146a.5.5 0 1 0-.708.708l1.5 1.5a.5.5 0 0 0 .708 0l3-3z">
                                </path>
                                <path
                                    d="M.5 1a.5.5 0 0 0 0 1h1.11l.401 1.607 1.498 7.985A.5.5 0 0 0 4 12h1a2 2 0 1 0 0 4 2 2 0 0 0 0-4h7a2 2 0 1 0 0 4 2 2 0 0 0 0-4h1a.5.5 0 0 0 .491-.408l1.5-8A.5.5 0 0 0 14.5 3H2.89l-.405-1.621A.5.5 0 0 0 2 1H.5zm3.915 10L3.102 4h10.796l-1.313 7h-8.17zM6 14a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm7 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('No Hassle Trading-appen!')); ?></h3>
                        <p><?php echo e(aiTrans('Vi tror på uden besvær, så det er hurtigt og nemt at registrere din konto med vores app. Når du
                            er færdig, forbinder vi dig med en af ​​vores betroede, pålidelige og troværdige mæglere, og du
                            kan straks begynde at handle og høste fordelene af alle de muligheder, du får.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-person-check" fill="currentColor" height="16" width="16">
                                <path
                                    d="M12.5 16a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7Zm1.679-4.493-1.335 2.226a.75.75 0 0 1-1.174.144l-.774-.773a.5.5 0 0 1 .708-.708l.547.548 1.17-1.951a.5.5 0 1 1 .858.514ZM11 5a3 3 0 1 1-6 0 3 3 0 0 1 6 0ZM8 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z">
                                </path>
                                <path
                                    d="M8.256 14a4.474 4.474 0 0 1-.229-1.004H3c.001-.246.154-.986.832-1.664C4.484 10.68 5.711 10 8 10c.26 0 .507.009.74.025.226-.341.496-.65.804-.918C9.077 9.038 8.564 9 8 9c-5 0-6 3-6 4s1 1 1 1h5.256Z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Superhurtig verifikation')); ?></h3>
                        <p><?php echo e(aiTrans('Når du har oprettet din konto, behøver du ikke vente dage på bekræftelse, vi gør det næsten
                            øjeblikkeligt, så du hurtigt kommer i kontakt med den rigtige mæglerpartner for dig, og du
                            kommer i gang med din første handel.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-tv" fill="currentColor" height="16" width="16">
                                <path
                                    d="M2.5 13.5A.5.5 0 0 1 3 13h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zM13.991 3l.024.001a1.46 1.46 0 0 1 .538.143.757.757 0 0 1 .302.254c.067.1.145.277.145.602v5.991l-.001.024a1.464 1.464 0 0 1-.143.538.758.758 0 0 1-.254.302c-.1.067-.277.145-.602.145H2.009l-.024-.001a1.464 1.464 0 0 1-.538-.143.758.758 0 0 1-.302-.254C1.078 10.502 1 10.325 1 10V4.009l.001-.024a1.46 1.46 0 0 1 .143-.538.758.758 0 0 1 .254-.302C1.498 3.078 1.675 3 2 3h11.991zM14 2H2C0 2 0 4 0 4v6c0 2 2 2 2 2h12c2 0 2-2 2-2V4c0-2-2-2-2-2z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('En brugervenlig grænseflade, der ser godt ud!')); ?></h3>
                        <p><?php echo e(aiTrans('Vi er så stolte af vores smarte interface, det er også nemt at navigere. Det er designet med dig
                            i tankerne, uanset om du er en nybegynder eller en meget erfaren erhvervsdrivende. Det er så
                            nemt at bruge med masser af geniale handelsfunktioner, værktøjer og instrumenter. Vi har fået så
                            mange komplimenter, vi er sikre på, at du også vil elske det.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border box-br">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-graph-down-arrow" fill="currentColor" height="16" width="16">
                                <path
                                    d="M0 0h1v15h15v1H0V0Zm10 11.5a.5.5 0 0 0 .5.5h4a.5.5 0 0 0 .5-.5v-4a.5.5 0 0 0-1 0v2.6l-3.613-4.417a.5.5 0 0 0-.74-.037L7.06 8.233 3.404 3.206a.5.5 0 0 0-.808.588l4 5.5a.5.5 0 0 0 .758.06l2.609-2.61L13.445 11H10.5a.5.5 0 0 0-.5.5Z"
                                    fill-rule="evenodd"></path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Kom i gang med et lavt indskud')); ?></h3>
                        <p><?php echo e(aiTrans('Du behøver kun at starte med et minimumsindskud på EURO250, selvfølgelig kan du starte med mere,
                            og det er helt i orden. Det er op til dig, hvad end du indbetaler, bruges til din handel, og der
                            er ingen app-gebyrer overhovedet. Dine penge er dine egne.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                <path
                                    d="M440.76 0H71.24c-20.678 0-37.5 16.822-37.5 37.5v134.15c0 4.143 3.357 7.5 7.5 7.5s7.5-3.357 7.5-7.5V85.5h414.52v288.97c0 12.406-10.094 22.5-22.5 22.5h-54.662v-45.291c0-12.968-10.55-23.519-23.518-23.519h-54.59v-14.031c0-11.914-9.693-21.607-21.607-21.607h-60.766c-11.914 0-21.607 9.693-21.607 21.607v14.031h-10.6c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h169.17c4.696 0 8.518 3.821 8.518 8.519v18.611a24.476 24.476 0 01-12.351 21.233l-15.39 8.77a74 74 0 01-36.567 9.688h-27.985v-2.114c0-12.574-10.23-22.805-22.805-22.805s-22.805 10.23-22.805 22.805v2.114H216.69a73.992 73.992 0 01-36.567-9.688l-26.873-15.312a24.477 24.477 0 01-12.348-21.231v-12.071c0-4.697 3.821-8.519 8.518-8.519h13.99c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-13.99c-12.968 0-23.518 10.551-23.518 23.519v45.291H71.24c-12.406 0-22.5-10.094-22.5-22.5V201.65c0-4.143-3.357-7.5-7.5-7.5s-7.5 3.357-7.5 7.5v172.82c0 20.678 16.822 37.5 37.5 37.5h54.662v76.514c0 12.967 10.55 23.517 23.518 23.517h213.16c12.968 0 23.518-10.55 23.518-23.517V411.97h54.662c20.678 0 37.5-16.822 37.5-37.5V37.5c0-20.678-16.822-37.5-37.5-37.5zM219.01 314.129a6.614 6.614 0 016.607-6.607h60.766a6.614 6.614 0 016.607 6.607v14.031h-73.98zM256 400.062c4.304 0 7.805 3.501 7.805 7.805v9.518c0 .032-.005.064-.005.097s.004.064.005.097v15.565c0 4.304-3.501 7.805-7.805 7.805s-7.805-3.501-7.805-7.805v-15.565c0-.032.005-.064.005-.097s-.004-.064-.005-.097v-9.518c0-4.304 3.501-7.805 7.805-7.805zM362.58 497H149.42c-4.696 0-8.518-3.82-8.518-8.517v-93.808a39.145 39.145 0 004.925 3.341l26.87 15.31a89.029 89.029 0 0043.993 11.654h16.505v8.162c0 12.574 10.23 22.805 22.805 22.805s22.805-10.23 22.805-22.805v-8.162h27.985a89.037 89.037 0 0043.993-11.654l15.387-8.768a39.165 39.165 0 004.928-3.344v87.268c0 4.698-3.822 8.518-8.518 8.518zM48.74 70.5v-33c0-12.406 10.094-22.5 22.5-22.5h369.52c12.406 0 22.5 10.094 22.5 22.5v33z">
                                </path>
                                <path
                                    d="M95.856 22.639c-11.09 0-20.111 9.021-20.111 20.111s9.021 20.111 20.111 20.111 20.111-9.021 20.111-20.111-9.021-20.111-20.111-20.111zm0 25.222c-2.818 0-5.111-2.293-5.111-5.111s2.293-5.111 5.111-5.111 5.111 2.293 5.111 5.111-2.292 5.111-5.111 5.111zM148.745 22.639c-11.09 0-20.112 9.021-20.112 20.111s9.022 20.111 20.112 20.111 20.111-9.021 20.111-20.111-9.021-20.111-20.111-20.111zm0 25.222c-2.819 0-5.112-2.293-5.112-5.111s2.293-5.111 5.112-5.111c2.818 0 5.111 2.293 5.111 5.111s-2.293 5.111-5.111 5.111zM201.633 22.639c-11.09 0-20.111 9.021-20.111 20.111s9.021 20.111 20.111 20.111 20.112-9.021 20.112-20.111-9.022-20.111-20.112-20.111zm0 25.222c-2.818 0-5.111-2.293-5.111-5.111s2.293-5.111 5.111-5.111c2.819 0 5.112 2.293 5.112 5.111s-2.293 5.111-5.112 5.111zM169.127 159.845H75.641a7.499 7.499 0 00-7.5 7.5v93.486c0 .07.009.137.01.206.115 4.002 3.337 7.243 7.401 7.29.03 0 .059.004.088.004h93.478l.015.001c.035 0 .07-.006.105-.007a7.483 7.483 0 007.378-7.284c.002-.07.011-.139.011-.21v-.123-93.363c0-4.143-3.357-7.5-7.5-7.5zm-7.5 15V232.3l-13.188-23.351c-2.66-4.71-7.673-7.637-13.082-7.637s-10.422 2.927-13.081 7.636l-9.619 17.032c-2.756-4.464-7.496-7.115-12.772-7.115h-.002c-5.431 0-10.295 2.808-13.011 7.512l-3.731 6.463v-57.995zm-5.349 78.486H88.646l11.258-19.454 6.334 10.971a7.467 7.467 0 006.53 3.75 7.502 7.502 0 006.495-3.812l16.115-28.461zM302.743 159.845h-93.486a7.499 7.499 0 00-7.5 7.5v93.486c0 .07.009.137.01.206.115 4.006 3.342 7.243 7.401 7.29.03 0 .059.004.088.004h93.478l.015.001c4.119 0 7.493-3.391 7.493-7.501v-.123V167.344a7.497 7.497 0 00-7.499-7.499zm-7.5 15V232.3l-13.188-23.351a15.048 15.048 0 00-13.083-7.636 15.047 15.047 0 00-13.08 7.636l-9.619 17.031c-2.756-4.464-7.497-7.114-12.774-7.114-5.431 0-10.294 2.808-13.011 7.512l-3.731 6.463v-57.995h78.486zm-5.349 78.486h-67.632l11.258-19.454 6.333 10.971a7.475 7.475 0 006.53 3.75 7.502 7.502 0 006.495-3.812l16.116-28.461zM436.359 159.845h-93.486a7.499 7.499 0 00-7.5 7.5v93.486c0 .07.009.137.01.206a7.488 7.488 0 007.401 7.29c.03 0 .059.004.089.004h93.478l.015.001c.035 0 .07-.006.105-.007 4.085-.059 7.388-3.401 7.388-7.494v-.123V167.344a7.499 7.499 0 00-7.5-7.499zm-7.5 15V232.3l-13.188-23.351a15.047 15.047 0 00-13.082-7.636 15.047 15.047 0 00-13.081 7.636l-9.619 17.032c-2.756-4.465-7.498-7.115-12.775-7.115-5.431 0-10.294 2.809-13.009 7.512l-3.732 6.465v-57.997h78.486zm-5.349 78.486h-67.632l11.258-19.454 6.334 10.971a7.5 7.5 0 006.495 3.75h.036a7.5 7.5 0 006.494-3.812l16.115-28.461zM325.875 130c0-4.143-3.357-7.5-7.5-7.5h-124.75c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h124.75c4.143 0 7.5-3.357 7.5-7.5z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Handel med et stort udvalg af aktiver')); ?></h3>
                        <p>
                            <?php echo e(aiTrans(
                                '[website_title] -appen giver dig mulighed for at handle med så mange forskellige aktiver,
                                uanset
                                om du ønsker at handle med FIAT, aktier, råvarer, ædle metaller, Crypto (Bitcoin, Ethereum,
                                Ripple, Dash, Dogecoin og andre). Der er bare så mange muligheder for dig!',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-chat-square-quote-fill" fill="currentColor" height="16" width="16">
                                <path
                                    d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-2.5a1 1 0 0 0-.8.4l-1.9 2.533a1 1 0 0 1-1.6 0L5.3 12.4a1 1 0 0 0-.8-.4H2a2 2 0 0 1-2-2V2zm7.194 2.766a1.688 1.688 0 0 0-.227-.272 1.467 1.467 0 0 0-.469-.324l-.008-.004A1.785 1.785 0 0 0 5.734 4C4.776 4 4 4.746 4 5.667c0 .92.776 1.666 1.734 1.666.343 0 .662-.095.931-.26-.137.389-.39.804-.81 1.22a.405.405 0 0 0 .011.59c.173.16.447.155.614-.01 1.334-1.329 1.37-2.758.941-3.706a2.461 2.461 0 0 0-.227-.4zM11 7.073c-.136.389-.39.804-.81 1.22a.405.405 0 0 0 .012.59c.172.16.446.155.613-.01 1.334-1.329 1.37-2.758.942-3.706a2.466 2.466 0 0 0-.228-.4 1.686 1.686 0 0 0-.227-.273 1.466 1.466 0 0 0-.469-.324l-.008-.004A1.785 1.785 0 0 0 10.07 4c-.957 0-1.734.746-1.734 1.667 0 .92.777 1.666 1.734 1.666.343 0 .662-.095.931-.26z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Et fællesskab af ligesindede handlende')); ?></h3>
                        <p><?php echo e(aiTrans('Vi er mere end blot en handelsapp. Vi er et fællesskab af ligesindede og giver dig adgang til
                            folk ligesom dig, snak om handel, stil spørgsmål eller brainstorm, der er så meget du kan gøre
                            på vores app!')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border box-br">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-puzzle-fill" fill="currentColor" height="16" width="16">
                                <path
                                    d="M3.112 3.645A1.5 1.5 0 0 1 4.605 2H7a.5.5 0 0 1 .5.5v.382c0 .696-.497 1.182-.872 1.469a.459.459 0 0 0-.115.118.113.113 0 0 0-.012.025L6.5 4.5v.003l.003.01c.004.01.014.028.036.053a.86.86 0 0 0 .27.194C7.09 4.9 7.51 5 8 5c.492 0 .912-.1 1.19-.24a.86.86 0 0 0 .271-.194.213.213 0 0 0 .036-.054l.003-.01v-.008a.112.112 0 0 0-.012-.025.459.459 0 0 0-.115-.118c-.375-.287-.872-.773-.872-1.469V2.5A.5.5 0 0 1 9 2h2.395a1.5 1.5 0 0 1 1.493 1.645L12.645 6.5h.237c.195 0 .42-.147.675-.48.21-.274.528-.52.943-.52.568 0 .947.447 1.154.862C15.877 6.807 16 7.387 16 8s-.123 1.193-.346 1.638c-.207.415-.586.862-1.154.862-.415 0-.733-.246-.943-.52-.255-.333-.48-.48-.675-.48h-.237l.243 2.855A1.5 1.5 0 0 1 11.395 14H9a.5.5 0 0 1-.5-.5v-.382c0-.696.497-1.182.872-1.469a.459.459 0 0 0 .115-.118.113.113 0 0 0 .012-.025L9.5 11.5v-.003l-.003-.01a.214.214 0 0 0-.036-.053.859.859 0 0 0-.27-.194C8.91 11.1 8.49 11 8 11c-.491 0-.912.1-1.19.24a.859.859 0 0 0-.271.194.214.214 0 0 0-.036.054l-.003.01v.002l.001.006a.113.113 0 0 0 .012.025c.016.027.05.068.115.118.375.287.872.773.872 1.469v.382a.5.5 0 0 1-.5.5H4.605a1.5 1.5 0 0 1-1.493-1.645L3.356 9.5h-.238c-.195 0-.42.147-.675.48-.21.274-.528.52-.943.52-.568 0-.947-.447-1.154-.862C.123 9.193 0 8.613 0 8s.123-1.193.346-1.638C.553 5.947.932 5.5 1.5 5.5c.415 0 .733.246.943.52.255.333.48.48.675.48h.238l-.244-2.855z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Vi ser altid på fremtiden')); ?></h3>
                        <p><?php echo e(aiTrans('Ligesom handelsverdenen står vi aldrig stille, og vi ser altid på fremtiden, undersøger moderne
                            teknologier og kunstig intelligens sammen med kontrol af de finansielle markeder. Vi gør dette
                            for dig, så du altid er informeret.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-exclamation-triangle" fill="currentColor" height="16" width="16">
                                <path
                                    d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.146.146 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.163.163 0 0 1-.054.06.116.116 0 0 1-.066.017H1.146a.115.115 0 0 1-.066-.017.163.163 0 0 1-.054-.06.176.176 0 0 1 .002-.183L7.884 2.073a.147.147 0 0 1 .054-.057zm1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566z">
                                </path>
                                <path
                                    d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0zM7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Du sætter dit risikoniveau')); ?></h3>
                        <p><?php echo e(aiTrans('Mens vores app er skabt specielt til at finde handelsmuligheder for dig, indstiller du din
                            risiko, der kan tilpasses til dine krav – så du forbliver fast i kontrol over dine penge.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-fingerprint" fill="currentColor" height="16" width="16">
                                <path
                                    d="M8.06 6.5a.5.5 0 0 1 .5.5v.776a11.5 11.5 0 0 1-.552 3.519l-1.331 4.14a.5.5 0 0 1-.952-.305l1.33-4.141a10.5 10.5 0 0 0 .504-3.213V7a.5.5 0 0 1 .5-.5Z">
                                </path>
                                <path
                                    d="M6.06 7a2 2 0 1 1 4 0 .5.5 0 1 1-1 0 1 1 0 1 0-2 0v.332c0 .409-.022.816-.066 1.221A.5.5 0 0 1 6 8.447c.04-.37.06-.742.06-1.115V7Zm3.509 1a.5.5 0 0 1 .487.513 11.5 11.5 0 0 1-.587 3.339l-1.266 3.8a.5.5 0 0 1-.949-.317l1.267-3.8a10.5 10.5 0 0 0 .535-3.048A.5.5 0 0 1 9.569 8Zm-3.356 2.115a.5.5 0 0 1 .33.626L5.24 14.939a.5.5 0 1 1-.955-.296l1.303-4.199a.5.5 0 0 1 .625-.329Z">
                                </path>
                                <path
                                    d="M4.759 5.833A3.501 3.501 0 0 1 11.559 7a.5.5 0 0 1-1 0 2.5 2.5 0 0 0-4.857-.833.5.5 0 1 1-.943-.334Zm.3 1.67a.5.5 0 0 1 .449.546 10.72 10.72 0 0 1-.4 2.031l-1.222 4.072a.5.5 0 1 1-.958-.287L4.15 9.793a9.72 9.72 0 0 0 .363-1.842.5.5 0 0 1 .546-.449Zm6 .647a.5.5 0 0 1 .5.5c0 1.28-.213 2.552-.632 3.762l-1.09 3.145a.5.5 0 0 1-.944-.327l1.089-3.145c.382-1.105.578-2.266.578-3.435a.5.5 0 0 1 .5-.5Z">
                                </path>
                                <path
                                    d="M3.902 4.222a4.996 4.996 0 0 1 5.202-2.113.5.5 0 0 1-.208.979 3.996 3.996 0 0 0-4.163 1.69.5.5 0 0 1-.831-.556Zm6.72-.955a.5.5 0 0 1 .705-.052A4.99 4.99 0 0 1 13.059 7v1.5a.5.5 0 1 1-1 0V7a3.99 3.99 0 0 0-1.386-3.028.5.5 0 0 1-.051-.705ZM3.68 5.842a.5.5 0 0 1 .422.568c-.029.192-.044.39-.044.59 0 .71-.1 1.417-.298 2.1l-1.14 3.923a.5.5 0 1 1-.96-.279L2.8 8.821A6.531 6.531 0 0 0 3.058 7c0-.25.019-.496.054-.736a.5.5 0 0 1 .568-.422Zm8.882 3.66a.5.5 0 0 1 .456.54c-.084 1-.298 1.986-.64 2.934l-.744 2.068a.5.5 0 0 1-.941-.338l.745-2.07a10.51 10.51 0 0 0 .584-2.678.5.5 0 0 1 .54-.456Z">
                                </path>
                                <path
                                    d="M4.81 1.37A6.5 6.5 0 0 1 14.56 7a.5.5 0 1 1-1 0 5.5 5.5 0 0 0-8.25-4.765.5.5 0 0 1-.5-.865Zm-.89 1.257a.5.5 0 0 1 .04.706A5.478 5.478 0 0 0 2.56 7a.5.5 0 0 1-1 0c0-1.664.626-3.184 1.655-4.333a.5.5 0 0 1 .706-.04ZM1.915 8.02a.5.5 0 0 1 .346.616l-.779 2.767a.5.5 0 1 1-.962-.27l.778-2.767a.5.5 0 0 1 .617-.346Zm12.15.481a.5.5 0 0 1 .49.51c-.03 1.499-.161 3.025-.727 4.533l-.07.187a.5.5 0 0 1-.936-.351l.07-.187c.506-1.35.634-2.74.663-4.202a.5.5 0 0 1 .51-.49Z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Sikker med sikker ind- og udbetaling')); ?></h3>
                        <p>
                            <?php echo e(aiTrans(
                                'Alle dine oplysninger er sikkert krypteret, så når du finansierer eller hæver penge fra
                                [website_title] , er du altid fuldstændig sikker. Brug et kreditkort, betalingskort,
                                overførsel,
                                bankoverførsel eller elektronisk tegnebog til at indbetale penge på din konto. Enhver
                                fortjeneste eller udbetaling betales tilbage til din oprindelige betalingsmetode.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border box-br">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-shield-fill-check" fill="currentColor" height="16" width="16">
                                <path
                                    d="M8 0c-.69 0-1.843.265-2.928.56-1.11.3-2.229.655-2.887.87a1.54 1.54 0 0 0-1.044 1.262c-.596 4.477.787 7.795 2.465 9.99a11.777 11.777 0 0 0 2.517 2.453c.386.273.744.482 1.048.625.28.132.581.24.829.24s.548-.108.829-.24a7.159 7.159 0 0 0 1.048-.625 11.775 11.775 0 0 0 2.517-2.453c1.678-2.195 3.061-5.513 2.465-9.99a1.541 1.541 0 0 0-1.044-1.263 62.467 62.467 0 0 0-2.887-.87C9.843.266 8.69 0 8 0zm2.146 5.146a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647z"
                                    fill-rule="evenodd"></path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Din sikkerhed er vores højeste prioritet')); ?></h3>
                        <p><?php echo e(aiTrans('Vores app og hjemmeside er både fuldstændig sikre og sikre, dine personlige oplysninger er altid
                            beskyttet, ligesom din handel er det. Din sikkerhed er vores højeste prioritet.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-person-badge" fill="currentColor" height="16" width="16">
                                <path d="M6.5 2a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3zM11 8a3 3 0 1 1-6 0 3 3 0 0 1 6 0z">
                                </path>
                                <path
                                    d="M4.5 0A2.5 2.5 0 0 0 2 2.5V14a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V2.5A2.5 2.5 0 0 0 11.5 0h-7zM3 2.5A1.5 1.5 0 0 1 4.5 1h7A1.5 1.5 0 0 1 13 2.5v10.795a4.2 4.2 0 0 0-.776-.492C11.392 12.387 10.063 12 8 12s-3.392.387-4.224.803a4.2 4.2 0 0 0-.776.492V2.5z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Demo konti')); ?></h3>
                        <p><?php echo e(aiTrans('Vi giver alle vores brugere chancen for at prøve deres handelsrejse ved hjælp af en demokonto, så
                            du kan øve dig uden at miste penge. Så snart du opbygger din selvtillid og føler dig klar, kan
                            du begynde at handle for alvor! Vi har endda en back-test-funktion, så du kan prøve dine
                            handelsfærdigheder på gamle markedsforhold.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-file-earmark-bar-graph-fill" fill="currentColor" height="16"
                                width="16">
                                <path
                                    d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zm.5 10v-6a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5zm-2.5.5a.5.5 0 0 1-.5-.5v-4a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v4a.5.5 0 0 1-.5.5h-1zm-3 0a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-.5.5h-1z">
                                </path>
                            </svg></span>
                        <h3>
                            <?php echo e(aiTrans('Tilpas din [website_title]', $locale, ['website_title' => $website_title])); ?>

                        </h3>
                        <p><?php echo e(aiTrans('Du kan personliggøre din konto med vores fleksible tilpasning. Vi har masser af handelstilstande
                            og variabler, som du kan skræddersy, så de passer til dine handelsbehov.')); ?>

                        </p>
                    </div>
                </div>

                <div>
                    <div class="box-border box-br">
                        <span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                class="bi bi-people-fill" fill="currentColor" height="16" width="16">
                                <path
                                    d="M7 14s-1 0-1-1 1-4 5-4 5 3 5 4-1 1-1 1H7Zm4-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6Zm-5.784 6A2.238 2.238 0 0 1 5 13c0-1.355.68-2.75 1.936-3.72A6.325 6.325 0 0 0 5 9c-4 0-5 3-5 4s1 1 1 1h4.216ZM4.5 8a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z">
                                </path>
                            </svg></span>
                        <h3><?php echo e(aiTrans('Dedikeret kundeservice')); ?></h3>
                        <p><?php echo e(aiTrans('Vi yder altid den bedst mulige kundesupport. Hvis du har en forespørgsel, uanset hvad, er vi der
                            for dig 24 timer i døgnet, 7 dage om ugen, 365 dage om året.')); ?>

                        </p>
                    </div>
                </div>


            </div>

            <div class="uk-text-center uk-margin-medium-top">
                <a class="cu-button" href="#"><strong>
                        <?php echo e(aiTrans('Konfigurer din [website_title] konto i dag', $locale, ['website_title' => $website_title])); ?>

                    </strong></a>
            </div>

        </div>

    </section>

    <section class="uk-section uk-section-muted sec-border2">

        <div class="uk-container">

            <h2 class="heading-br">
                <?php echo e(aiTrans('[website_title] Højdepunkter', $locale, ['website_title' => $website_title])); ?>

            </h2>

            <figure class="wp-block-table">
                <table>
                    <tbody>
                        <tr>
                            <td class="has-text-align-left" data-align="left"><?php echo e(aiTrans('💰 Platformomkostninger')); ?>

                            </td>
                            <td class="has-text-align-left" data-align="left"><?php echo e(aiTrans('Gratis.')); ?></td>
                        </tr>
                        <tr>
                            <td class="has-text-align-left" data-align="left"><?php echo e(aiTrans('🌎 Lande')); ?></td>
                            <td class="has-text-align-left" data-align="left">
                                <?php echo e(aiTrans('Alle, eksklusive USA og IL.')); ?></td>
                        </tr>
                        <tr>
                            <td class="has-text-align-left" data-align="left"><?php echo e(aiTrans('💳 Indbetalingsmuligheder')); ?>

                            </td>
                            <td class="has-text-align-left" data-align="left">
                                <?php echo e(aiTrans('VISA, Mastercard, PayPal, Skrill, mere.')); ?></td>
                        </tr>
                        <tr>
                            <td class="has-text-align-left" data-align="left"><?php echo e(aiTrans('🤖 Handelsaktiver')); ?></td>
                            <td class="has-text-align-left" data-align="left"><?php echo e(aiTrans('Krypto, aktier, råvarer.')); ?>

                            </td>
                        </tr>
                    </tbody>
                </table>
            </figure>

            <h2 class="heading-br">
                <?php echo e(aiTrans('Tilmeld dig [website_title] -fællesskabet her', $locale, ['website_title' => $website_title])); ?>

            </h2>

            <p>
                <?php echo e(aiTrans(
                    'Mens [website_title] er en handelsapp, der giver dig mulighed for at automatisere dine handler eller
                                        bruge den
                                        manuelle tilstand, er vi også en pædagogisk ressource. Vi holder os ajour med nyheder, information og trends
                                        omkring de finansielle markeder (især Crypto og andre aktiver) for dig, og det hele er samlet ét sted. Dette
                                        giver dig mulighed for at holde dig orienteret om, hvad der sker på tværs af de finansielle markeder, så du
                                        træffer informerede beslutninger og også får mest muligt ud af dine muligheder for at profitere!',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

            </p>

            <div>
                <strong>

                    <?php echo e(aiTrans(
                        'Tilmeld dig [website_title] -fællesskabet her, og lær mere om alle de finansielle markeder,
                                                markedernes
                                                historie, gamle handelsmønstre, nuværende handelsbetingelser og alt andet, der har med handel at
                                                gøre.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                </strong>
            </div>

            <a class="cu-button uk-margin-medium-top" href="#"><strong>
                    <?php echo e(aiTrans(
                        'Tilmeld dig [website_title]
                                        -fællesskabet nu',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                </strong></a>

        </div>

    </section>



    <section class="uk-section">

        <div class="uk-container">

            <div class="uk-flex-bottom" uk-grid>
                <div class="uk-width-expand@s">
                    <h2 class="heading-br">
                        <?php echo e(aiTrans('Tilmeld dig [website_title] -fællesskabet her', $locale, ['website_title' => $website_title])); ?>

                    </h2>
                    <p><?php echo e($website_title); ?></p>
                    <p>
                        <?php echo e(aiTrans(
                            '[website_title] er en banebrydende mobilapplikation designet til kryptohandelsentusiaster.
                                                Bygget med de nyeste
                                                teknologier og avancerede funktioner giver denne app en problemfri og sikker platform for brugere
                                                til at købe, sælge
                                                og udveksle kryptovalutaer. Med sin brugervenlige grænseflade og intuitive navigation giver
                                                [website_title] både
                                                begyndere og erfarne handlende mulighed for at engagere sig i den dynamiske verden af ​​digitale
                                                valutaer med
                                                tillid.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                    </p>
                </div>
                <div class="uk-width-2-5@s">
                    <img src="<?php echo e(asset('frontend/assets/da/dist')); ?>/images/screens-2.png" alt="">
                </div>
            </div>

            <p>
                <strong><?php echo e(aiTrans('Pris:')); ?> </strong>
                <?php echo e(aiTrans('250')); ?>

            </p>
            <p>
                <strong><?php echo e(aiTrans('Pris Valuta:')); ?> </strong>
                <?php echo e(aiTrans('USD')); ?>

            </p>
            <p>
                <strong><?php echo e(aiTrans('Operativ system:')); ?> </strong>
                <?php echo e(aiTrans('Windows 10, Windows 7, Windows 8, OSX, macOS, iOS, Android 7.1.2, Android 8.1, Android 9.0, Android 10.0,
                                Android 11.0, Android 12.0, Android 13.0')); ?>

            </p>

            <p>
                <strong><?php echo e(aiTrans('Ansøgningskategori:')); ?> </strong>
                <?php echo e(aiTrans('FinanceApplication')); ?>

            </p>

            <div class="rank-math-total-wrapper"><strong><?php echo e(aiTrans('Redaktørens vurdering:')); ?></strong><br><span
                    class="rank-math-total">4.97</span>
                <div class="rank-math-review-star">
                    <div class="rank-math-review-result-wrapper">
                        <img src="<?php echo e(asset('frontend/assets/da/dist')); ?>/images/stars.jpg" alt="">
                    </div>
                </div>
            </div>

            <div class="rank-math-review-notes rank-math-review-pros">
                <h4><?php echo e(aiTrans('Fordele')); ?></h4>
                <ul>
                    <li><?php echo e(aiTrans('Brugervenlig grænseflade: Designet til alle niveauer af handlende, fra begyndere til avancerede, med en enkel og navigerbar grænseflade.')); ?>

                    </li>
                    <li><?php echo e(aiTrans('Ingen download påkrævet: Fuldstændig webbaseret, tilgængelig fra enhver browser og enhed.')); ?>

                    </li>
                    <li><?php echo e(aiTrans('Automatiseret og manuel handel: Tilbyder både fuldautomatisk handel og manuelle handelsmuligheder.')); ?>

                    </li>
                    <li><?php echo e(aiTrans('Premium AI-algoritmer: Bruger sofistikerede AI-algoritmer til markedsanalyse og handelsadvarsler i realtid.')); ?>

                    </li>
                    <li><?php echo e(aiTrans("Vifte af aktiver: Tillader handel med en bred vifte af aktiver, herunder kryptovalutaer, aktier, forex, CFD'er og råvarer.")); ?>

                    </li>
                    <li><?php echo e(aiTrans('Hurtig verifikation: Næsten øjeblikkelig kontobekræftelse og forbindelse med mæglere.')); ?>

                    </li>
                    <li><?php echo e(aiTrans('Lavt indledende indskud: Minimumskravet til indbetaling er kun €250.')); ?></li>
                </ul>
            </div>

            <div class="rank-math-review-notes rank-math-review-cons">
                <h4><?php echo e(aiTrans('Ulemper')); ?></h4>
                <ul>
                    <li><?php echo e(aiTrans('Random Broker Assignment: Mæglere tildeles tilfældigt baseret på aftaler, som måske ikke altid opfylder brugernes præferencer eller standarder.')); ?>

                    </li>
                    <li><?php echo e(aiTrans('Afhængighed af AI: Stor afhængighed af AI og algoritmer, som måske ikke altid forudsiger markedsbevægelser nøjagtigt.')); ?>

                    </li>
                    <li><?php echo e(aiTrans('Tekniske problemer: Som med enhver teknologi er der potentiale for tekniske fejl eller nedetid.')); ?>

                    </li>
                </ul>
            </div>

        </div>

    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oldfcfc/public_html/immediate-fc-old.com/resources/views/frontend/da/home.blade.php ENDPATH**/ ?>