<link rel="canonical" href="{{url()->current()}}">
@php
    // Supported languages list
    $languages = ['en', 'es', 'de', 'fr', 'pl', 'nl', 'it', 'sv', 'no', 'ja', 'pt', 'ar', 'hr', 'hu', 'tr', 'is', 'da', 'cs', 'el', 'id', 'ko', 'fil', 'ro', 'ru', 'sk', 'fi', 'zh'];

    // Get current path segments
    $segments = request()->segments();

    // Remove current language if present
    if (in_array($segments[0] ?? '', $languages)) {
        array_shift($segments); // Remove the first segment (language code)
    }

    // Rebuild the path
    $currentPath = implode('/', $segments);
@endphp

{{-- hreflang links for all languages --}}
@foreach ($languages as $lang)
    @if ($lang === 'en')
        {{-- English version without language code --}}
        <link rel="alternate" hreflang="en" href="{{ url($currentPath) }}">
    @else
        {{-- Other languages with their codes --}}
        <link rel="alternate" hreflang="{{ $lang }}" href="{{ url($lang . ($currentPath ? '/' . $currentPath : '')) }}">
    @endif
@endforeach
{{-- Add x-default pointing to the English version --}}
        <link rel="alternate" hreflang="x-default" href="{{ url($currentPath) }}">

      <link rel="icon" type="image/x-icon"
          href="{{ asset('frontend/assets/ar/dist') }}/images/32_32_661f93aa65070_immediate-core-logo.png" />
          
      <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
      <link rel="preload" as="style"
          href="https://fonts.googleapis.com/css?family=Poppins:300,400,600,700,800&display=swap" />
      <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,600,700,800&display=swap"
          media="print" onload="this.media = 'all';" />
      <link rel="module" href="{{ asset('frontend/assets/ar/dist') }}/js/app-6256b172.js" />
      <link rel="stylesheet" href="{{ asset('frontend/assets/ar/dist') }}/css/index-29961c6d.css"
          data-navigate-track="reload" />
      <link rel="stylesheet" href="{{ asset('frontend/assets/ar/dist') }}/css/style.css"
          data-navigate-track="reload" />
      <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@24.5.0/build/css/intlTelInput.css">
      <link href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.4.6/css/flag-icon.min.css" rel="stylesheet"
          media="print" onload="this.media='all'">
