
<link rel="canonical" href="{{url()->current()}}">
@php
    // Supported languages list
    $languages = ['en', 'es', 'de', 'fr', 'pl', 'nl', 'it', 'sv', 'no', 'ja', 'pt', 'ar', 'hr', 'hu', 'tr', 'is', 'da', 'cs', 'el', 'id', 'ko', 'fil', 'ro', 'ru', 'sk', 'fi', 'zh'];

    // Get current path segments
    $segments = request()->segments();

    // Remove current language if present
    if (in_array($segments[0] ?? '', $languages)) {
        array_shift($segments); // Remove the first segment (language code)
    }

    // Rebuild the path
    $currentPath = implode('/', $segments);
@endphp

{{-- hreflang links for all languages --}}
@foreach ($languages as $lang)
    @if ($lang === 'en')
        {{-- English version without language code --}}
        <link rel="alternate" hreflang="en" href="{{ url($currentPath) }}">
    @else
        {{-- Other languages with their codes --}}
        <link rel="alternate" hreflang="{{ $lang }}" href="{{ url($lang . ($currentPath ? '/' . $currentPath : '')) }}">
    @endif
@endforeach
{{-- Add x-default pointing to the English version --}}
        <link rel="alternate" hreflang="x-default" href="{{ url($currentPath) }}">
        

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link rel="icon" type="image/png" sizes="32x32" href="{{ asset('frontend/assets/sv/dist') }}/images/favicon-48x48.png">
<link href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.4.6/css/flag-icon.min.css" rel="stylesheet"
    media="print" onload="this.media='all'">

<link rel="stylesheet" href="{{ asset('frontend/assets/sv/dist') }}/css/style.css">
<link rel="stylesheet" href="{{ asset('frontend/assets/sv/dist') }}/css/main.css">
