@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Stránka zásad ochrany osobních údajů" }}</title>
    <meta name="description" content="{{ "Jak $website_title zabezpečuje ochranu vašich dat: detailní prozkoumání pravidel ochrany soukromí a tipy pro zajišťení bezpečnosti a transparentnosti." }}" />
@endpush
@section('content')
<div class="container page-inner pt-5">
    <h1>Zásady ochrany osobních údajů</h1>
    <main>
        <p><span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('(“nás”, “my” nebo “naše”) provozuje')}} <span class="u">{{$website_title}}</span> {{aitrans('webové stránky (dále jen “Služba”).')}}</p>
        <p>{{aitrans('Tato stránka vás informuje o našich zásadách týkajících se shromažďování, používání a zveřejňování osobních údajů, když používáte naši Službu, a možnostech, které máte v souvislosti s těmito údaji.')}}</p>
        <p>{{aitrans('My,')}} <a href="{{ route('home', $country) }}">{{$website_title}}</a>{{aitrans(', používáme vaše údaje k poskytování a zlepšování Služby. Používáním Služby souhlasíte se shromažďováním a používáním informací v souladu s touto politikou. Pokud není v těchto Zásadách ochrany osobních údajů stanoveno jinak, mají pojmy použité v těchto Zásadách ochrany osobních údajů stejné významy jako v našich Podmínkách a ustanoveních, které jsou k dispozici na')}} <span class="u">{{$website_title}}</span></p>
        <div id="toc_container" class="no_bullets">
            <ul class="toc_list">
                <ul>
                    <li>
                        <ul>
                            <li><a href="#Definitions"><span class="toc_number toc_depth_3">0.0.1</span> {{aitrans('Definice')}}</a>
                                <ul>
                                    <li><a href="#Service"><span class="toc_number toc_depth_4">0.0.1.1</span> {{aitrans('Služba')}}</a></li>
                                </ul>
                            </li>
                            <li><a href="#Personal_Data"><span class="toc_number toc_depth_3">0.0.2</span> {{aitrans('Osobní údaje')}}</a></li>
                            <li><a href="#Usage_Data"><span class="toc_number toc_depth_3">0.0.3</span> {{aitrans('Údaje o používání')}}</a></li>
                            <li><a href="#Cookies"><span class="toc_number toc_depth_3">0.0.4</span> {{aitrans('Cookies')}}</a></li>
                            <li><a href="#Data_Controller"><span class="toc_number toc_depth_3">0.0.5</span> {{aitrans('Správce údajů')}}</a></li>
                            <li><a href="#Data_Processors_or_Service_Providers"><span class="toc_number toc_depth_3">0.0.6</span> {{aitrans('Zpracovatelé údajů (nebo poskytovatelé služeb)')}}</a></li>
                            <li><a href="#Data_Subject_or_User"><span class="toc_number toc_depth_3">0.0.7</span> {{aitrans('Subjekt údajů (nebo uživatel)')}}</a></li>
                        </ul>
                    </li>
                </ul>
                <li><a href="#Information_Collection_And_Use"><span class="toc_number toc_depth_1">1</span> {{aitrans('Shromažďování a použití informací')}}</a>
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Types_of_Data_Collected"><span class="toc_number toc_depth_3">1.0.1</span> {{aitrans('Typy shromážděných údajů')}}</a></li>
                                <li><a href="#Personal_Data-2"><span class="toc_number toc_depth_3">1.0.2</span> {{aitrans('Osobní údaje')}}</a></li>
                                <li><a href="#Usage_Data-2"><span class="toc_number toc_depth_3">1.0.3</span> {{aitrans('Údaje o používání')}}</a></li>
                                <li><a href="#Tracking_Cookies_Data"><span class="toc_number toc_depth_3">1.0.4</span> {{aitrans('Údaje o sledování cookies')}}</a></li>
                                <li><a href="#Use_of_Data"><span class="toc_number toc_depth_3">1.0.5</span> {{aitrans('Použití údajů')}}</a></li>
                                <li><a href="#Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR"><span class="toc_number toc_depth_3">1.0.6</span> {{aitrans('Právní základ pro zpracování osobních údajů podle obecného nařízení o ochraně údajů (GDPR)')}}</a></li>
                                <li><a href="#Retention_of_Data"><span class="toc_number toc_depth_3">1.0.7</span> {{aitrans('Uchovávání údajů')}}</a></li>
                            </ul>
                        </li>
                    </ul>
                </li>
                <li><a href="#Transfer_Of_Data"><span class="toc_number toc_depth_1">2</span> {{aitrans('Přenos údajů')}}</a>
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Disclosure_Of_Data"><span class="toc_number toc_depth_3">2.0.1</span> {{aitrans('Zveřejnění údajů')}}</a>
                                    <ul>
                                        <li><a href="#Business_Transaction"><span class="toc_number toc_depth_4">2.0.1.1</span> {{aitrans('Obchodní transakce')}}</a></li>
                                    </ul>
                                </li>
                                <li><a href="#Legal_Requirements"><span class="toc_number toc_depth_3">2.0.2</span> {{aitrans('Právní požadavky')}}</a></li>
                                <li><a href="#Security_Of_Data"><span class="toc_number toc_depth_3">2.0.3</span> {{aitrans('Bezpečnost údajů')}}</a></li>
                                <li><a href="#Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR"><span class="toc_number toc_depth_3">2.0.4</span> {{aitrans('Vaše práva na ochranu údajů podle obecného nařízení o ochraně údajů (GDPR)')}}</a></li>
                            </ul>
                        </li>
                    </ul>
                </li>
                <li><a href="#Service_Providers"><span class="toc_number toc_depth_1">3</span> {{aitrans('Poskytovatelé služeb')}}</a>
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Analytics"><span class="toc_number toc_depth_3">3.0.1</span> {{aitrans('Analytika')}}</a></li>
                                <li><a href="#Advertising"><span class="toc_number toc_depth_3">3.0.2</span> {{aitrans('Reklama')}}</a></li>
                                <li><a href="#Behavioral_Remarketing"><span class="toc_number toc_depth_3">3.0.3</span> {{aitrans('Behaviorální remarketing')}}</a></li>
                                <li><a href="#Links_To_Other_Sites"><span class="toc_number toc_depth_3">3.0.4</span> {{aitrans('Odkazy na jiné stránky')}}</a></li>
                                <li><a href="#Children8217s_Privacy"><span class="toc_number toc_depth_3">3.0.5</span> {{aitrans('Ochrana soukromí dětí')}}</a></li>
                                <li><a href="#Changes_To_This_Privacy_Policy"><span class="toc_number toc_depth_3">3.0.6</span> {{aitrans('Změny těchto Zásad ochrany osobních údajů')}}</a></li>
                                <li><a href="#Contact_Us"><span class="toc_number toc_depth_3">3.0.7</span> {{aitrans('Kontaktujte nás')}}</a></li>
                            </ul>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
        <h4><span id="Definitions">{{aitrans('Definice')}}</span></h4>
        <h5><span id="Service">{{aitrans('Služba')}}</span></h5>
        <p>{{aitrans('Služba je')}} <span class="u">{{$website_title}}</span> {{aitrans('webové stránky provozované')}} <span class="b">{{aitrans('Poskytovatelem')}}</span></p>
        <h4><span id="Personal_Data">{{aitrans('Osobní údaje')}}</span></h4>
        <p>{{aitrans('Osobní údaje znamenají údaje o žijící osobě, která může být z těchto údajů (nebo z těchto a dalších informací, které máme v našem držení nebo které pravděpodobně dostaneme) identifikována.')}}</p>
        <h4><span id="Usage_Data">{{aitrans('Údaje o používání')}}</span></h4>
        <p>{{aitrans('Údaje o používání jsou údaje shromažďované automaticky, buď generované používáním Služby, nebo samotnou infrastrukturou Služby (například doba návštěvy stránky).')}}</p>
        <h4><span id="Cookies">{{aitrans('Cookies')}}</span></h4>
        <p>{{aitrans('Cookies jsou malé kusy údajů uložené na vašem zařízení (počítači nebo mobilním zařízení).')}}</p>
        <h4><span id="Data_Controller">{{aitrans('Správce údajů')}}</span></h4>
        <p>{{aitrans('Správce údajů je fyzická nebo právnická osoba, která (buď samostatně nebo společně nebo společně s jinými osobami) určuje účely a způsob, jakým jsou nebo mají být osobní údaje zpracovány. Pro účely těchto Zásad ochrany osobních údajů jsme správcem vašich osobních údajů.')}}</p>
        <h4><span id="Data_Processors_or_Service_Providers">{{aitrans('Zpracovatelé údajů (nebo poskytovatelé služeb)')}}</span></h4>
        <p>{{aitrans('Zpracovatel údajů (nebo poskytovatel služeb) je jakákoliv fyzická nebo právnická osoba, která zpracovává údaje jménem správce údajů. Můžeme využívat služby různých poskytovatelů služeb, abychom efektivněji zpracovali vaše údaje.')}}</p>
        <h4><span id="Data_Subject_or_User">{{aitrans('Subjekt údajů (nebo uživatel)')}}</span></h4>
        <p>{{aitrans('Subjekt údajů je jakákoliv žijící osoba, která používá naši Službu a je subjektem osobních údajů.')}}</p>
        <h2><span id="Information_Collection_And_Use">{{aitrans('Shromažďování a použití informací')}}</span></h2>
        <p>{{aitrans('Shromažďujeme několik různých typů informací pro různé účely, abychom vám poskytli a zlepšili naši Službu.')}}</p>
        <h4><span id="Types_of_Data_Collected">{{aitrans('Typy shromážděných údajů')}}</span></h4>
        <h4><span id="Personal_Data-2">{{aitrans('Osobní údaje')}}</span></h4>
        <p>{{aitrans('Při používání naší Služby vás můžeme požádat, abyste nám poskytli určité osobně identifikovatelné informace, které mohou být použity k kontaktování nebo identifikaci vás (“Osobní údaje”). Osobně identifikovatelné informace mohou zahrnovat, ale nejsou omezeny na:')}}</p>
        <ul>
            <li>{{aitrans('E-mailová adresa')}}</li>
            <li>{{aitrans('Jméno a příjmení')}}</li>
            <li>{{aitrans('Telefonní číslo')}}</li>
            <li>{{aitrans('Adresa, stát, provincie, PSČ, město')}}</li>
            <li>{{aitrans('Cookies a údaje o používání')}}</li>
        </ul>
        <p>{{aitrans('Vaše osobní údaje můžeme použít k tomu, abychom vás kontaktovali s newslettery, marketingovými nebo propagačními materiály a dalšími informacemi, které by vás mohly zajímat. Můžete se odhlásit z přijímání jakýchkoliv, nebo všech těchto komunikací od nás tím, že budete následovat odkaz pro odhlášení nebo pokyny poskytnuté v jakémkoliv e-mailu, který posíláme, nebo nás kontaktujte.')}}</p>
        <h4><span id="Usage_Data-2">{{aitrans('Údaje o používání')}}</span></h4>
        <p>{{aitrans('Můžeme také shromažďovat informace o tom, jak je Služba přístupná a používána (“Údaje o používání”). Tyto údaje o používání mohou zahrnovat informace, jako je internetová adresa vašeho počítače (např. IP adresa), typ prohlížeče, verze prohlížeče, stránky naší Služby, které navštívíte, čas a datum vaší návštěvy, doba strávená na těchto stránkách, jedinečné identifikátory zařízení a další diagnostická data.')}}</p>
        <h4><span id="Tracking_Cookies_Data">{{aitrans('Údaje o sledování cookies')}}</span></h4>
        <p>{{aitrans('Používáme cookies a podobné sledovací technologie k sledování aktivity na naší Službě a uchovávání určitých informací.')}}</p>
        <p>{{aitrans('Cookies jsou soubory s malým množstvím údajů, které mohou obsahovat anonymní jedinečný identifikátor. Cookies jsou odesílány do vašeho prohlížeče z webové stránky a ukládány na vašem zařízení. Sledovací technologie také zahrnují majáky, tagy a skripty pro shromažďování a sledování informací a zlepšování a analyzování naší Služby.')}}</p>
        <p>{{aitrans('Můžete instruovat svůj prohlížeč, aby odmítl všechny cookies nebo aby vás informoval, kdy je cookie odesílána. Pokud však cookies nepřijmete, možná nebudete moci používat některé části naší Služby.')}}</p>
        <p>{{aitrans('Příklady cookies, které používáme:')}}</p>
        <ul>
            <li><strong>{{aitrans('Cookies relace.')}}</strong> {{aitrans('Používáme cookies relace k provozování naší Služby.')}}</li>
            <li><strong>{{aitrans('Preferenční cookies.')}}</strong> {{aitrans('Používáme preferenční cookies k zapamatování vašich preferencí a různých nastavení.')}}</li>
            <li><strong>{{aitrans('Bezpečnostní cookies.')}}</strong> {{aitrans('Používáme bezpečnostní cookies pro bezpečnostní účely.')}}</li>
            <li><strong>{{aitrans('Reklamní cookies.')}}</strong> {{aitrans('Reklamní cookies se používají k zobrazování reklam, které mohou být relevantní pro vás a vaše zájmy.')}}</li>
        </ul>
        <h4><span id="Use_of_Data">{{aitrans('Použití údajů')}}</span></h4>
        <p><span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('používá shromážděné údaje k různým účelům:')}}</p>
        <ul>
            <li>{{aitrans('K poskytování a udržování naší Služby')}}</li>
            <li>{{aitrans('K upozornění na změny v naší Službě')}}</li>
            <li>{{aitrans('Abychom vám umožnili účastnit se interaktivních funkcí naší Služby, pokud se tak rozhodnete')}}</li>
            <li>{{aitrans('K poskytování zákaznické podpory')}}</li>
            <li>{{aitrans('K shromažďování analýz nebo cenných informací, abychom mohli zlepšit naši Službu')}}</li>
            <li>{{aitrans('K monitorování používání naší Služby')}}</li>
            <li>{{aitrans('K odhalování, prevenci a řešení technických problémů')}}</li>
            <li>{{aitrans('K poskytování novinek, speciálních nabídek a obecných informací o jiném zboží, službách a událostech, které nabízíme, které jsou podobné těm, které jste již zakoupili nebo se o ně zajímali, pokud jste se nerozhodli tyto informace nepřijímat')}}</li>
        </ul>
        <h4><span id="Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR">{{aitrans('Právní základ pro zpracování osobních údajů podle obecného nařízení o ochraně údajů (GDPR)')}}</span></h4>
        <p>{{aitrans('Pokud pocházíte z Evropského hospodářského prostoru (EHP),')}} <span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('právní základ pro shromažďování a používání osobních údajů popsaných v těchto Zásadách ochrany osobních údajů závisí na osobních údajích, které shromažďujeme, a na konkrétním kontextu, ve kterém je shromažďujeme.')}}</p>
        <p><span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('může zpracovávat vaše osobní údaje, protože:')}}</p>
        <ul>
            <li>{{aitrans('Potřebujeme splnit smlouvu s vámi')}}</li>
            <li>{{aitrans('Dali jste nám povolení k tomu')}}</li>
            <li>{{aitrans('Zpracování je v našem oprávněném zájmu a není převáženo vašimi právy')}}</li>
            <li>{{aitrans('Abychom se řídili zákonem')}}</li>
        </ul>
        <h4><span id="Retention_of_Data">{{aitrans('Uchovávání údajů')}}</span></h4>
        <p><span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('bude uchovávat vaše osobní údaje pouze po dobu nezbytnou k účelům uvedeným v těchto Zásadách ochrany osobních údajů. Budeme uchovávat a používat vaše osobní údaje v nezbytném rozsahu k dodržení našich právních povinností (například pokud jsme povinni uchovávat vaše údaje, abychom se řídili platnými zákony), řešení sporů a vynucování našich právních dohod a politik.')}}</p>
        <p><span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('také uchová údaje o používání pro interní analytické účely. Údaje o používání jsou obecně uchovávány po kratší dobu, kromě případů, kdy jsou tyto údaje použity k posílení bezpečnosti nebo ke zlepšení funkčnosti naší Služby, nebo jsme zákonem povinni uchovávat tyto údaje po delší dobu.')}}</p>
        <h2><span id="Transfer_Of_Data">{{aitrans('Přenos údajů')}}</span></h2>
        <p>{{aitrans('Vaše informace, včetně osobních údajů, mohou být převedeny na – a uchovávány na – počítačích umístěných mimo váš stát, provincii, zemi nebo jinou vládní jurisdikci, kde se zákony na ochranu údajů mohou lišit od těch ve vaší jurisdikci.')}}</p>
        <p>{{aitrans('Pokud se nacházíte mimo Bulharsko a rozhodnete se nám poskytnout informace, mějte prosím na paměti, že přenášíme údaje, včetně osobních údajů, do Bulharska a zpracováváme je tam.')}}</p>
        <p>{{aitrans('Váš souhlas s těmito Zásadami ochrany osobních údajů následovaný vaším odesláním takových informací představuje váš souhlas s tímto přenosem.')}}</p>
        <p><span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('učiní všechna rozumná opatření, aby zajistil, že vaše údaje budou zpracovávány bezpečně a v souladu s těmito Zásadami ochrany osobních údajů, a žádný přenos vašich osobních údajů se neuskuteční k organizaci nebo do země, pokud nebudou zajištěny adekvátní kontroly včetně zabezpečení vašich údajů a dalších osobních informací.')}}</p>
        <h4><span id="Disclosure_Of_Data">{{aitrans('Zveřejnění údajů')}}</span></h4>
        <h5><span id="Business_Transaction">{{aitrans('Obchodní transakce')}}</span></h5>
        <p>{{aitrans('Pokud je')}} <span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('zapojen do fúze, akvizice nebo prodeje aktiv, mohou být vaše osobní údaje převedeny. Před tím, než budou vaše osobní údaje převedeny a stanou se předmětem jiných Zásad ochrany osobních údajů, vás budeme informovat.')}}</p>
        <h4><span id="Legal_Requirements">{{aitrans('Právní požadavky')}}</span></h4>
        <p><span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('může zveřejnit vaše osobní údaje v dobré víře, že takový krok je nezbytný k:')}}</p>
        <ul>
            <li>{{aitrans('Abychom se řídili právními povinnostmi')}}</li>
            <li>{{aitrans('Abychom chránili a bránili práva nebo majetek')}} <span class="b">{{aitrans('Poskytovatele')}}</span></li>
            <li>{{aitrans('Abychom zabránili nebo vyšetřovali možné nesrovnalosti v souvislosti se Službou')}}</li>
            <li>{{aitrans('Abychom chránili osobní bezpečnost uživatelů Služby nebo veřejnosti')}}</li>
            <li>{{aitrans('Abychom se chránili před právní odpovědností')}}</li>
        </ul>
        <h4><span id="Security_Of_Data">{{aitrans('Bezpečnost údajů')}}</span></h4>
        <p>{{aitrans('Bezpečnost vašich údajů je pro nás důležitá, ale pamatujte, že žádná metoda přenosu přes internet ani metoda elektronického ukládání není 100% bezpečná. I když se snažíme používat komerčně přijatelné prostředky k ochraně vašich osobních údajů, nemůžeme zaručit jejich absolutní bezpečnost.')}}</p>
        <h4><span id="Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR">{{aitrans('Vaše práva na ochranu údajů podle obecného nařízení o ochraně údajů (GDPR)')}}</span></h4>
        <p>{{aitrans('Pokud jste rezidentem Evropského hospodářského prostoru (EHP), máte určitá práva na ochranu údajů.')}} <span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('se snaží učinit rozumné kroky, aby vám umožnil opravit, upravit, odstranit nebo omezit používání vašich osobních údajů.')}}</p>
        <p>{{aitrans('Pokud chcete být informováni, jaké osobní údaje o vás uchováváme, a pokud je chcete odstranit z našich systémů, kontaktujte nás.')}}</p>
        <p>{{aitrans('V určitých okolnostech máte následující práva na ochranu údajů:')}}</p>
        <p><strong>{{aitrans('Právo na přístup, aktualizaci nebo vymazání informací, které o vás máme.')}}</strong> {{aitrans('Kdykoliv je to možné, můžete přistupovat, aktualizovat nebo požádat o vymazání svých osobních údajů přímo v sekci nastavení vašeho účtu. Pokud nejste schopni tyto akce provést sami, kontaktujte nás, abychom vám pomohli.')}}<br> <strong>{{aitrans('Právo na opravu.')}}</strong> {{aitrans('Máte právo na opravu svých informací, pokud jsou tyto informace nepřesné nebo neúplné.')}}<br> <strong>{{aitrans('Právo vznést námitku.')}}</strong> {{aitrans('Máte právo vznést námitku proti našemu zpracování vašich osobních údajů.')}}<br> <strong>{{aitrans('Právo na omezení.')}}</strong> {{aitrans('Máte právo požádat, abychom omezili zpracování vašich osobních údajů.')}}<br> <strong>{{aitrans('Právo na přenositelnost údajů.')}}</strong> {{aitrans('Máte právo, aby vám byly poskytnuty kopie informací, které o vás máme, ve strukturovaném, strojově čitelném a běžně používaném formátu.')}}<br> <strong>{{aitrans('Právo odvolat souhlas.')}}</strong> {{aitrans('Máte také právo kdykoliv odvolat svůj souhlas, pokud')}} <span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('spoléhal na váš souhlas při zpracování vašich osobních údajů.')}}</p>
        <p>{{aitrans('Mějte na paměti, že vás můžeme požádat o ověření vaší identity před tím, než na takové žádosti odpovíme.')}}</p>
        <p>{{aitrans('Máte právo si stěžovat u orgánu pro ochranu údajů ohledně našeho shromažďování a používání vašich osobních údajů. Pro více informací kontaktujte svůj místní orgán na ochranu údajů v Evropském hospodářském prostoru (EHP).')}}</p>
        <h2><span id="Service_Providers">{{aitrans('Poskytovatelé služeb')}}</span></h2>
        <p>{{aitrans('Můžeme zaměstnat třetí strany a jednotlivce k usnadnění naší Služby (“Poskytovatelé služeb”), k poskytování Služby naším jménem, k vykonávání službami souvisejících služeb nebo k tomu, aby nám pomohli analyzovat, jak je naše Služba používána.')}}</p>
        <p>{{aitrans('Tyto třetí strany mají přístup k vašim osobním údajům pouze za účelem vykonání těchto úkolů naším jménem a jsou povinny je nezveřejňovat ani používat k jinému účelu.')}}</p>
        <h4><span id="Analytics">{{aitrans('Analytika')}}</span></h4>
        <p>{{aitrans('Můžeme používat třetí strany, abychom sledovali a analyzovali používání naší Služby.')}}</p>
        <p><strong>{{aitrans('Google Analytics')}}</strong><br> {{aitrans('Google Analytics je služba webové analytiky nabízená společností Google, která sleduje a hlásí návštěvnost webových stránek. Google používá shromážděné údaje k sledování a monitorování používání naší Služby. Tyto údaje jsou sdíleny s dalšími službami Google. Google může použít shromážděné údaje k kontextualizaci a personalizaci reklam v rámci své vlastní reklamní sítě. Můžete se odhlásit z toho, aby vaše aktivita na Službě byla k dispozici Google Analytics, nainstalováním doplňku prohlížeče pro odhlášení Google Analytics. Doplňek brání JavaScriptu Google Analytics (ga.js, analytics.js a dc.js) sdílet informace s Google Analytics o aktivitě návštěv. Pro více informací o praktikách ochrany soukromí společnosti Google navštivte webové stránky Zásad ochrany osobních údajů Google:')}} <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank" rel="noopener">http://www.google.com/intl/en/policies/privacy/</a></p>
        <h4><span id="Advertising">{{aitrans('Reklama')}}</span></h4>
        <p>{{aitrans('Můžeme používat třetí strany, abychom vám zobrazovali reklamy, abychom podpořili a udrželi naši Službu.')}}</p>
        <p><strong>{{aitrans('Cookie DoubleClick Google AdSense')}}</strong><br> {{aitrans('Google, jako třetí strana, používá cookies k zobrazování reklam na naší Službě. Použití cookie DoubleClick umožňuje společnosti Google a jejím partnerům zobrazovat reklamy našim uživatelům na základě jejich návštěv na naší Službě nebo na jiných webových stránkách na internetu. Můžete se odhlásit z používání cookie DoubleClick pro reklamu založenou na zájmech navštívením webové stránky nastavení reklam Google:')}} <a href="https://www.google.com/ads/preferences/" target="_blank" rel="noopener">http://www.google.com/ads/preferences/</a></p>
        <h4><span id="Behavioral_Remarketing">{{aitrans('Behaviorální remarketing')}}</span></h4>
        <p><span class="b">{{aitrans('Poskytovatel')}}</span> {{aitrans('používá remarketingové služby k inzerování na webových stránkách třetích stran poté, co navštívíte naši Službu. My a naši dodavatelé třetích stran používáme cookies k informování, optimalizaci a poskytování reklam na základě vašich předchozích návštěv na naší Službě.')}}</p>
        <p><strong>{{aitrans('Google AdWords')}}</strong><br> {{aitrans('Služba remarketingu Google AdWords je poskytována společností Google Inc. Můžete se odhlásit z Google Analytics pro reklamu zobrazenou a přizpůsobit reklamy Google Display Network navštívením stránky nastavení reklam Google: http://www.google.com/settings/ads. Google také doporučuje nainstalovat doplněk prohlížeče pro odhlášení Google Analytics – https://tools.google.com/dlpage/gaoptout – pro váš webový prohlížeč. Doplňek pro odhlášení Google Analytics poskytuje návštěvníkům možnost zabránit shromažďování a používání jejich údajů společností Google Analytics. Pro více informací o praktikách ochrany soukromí společnosti Google navštivte webové stránky Zásad ochrany osobních údajů Google:')}} <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank" rel="noopener">http://www.google.com/intl/en/policies/privacy/</a></p>
        <p><strong>{{aitrans('Facebook')}}</strong><br> {{aitrans('Služba remarketingu Facebook je poskytována společností Facebook Inc. Můžete se dozvědět více o reklamách založených na zájmech na Facebooku návštěvou této stránky:')}} <a href="https://www.facebook.com/help/164968693837950" target="_blank" rel="noopener">https://www.facebook.com/help/164968693837950</a> {{aitrans('Chcete-li se odhlásit od reklam na základě zájmů na Facebooku, postupujte podle těchto pokynů od Facebooku:')}} <a href="https://www.facebook.com/help/568137493302217" target="_blank" rel="noopener">https://www.facebook.com/help/568137493302217</a> {{aitrans('Facebook dodržuje zásady samoregulace pro online behaviorální reklamu, které stanovila Aliance digitální reklamy. Můžete se také odhlásit z Facebooku a dalších zúčastněných společností prostřednictvím Aliance digitální reklamy v USA')}} <a href="http://www.aboutads.info/choices/" target="_blank" rel="noopener">http://www.aboutads.info/choices/</a>{{aitrans(', Aliance digitální reklamy Kanady v Kanadě')}} <a href="http://youradchoices.ca/" target="_blank" rel="noopener">http://youradchoices.ca/</a> {{aitrans('nebo Aliance pro interaktivní digitální reklamu v Evropě')}} <a href="http://www.youronlinechoices.eu/" target="_blank" rel="noopener">http://www.youronlinechoices.eu/</a>{{aitrans(', nebo se odhlásit pomocí nastavení mobilního zařízení. Pro více informací o praktikách ochrany soukromí společnosti Facebook navštivte Zásady ochrany osobních údajů Facebooku:')}} <a href="https://www.facebook.com/privacy/explanation" target="_blank" rel="noopener">https://www.facebook.com/privacy/explanation</a></p>
        <h4><span id="Links_To_Other_Sites">{{aitrans('Odkazy na jiné stránky')}}</span></h4>
        <p>{{aitrans('Naše Služba může obsahovat odkazy na jiné stránky, které nejsou provozovány námi. Pokud kliknete na odkaz třetí strany, budete přesměrováni na stránky této třetí strany. Důrazně doporučujeme, abyste si přečetli Zásady ochrany osobních údajů každého navštíveného webu.')}}</p>
        <p>{{aitrans('Nemáme kontrolu nad obsahem, zásadami ochrany osobních údajů ani praktikami jakýchkoliv stránek nebo služeb třetích stran.')}}</p>
        <h4><span id="Children8217s_Privacy">{{aitrans('Ochrana soukromí dětí')}}</span></h4>
        <p>{{aitrans('Naše Služba se nezaměřuje na nikoho mladšího 18 let (“Děti”).')}}</p>
        <p>{{aitrans('Nepodporujeme vědomé shromažďování osobně identifikovatelných informací od nikoho mladšího 18 let. Pokud jste rodič nebo zákonný zástupce a jste si vědomi toho, že vaše Děti nám poskytly osobní údaje, kontaktujte nás. Pokud se dozvíme, že jsme shromáždili osobní údaje od dětí bez ověření rodičovského souhlasu, podnikneme kroky k odstranění těchto informací z našich serverů.')}}</p>
        <h4><span id="Changes_To_This_Privacy_Policy">{{aitrans('Změny těchto Zásad ochrany osobních údajů')}}</span></h4>
        <p>{{aitrans('Můžeme občas aktualizovat naše Zásady ochrany osobních údajů. O jakýchkoli změnách vás budeme informovat tím, že zveřejníme nové Zásady ochrany osobních údajů na této stránce.')}}</p>
        <p>{{aitrans('Před účinností změny vás budeme informovat e-mailem a/nebo výrazným oznámením v naší Službě a aktualizujeme “datum účinnosti” v horní části těchto Zásad ochrany osobních údajů.')}}</p>
        <p>{{aitrans('Doporučujeme vám pravidelně kontrolovat tyto Zásady ochrany osobních údajů na případné změny. Změny těchto Zásad ochrany osobních údajů jsou účinné v okamžiku, kdy jsou zveřejněny na této stránce.')}}</p>
        <h4><span id="Contact_Us">{{aitrans('Kontaktujte nás')}}</span></h4>
        <p>{{aitrans('Pokud máte jakékoli dotazy ohledně těchto Zásad ochrany osobních údajů, kontaktujte nás prosím e-mailem.')}}</p>
    </main>
</div>

@endsection
