@extends('layouts.app')
@push('meta')
    <title>{{ " $website_title - Side med privatlivspolitik" }}</title>
    <meta name="description" content="{{ "Få indsigt i vores databeskyttelsesmetoder $website_title privatlivspolitik sikrer gennemsigtighed, tydelighed og beskyttelse af dine oplysninger." }}" />
@endpush
@section('content')
    <section class="bnr-section">
        <div class="uk-container">
            <div class="uk-text-center">
                <h1>{{ aiTrans('Fortrolighedspolitik') }}</h1>
            </div>
        </div>

    </section>

    <section class="uk-section vik">
        <div class="uk-container">

            <p class="p-border ">{{ aiTrans('Sidst opdateret:13-02-2023') }}</p>
            <p class="gb-headline"><strong>{{ aiTrans('Dit privatliv er vigtigt for os') }}</strong></p>
            <p class="gb-headline">{{ $website_title }} <em> </em>{{ aiTrans('er placeret på:') }}</p>
            <p class="gb-headline p-border ">
                {{ aiTrans('Niveau 37 &amp; 40, Ocean Financial Centre, 10 Collyer Quay, Singapore 049315') }}<em>&nbsp;</em>
            </p>
            <p>
                {{ aiTrans(
                    'Det er [website_title]  ‘s politik at respektere dit privatliv med hensyn til enhver information, vi måtte indsamle under driften af ​​vores websted. Denne privatlivspolitik gælder for [website_title]  (herefter “os”, “vi” eller ” [website_title]  “). Vi respekterer dit privatliv og er forpligtet til at beskytte personligt identificerbare oplysninger, du måtte give os via webstedet.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <p>{{ aiTrans('Vi har vedtaget denne privatlivspolitik (“Privatlivspolitik”) for at forklare, hvilke oplysninger der kan indsamles på vores hjemmeside, hvordan vi bruger disse oplysninger, og under hvilke omstændigheder vi kan videregive oplysningerne til tredjeparter. Denne privatlivspolitik gælder kun for oplysninger, vi indsamler via webstedet, og gælder ikke for vores indsamling af oplysninger fra andre kilder.') }}
            </p>
            <p>{{ aiTrans('Denne privatlivspolitik, sammen med de servicevilkår, der er offentliggjort på vores hjemmeside, angiver de generelle regler og politikker, der styrer din brug af vores hjemmeside. Afhængigt af dine aktiviteter, når du besøger vores websted, kan du blive bedt om at acceptere yderligere servicevilkår.') }}
            </p>
            <h3 class="gb-headline">&nbsp;{{ aiTrans('Besøgende på webstedet') }}</h3>
            <p>
                {{ aiTrans('Som de fleste webstedsoperatører indsamler [website_title]  ikke-personligt identificerende oplysninger af den slags, som webbrowsere og servere typisk stiller til rådighed, såsom browsertype, sprogpræference, henvisningssted og dato og klokkeslæt for hver besøgendes anmodning. [website_title]  ‘s formål med at indsamle ikke-personligt identificerende oplysninger er at forstå bedre, hvordan besøgende på', $locale, ['website_title' => $website_title]) }}
                <a href="{{ route('home', $country) }}">{{ $website_title }} </a>
                {{ aiTrans(
                    'bruger deres hjemmeside. Fra tid til anden kan [website_title]  frigive ikke-personligt identificerende oplysninger samlet, f.eks. ved at offentliggøre en rapport om tendenser i brugen af ​​sin hjemmeside.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <p>
                {{ aiTrans(
                    '[website_title]  indsamler også potentielt personligt identificerende oplysninger som Internet Protocol (IP)-adresser for loggede brugere og for brugere, der efterlader kommentarer til',
                    $locale,
                    [
                        'website_title' => $website_title,
                        'url' => route('home', $country),
                    ],
                ) }}
                <a
                    href="{{ route('home', $country) }}">{{ route('home', $country) }}</a>{{ aiTrans(
                        ' blogindlæg. [website_title]  afslører kun loggede bruger- og kommentator-IP-adresser under de samme omstændigheder, som den bruger, og afslører personligt identificerende oplysninger som beskrevet nedenfor.',
                        $locale,
                        [
                            'website_title' => $website_title,
                            'url' => route('home', $country),
                        ],
                    ) }}
            </p>
            <h3 class="gb-headline">{{ aiTrans('Personligt identificerende oplysninger') }}</h3>
            <p>
                {{ aiTrans(
                    'Visse besøgende på [website_title]  websteder vælger at interagere med [website_title]  på måder, der kræver, at [website_title]  indsamler personligt identificerende oplysninger. Mængden og typen af ​​information, som [website_title]  indsamler, afhænger af arten af ​​interaktionen. For eksempel beder vi besøgende, der efterlader en kommentar på [url], om at angive et brugernavn og en e-mailadresse.',
                    $locale,
                    [
                        'website_title' => $website_title,
                        'url' => route('home', $country),
                    ],
                ) }}
            </p>
            <h3 class="gb-headline">{{ aiTrans('Sikkerhed') }}</h3>
            <p>{{ aiTrans('Sikkerheden af ​​dine personlige oplysninger er vigtig for os, men husk, at ingen metode til transmission over internettet eller metode til elektronisk lagring er 100 % sikker. Selvom vi stræber efter at bruge kommercielt acceptable midler til at beskytte dine personlige oplysninger, kan vi ikke garantere deres absolutte sikkerhed.') }}
            </p>
            <h3 class="gb-headline">{{ aiTrans('Beskyttelse af visse personligt identificerende oplysninger') }}</h3>
            <p>
                {{ aiTrans(
                    '[website_title]  videregiver kun potentielt personligt identificerende og personligt identificerende oplysninger til de af sine ansatte, entreprenører og tilknyttede organisationer, der (i) har brug for at kende disse oplysninger for at kunne behandle dem på [website_title]  ‘s vegne eller for at levere tjenester, der er tilgængelige på [website_title]  ‘s websted, og (ii) der har indvilget i ikke at videregive det til andre.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <p>
                {{ aiTrans(
                    'Nogle af disse medarbejdere, entreprenører og tilknyttede organisationer kan være placeret uden for dit hjemland; ved at bruge [website_title]  ‘s hjemmeside, giver du samtykke til overførsel af sådanne oplysninger til dem. [website_title]  vil ikke udleje eller sælge potentielt personligt identificerende og personligt identificerende oplysninger til nogen. Bortset fra sine medarbejdere, entreprenører og tilknyttede organisationer, som beskrevet ovenfor, videregiver [website_title]  potentielt personligt identificerende og personligt identificerende oplysninger kun som svar på en stævning, retskendelse eller anden regeringsanmodning, eller når [website_title]  i god tro mener, at offentliggørelse er rimeligt nødvendigt for at beskytte ejendom eller rettigheder tilhørende [website_title]  , tredjeparter eller offentligheden som helhed.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <p>{{ aiTrans('Hvis du er en registreret bruger af') }} <a
                    href="{{ route('home', $country) }}">{{ $website_title }}</a>
                {{ aiTrans(
                    'og har oplyst din e-mailadresse, kan [website_title]  lejlighedsvis sende dig en e-mail for at fortælle dig om nye funktioner, anmode om din feedback eller bare holde dig opdateret med, hvad der sker med [website_title]  og vores produkter. Vi bruger primært vores blog til at kommunikere denne type information, så vi forventer at holde denne type e-mail på et minimum.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <p>
                {{ aiTrans(
                    'Hvis du sender os en anmodning (for eksempel via en support-e-mail eller via en af ​​vores feedbackmekanismer), forbeholder vi os retten til at offentliggøre den for at hjælpe os med at afklare eller svare på din anmodning eller for at hjælpe os med at støtte andre brugere. [website_title]  tager alle rimeligt nødvendige forholdsregler for at beskytte mod uautoriseret adgang, brug, ændring eller ødelæggelse af potentielt personligt identificerende og personligt identificerende oplysninger.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <h3 class="gb-headline">{{ aiTrans('Aggregeret statistik') }}</h3>
            <p>
                {{ aiTrans(
                    '[website_title]  kan indsamle statistik om adfærd hos besøgende på sin hjemmeside. [website_title]  kan vise disse oplysninger offentligt eller give dem til andre. [website_title]  afslører dog ikke dine personligt identificerende oplysninger.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <h3 class="gb-headline">{{ aiTrans('Afsløring af tilknyttede virksomheder') }}</h3>
            <p>{{ aiTrans('Dette websted bruger affiliate links og tjener en kommission fra visse links. Dette påvirker ikke dine køb eller den pris, du måtte betale.') }}
            </p>
            <h3 class="gb-headline">{{ aiTrans('Cookies') }}</h3>
            <p>
                {{ aiTrans(
                    'For at berige og perfektionere din onlineoplevelse bruger [website_title]  “Cookies”, lignende teknologier og tjenester leveret af andre til at vise personligt indhold, passende reklamer og gemme dine præferencer på din computer.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <p>
                {{ aiTrans(
                    'En cookie er en række informationer, som et websted gemmer på en besøgendes computer, og som den besøgendes browser giver til webstedet, hver gang den besøgende vender tilbage. [website_title]  bruger cookies til at hjælpe [website_title]  med at identificere og spore besøgende, deres brug af',$locale,
                    [
                        'website_title' => $website_title,
                        'url' => route('home', $country),
                    ],
                ) }} <a href="{{route('home', $country)}}">{{route('home', $country)}}</a>{{aiTrans(' og deres præferencer for webstedsadgang. [website_title]  besøgende, der ikke ønsker at have cookies placeret på deres computere, bør indstille deres browsere til at afvise cookies, før de bruger [website_title]  ‘s websteder, med den ulempe, at visse funktioner på [website_title]  ‘s websteder muligvis ikke fungerer korrekt uden hjælp af cookies.',
                    $locale,
                    [
                        'website_title' => $website_title,
                        'url' => route('home', $country),
                    ],
                ) }}
            </p>
            <p>
                {{ aiTrans(
                    'Ved at fortsætte med at navigere på vores hjemmeside uden at ændre dine cookie-indstillinger, anerkender og accepterer du hermed [website_title]  ‘s brug af cookies.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <h3 class="gb-headline">{{ aiTrans('E-handel') }}</h3>
            <p>
                {{ aiTrans(
                    'De, der deltager i transaktioner med [website_title]  – ved at købe [website_title]  tjenester eller produkter, bliver bedt om at give yderligere oplysninger, herunder om nødvendigt de personlige og finansielle oplysninger, der kræves for at behandle disse transaktioner. I hvert tilfælde indsamler [website_title]  kun sådanne oplysninger i det omfang, det er nødvendigt eller passende for at opfylde formålet med den besøgendes interaktion med [website_title]  . [website_title]  afslører ikke personligt identificerende oplysninger ud over som beskrevet nedenfor. Og besøgende kan altid nægte at levere personligt identificerende oplysninger med det forbehold, at det kan forhindre dem i at deltage i visse webstedsrelaterede aktiviteter.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <h3 class="gb-headline">{{ aiTrans('Ændringer i privatlivspolitik') }}</h3>
            <p>
                {{ aiTrans(
                    'Selvom de fleste ændringer sandsynligvis vil være mindre, kan [website_title]  ændre sin privatlivspolitik fra tid til anden og efter [website_title]  ‘s eget skøn. [website_title]  opfordrer besøgende til jævnligt at tjekke denne side for ændringer i dens privatlivspolitik. Din fortsatte brug af dette websted efter enhver ændring i denne fortrolighedspolitik vil udgøre din accept af en sådan ændring.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
            </p>
            <h3 class="gb-headline">{{ aiTrans('Kontaktoplysninger og kredit') }}</h3>
            <p>{{ aiTrans('Hvis du har spørgsmål om vores privatlivspolitik, bedes du kontakte os via') }} <a
                    href="mailto:info{{ '@' . $website_title }}">e-mail</a> .</p>

        </div>

    </section>
@endsection
