@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title $website_name | Plataforma confiable para comercio de criptomonedas" }}</title>
    <meta name="description" content="{{ "Con el soporte y las herramientas avanzadas de $website_title potencia tus habilidades de trading e inversión en criptomonedas para cumplir tus objetivos." }}" />
@endpush
@section('content')

<section class="main">
    <div class="container text-center mb-md-5">
        <h1 class="main-header">{{ $website_title }}</h1>
    </div>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-7">
                <div class="main-image">
                    <picture>
                        <source type="image/webp" srcset="{{ asset('frontend/assets/es/dist') }}/images/video-image.webp">
                        <source type="image/png" srcset="{{ asset('frontend/assets/es/dist') }}/images/video-image.jpg">
                        <img src="{{ asset('frontend/assets/es/dist') }}/images/video-image.jpg" width="831"
                            height="584" alt="Imagen principal de navegador de riqueza digital">
                    </picture>
                </div>
            </div>
            <div class="col-lg-5 ">
                <div id="req-form-section" class="main-form ">
                    <div class="main-form-title">{{ aiTrans('Bienvenido a') }}<span>{{ $website_title }}</span></div>
                    @include('frontend.es.components.form')
                </div>
            </div>
        </div>
    </div>
</section>

<section class="half-1">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="title">
                    {{ aiTrans('Explora [website_title]', $locale, ['website_title' => $website_title]) }}
                </h2>
                <p><strong class="change-by-command">{{ "$website_title - ¿Deseas transparencia en tu trayecto económico?" }}</strong></p>
                <p class="change-by-command">{{ "Te damos la bienvenida a  $website_title , tu guía en línea para explorar el complejo mundo de las inversiones. Piénsanos como tu socio experto, poniéndote en contacto con profesionales de la industria preparados para aclarar tu camino financiero. ¡Nuestros servicios son totalmente gratuitos!" }}</p>
                <div class="group-text-wrap">
                    <input type="checkbox" id="group-text-1">
                    <div class="group-text">
                        <p>{{ aiTrans('Nuestros especialistas han forjado alianzas con empresas líderes en educación financiera,
                                                                                                            deseosas de compartir su conocimiento sin costo alguno. Imagina un navegador dedicado,
                                                                                                            facilitando tu transformación en un inversor informado, gracias a nuestras conexiones
                                                                                                            directas con estos pioneros de la formación.') }}
                        </p>
                        <p>
                            {{ aiTrans(
                                '[website_title] se propone desmitificar la educación financiera, haciendo accesible el
                                                                                                                        conocimiento sobre inversiones para todos, sin importar su contexto financiero o
                                                                                                                        experiencia.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                        </p>
                        <p>
                            {{ aiTrans(
                                'Inicia tu viaje de inversión con [website_title] sin coste alguno. Conéctate con el mentor
                                                                                                                        perfecto para una experiencia de aprendizaje tanto enriquecedora como agradable. Sigue
                                                                                                                        leyendo para descubrir más, presentado de manera clara y atractiva.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                        </p>
                    </div>
                    <label for="group-text-1" class="group-text-more">{{ aiTrans('Leer más') }}</label>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="half-2">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-4">
                <h2 class="title">Conoce a {{ $website_title }}</h2>
                <p><strong>{{ aiTrans('Nos enorgullece ser el vínculo confiable que te conecta, como aprendiz entusiasta, con
                                                                                una fuente segura de educación en inversión.') }}</strong>
                </p>
                <div class="text-center text-md-left mt-3 mt-md-5">
                    <a href="#req-form-section" class="main-form-btn">{{ aiTrans('REGÍSTRATE GRATIS') }}</a>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="padding-60 bg-gray">
    <div class="container text-center">
        <h2 class="title">Tu ventaja única con {{ $website_title }} para aprender a invertir</h2>
    </div>
    <div class="container" style="max-width: 1280px;">
        <div class="py-4 text-center mb-4">
            <picture>
                <source type="image/webp" srcset="{{ asset('frontend/assets/es/dist') }}/images/img-1.webp">
                <source type="image/png" srcset="{{ asset('frontend/assets/es/dist') }}/images/img-1.png">
                <img src="{{ asset('frontend/assets/es/dist') }}/images/img-1.png" width="1282" height="265"
                    alt="Pionero en la educación inteligente para invertir">
            </picture>
        </div>
        <div class="text-center mb-4">
            <h3 class="fs-18 text-uppercase">
                <strong>{{ aiTrans('Compromiso con Mentores de Inversión Élites') }}</strong>
            </h3>
            <p>{{ aiTrans('Comenzar un nuevo camino de aprendizaje en la inversión puede parecer desafiante. [website_title] cierra la brecha educativa, conectándote con las principales instituciones que ofrecen conocimientos profundos sobre inversión.', $locale, ['website_title' => $website_title]) }}
            </p>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="count-item">
                    <h2 class="count-item-title count-item-title--check">
                        {{ aiTrans('Compromiso con la Excelencia: Navegando tu camino con [website_title]', $locale, ['website_title' => $website_title]) }}
                    </h2>
                    <div class="count-item-content">
                        <h3 class="fs-18 text-uppercase mb-4">
                            <strong>{{ aiTrans('Conectándote con la mejor información.') }}</strong>
                        </h3>
                        <ul class="list-check">
                            <li>{{ aiTrans('La membresía es sencilla y gratuita, acogiendo a individuos de diversos niveles de habilidad y antecedentes.') }}
                            </li>
                            <li>{{ aiTrans('Al registrarte, te conectamos con un socio educativo distinguido, seleccionado para cumplir con tus objetivos de aprendizaje específicos.') }}
                            </li>
                            <li>{{ aiTrans('Un experto de nuestra organización asociada te contactará para una introducción virtual detallada a sus ofertas.') }}
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-md-6">

                <div class="count-item">
                    <h2 class="count-item-title count-item-title--check">
                        {{ aiTrans('Alineado con los principales proveedores de educación en inversión') }}</h2>
                    <div class="count-item-content">
                        <h3 class="fs-18 text-uppercase mb-4">
                            <strong>{{ aiTrans('Una alianza tripartita: Tú, [website_title], y Mentores Expertos', $locale, ['website_title' => $website_title]) }}</strong>
                        </h3>
                        <ul class="list-check">
                            <li>{{ aiTrans('La calidad es nuestra máxima prioridad, asegurando una experiencia de aprendizaje inigualable para nuestros usuarios.') }}
                            </li>
                            <li>{{ aiTrans('Nuestro proceso de asociación selectiva con los proveedores de educación está enfocado en tu avance educativo y crecimiento personal.') }}
                            </li>
                            <li>{{ aiTrans('Considéranos como tu guía personal en el campo de la educación en inversión y la mentoría.') }}
                            </li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>



<section class="bg-image-1">
    <div class="padding-60 pb-2">
        <div class="container">
            <h2 class="title white text-center">
                {{ aiTrans('Nuestro Enfoque en [website_title]', $locale, ['website_title' => $website_title]) }}</h2>
        </div>
    </div>
    <div class="half-3">
        <div class="container">
            <div class="row">
                <div class="col-md-6 offset-md-5">
                    <div class="info-item">
                        <input type="checkbox">
                        <h3 class="info-item-title">{{ aiTrans('Paso 1: Registro simplificado') }}</h3>
                        <div class="info-item-content">
                            <p>{{ aiTrans('Registrarse es muy fácil. Proporcione su información básica: nombre, correo electrónico y número de teléfono. Complete los campos requeridos y estará listo para el siguiente paso.') }}
                            </p>
                        </div>
                    </div>
                    <div class="info-item">
                        <input type="checkbox">
                        <h3 class="info-item-title">{{ aiTrans('Paso 2: Emparejamientos personalizados') }}</h3>
                        <div class="info-item-content">
                            <p>{{ aiTrans('Adaptamos nuestro proceso de emparejamiento para conectarlo con un proveedor de educación en inversiones de primer nivel que se alinee con sus metas financieras y estilo de aprendizaje únicos. Nuestro objetivo es asegurarle el socio educativo perfecto para su viaje.') }}
                            </p>
                        </div>
                    </div>
                    <div class="info-item">
                        <input type="checkbox">
                        <h3 class="info-item-title">{{ aiTrans('Paso 3: Conversaciones enriquecedoras') }}</h3>
                        <div class="info-item-content">
                            <p>{{ aiTrans('Luego, inicie una conversación con un representante del proveedor educativo asignado. Esta discusión crucial le abrirá las puertas a información esencial y futuras oportunidades.') }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="padding-60 pt-2">
        <div class="container">
            <div class="text-center">
                <a href="#req-form-section" class="main-form-btn">{{ aiTrans('REGÍSTRESE AHORA') }}</a>
            </div>
        </div>
    </div>
</section>


<section class="half-4">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="title">{{ aiTrans('Explora el universo de la educación en inversión') }}</h2>
                <p><b>{{ aiTrans('Piensa en la educación en inversión como tu brújula en el vasto océano financiero. Es el conocimiento que te capacita para tomar decisiones seguras y sortear obstáculos. En el dinámico mundo de las finanzas, es tu ventaja, guiándote con claridad sin complicaciones.') }}</b>
                </p>
            </div>
        </div>
    </div>
</section>

<section class="padding-60 pt-2">
    <div class="container">
        <div class="text-center mb-4 mb-md-5">
            <h2 class="title">{{ aiTrans('Educación en Inversión: Navegando en Incertidumbres Financieras') }}</h2>
            <p><b>{{ aiTrans('La educación en inversión es tu brújula para atravesar el complejo terreno financiero. Te permite tomar decisiones informadas y evitar errores costosos. En un entorno financiero que cambia constantemente, es tu ventaja estratégica, proporcionando una guía clara y precisa sin términos confusos.') }}</b>
            </p>
        </div>
        <div class="row mb-4 mb-md-5">
            <div class="col-md-6">
                <div class="item-box">
                    <div class="item-box-icon">
                        <picture>
                            <source type="image/webp"
                                srcset="{{ asset('frontend/assets/es/dist') }}/images/icon-1.webp">
                            <source type="image/png"
                                srcset="{{ asset('frontend/assets/es/dist') }}/images/icon-1.png">
                            <img src="{{ asset('frontend/assets/es/dist') }}/images/icon-1.png" width="78"
                                height="96" alt="{{ $website_title }}">
                        </picture>
                    </div>
                    <h3 class="item-box-title">{{ aiTrans('Dominar la Gestión de Riesgos') }}</h3>
                    <p>{{ aiTrans('La educación en inversión te capacita para equilibrar los riesgos y detectar oportunidades. Comprenderás las tendencias del mercado y tomarás decisiones informadas, respaldadas por la red de expertos de [website_title]. Esta perspicacia te equipa para atravesar las fluctuaciones económicas con un enfoque estratégico.', $locale, ['website_title' => $website_title]) }}
                    </p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="item-box">
                    <div class="item-box-icon">
                        <picture>
                            <source type="image/webp"
                                srcset="{{ asset('frontend/assets/es/dist') }}/images/icon-2.webp">
                            <source type="image/png"
                                srcset="{{ asset('frontend/assets/es/dist') }}/images/icon-2.png">
                            <img src="{{ asset('frontend/assets/es/dist') }}/images/icon-2.png" width="105"
                                height="103" alt="{{ $website_title }}">
                        </picture>
                    </div>
                    <h3 class="item-box-title">{{ aiTrans('Adoptar la Diversificación') }}</h3>
                    <p>{{ aiTrans('Los fundamentos de la diversificación son un elemento clave de la educación en inversión, destacando la importancia de un portafolio variado para reducir los riesgos. [website_title] ofrece acceso a una experiencia que enriquece tu comprensión de la diversificación estratégica.', $locale, ['website_title' => $website_title]) }}
                    </p>
                </div>
            </div>
        </div>
        <div class="text-center">
            <h3 class="sub-title">{{ aiTrans('Adaptarse con Agilidad') }}</h3>
            <p>{{ aiTrans('La educación en inversión te arma con la capacidad de adaptarte rápidamente a los cambios de mercado. Fomenta el estar informado y revisar las estrategias para capitalizar las oportunidades. Echo Prism AI te conecta con profesionales que resaltan el papel de la flexibilidad en el triunfo financiero.') }}
            </p>
            <div class="text-center mt-3 mt-md-4">
                <a href="#req-form-section" class="main-form-btn">{{ aiTrans('INSCRÍBETE AHORA') }}</a>
            </div>
        </div>
    </div>
</section>
<section class="bg-gray">
    <div class="half-5">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="title">
                        {{ aiTrans('¿Puede la educación en inversiones asegurar la estabilidad financiera?') }}</h2>
                    <p><b>{{ aiTrans('A nivel mundial, las personas se esfuerzan por desentrañar la complejidad financiera. El viaje hacia la comprensión es multifacético, resaltando la importancia de la educación en inversiones.') }}</b>
                    </p>
                    <p>{{ aiTrans('Desde cursos estructurados hasta programas de mentoría como los facilitados por Echo Prism AI, la educación en inversiones busca desmitificar el campo de la inversión. Esto plantea la pregunta: ¿el dominio de los conceptos de inversión realmente mejora su agudeza financiera?') }}
                    </p>
                </div>
            </div>
        </div>
    </div>

    <div class="padding-60 pt-2">
        <div class="container">
            <p>{{ aiTrans('¡Definitivamente sí! Al estar equipado con conocimientos en inversión, posee una herramienta esencial para tomar decisiones financieras inteligentes, gestionar riesgos, diversificar su cartera de inversión y responder a las dinámicas del mercado. La educación en inversiones le protege de los errores financieros comunes, guiándole a través del panorama financiero como un faro.') }}
            </p>
        </div>
    </div>
</section>

<section class="bg-image-2 padding-60">
    <div class="container mb-4 mb-md-5" style="max-width: 1330px;">
        <h2 class="title white text-center">
            {{ aiTrans('Evita los riesgos de una educación de inversión deficiente') }}</h2>
        <p><b>{{ aiTrans('La falta o mala interpretación de la educación en inversión puede causar errores críticos, afectando tanto a principiantes como a aquellos con algo de experiencia. A continuación, te presentamos cuatro principales peligros de un conocimiento insuficiente en inversión:') }}</b>
        </p>
    </div>
    <div class="container" style="max-width: 1250px;">
        <div class="row">
            <div class="col-md-6">
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title info-item-title--check">{{ aiTrans('Decisiones erróneas') }}</h3>
                    <div class="info-item-content">
                        <p>{{ aiTrans('Sin una sólida educación en inversión, las decisiones pueden carecer de juicio informado, llevando a posibles trampas financieras. Invertir sin comprender bien las sutilezas del mercado aumenta el riesgo de pérdida.') }}
                        </p>
                    </div>
                </div>
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title info-item-title--check">{{ aiTrans('Sobreestimación del riesgo') }}
                    </h3>
                    <div class="info-item-content">
                        <p>{{ aiTrans('Una comprensión parcial puede empujar a las personas hacia inversiones excesivamente riesgosas sin un plan adecuado, incrementando significativamente la probabilidad de reveses financieros. Estas acciones pueden descarrilar tus objetivos económicos.') }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title info-item-title--check">{{ aiTrans('Enfoque a corto plazo') }}</h3>
                    <div class="info-item-content">
                        <p>{{ aiTrans('Una falta de educación profunda en inversión puede resultar en un enfoque en las ganancias inmediatas en lugar de en el crecimiento sostenible, renunciando potencialmente a los beneficios a largo plazo por ganancias a corto plazo.') }}
                        </p>
                    </div>
                </div>
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title info-item-title--check">{{ aiTrans('Reveses financieros') }}</h3>
                    <div class="info-item-content">
                        <p>{{ aiTrans('Ignorar los fundamentos de la educación en inversión puede llevar a reveses económicos significativos, agotando los recursos y causando tanto estrés inmediato como desilusión financiera a largo plazo.') }}
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center mt-3 mt-md-4">
            <a href="#req-form-section" class="main-form-btn">{{ aiTrans('COMIENZA A APRENDER') }}</a>
        </div>
    </div>
</section>


<section class="half-6">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-4">
                <h2 class="title">
                    {{ aiTrans('Revolucionando la educación en inversión: la propuesta de [website_title]', $locale, ['website_title' => $website_title]) }}
                </h2>
                <p><b>{{ aiTrans('En el umbral de una era innovadora, [website_title] lidera la transformación de la educación en inversión con tecnología avanzada. Nuestra plataforma adapta las experiencias de aprendizaje, ajustándose al ritmo y necesidades únicas de cada usuario con soluciones digitales de última generación.', $locale, ['website_title' => $website_title]) }}</b>
                </p>
                <div class="group-text-wrap">
                    <input type="checkbox" id="group-text-2">
                    <div class="group-text">
                        <p>{{ aiTrans('Empleando inteligencia artificial (IA) y aprendizaje automático, [website_title] está redefiniendo la educación en inversión. Al analizar vastos conjuntos de datos, proporciona perspectivas y estrategias personalizadas, mejorando la experiencia educativa de usuarios alrededor del mundo.', $locale, ['website_title' => $website_title]) }}
                        </p>
                        <p>{{ aiTrans('Herramientas innovadoras como la realidad virtual (VR) hacen que el aprendizaje sea inmersivo e interactivo. Estas tecnologías no solo capturan la atención de los usuarios, sino que también fortalecen la retención de conocimientos, preparándolos para enfrentar los mercados financieros con confianza y recursos educativos centrados en el usuario.') }}
                        </p>
                        <p>{{ aiTrans('En la intersección de la educación y el progreso tecnológico, [website_title] colabora con educadores líderes para ofrecerte directamente herramientas de aprendizaje de vanguardia.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                    <label for="group-text-2" class="group-text-more">{{ aiTrans('Leer más') }}</label>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="half-7">
    <div class="container">
        <div class="row">
            <div class="col-md-9">
                <h2 class="title">{{ aiTrans('Potenciando a través de la educación en inversiones') }}</h2>
                <p><b>{{ aiTrans('Con [website_title], la educación en inversiones trasciende los fundamentos de las transacciones financieras; se adentra profundamente en el mercado, permitiéndote dominar sus matices para garantizar estabilidad financiera y crecimiento.', $locale, ['website_title' => $website_title]) }}</b>
                </p>
                <p>{{ aiTrans('El impacto de la educación en inversiones se extiende más allá de los individuos, empoderando a las comunidades para navegar eficazmente los desafíos económicos. Es un paso colectivo hacia la autonomía financiera.') }}
                </p>
                <div class="group-text-wrap">
                    <input type="checkbox" id="group-text-3">
                    <div class="group-text">
                        <p>{{ aiTrans('[website_title] va más allá de la gestión financiera tradicional, guiándote a través de las complejidades de la inversión y conectándote con organizaciones educativas líderes.', $locale, ['website_title' => $website_title]) }}
                        </p>
                        <p>{{ aiTrans('Esta forma de educación beneficia a la economía en su totalidad, estimulando el crecimiento, la innovación y la creación de empleo. Se trata de construir una sociedad informada, capaz de tomar decisiones financieras sabias, favoreciendo una economía más saludable.') }}
                        </p>
                        <p>{{ aiTrans('Nuestra visión se alinea con la promoción de un mundo donde la educación financiera sea accesible para todos, sin dejar a nadie atrás en el camino hacia la alfabetización y la independencia financieras.') }}
                        </p>
                    </div>
                    <label for="group-text-3" class="group-text-more">{{ aiTrans('Leer más') }}</label>
                </div>
                <div class="text-center text-md-left mt-3 mt-md-4">
                    <a href="#" class="main-form-btn show-modal">{{ aiTrans('DESCUBRE MÁS') }}</a>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="bg-image-3 padding-60">
    <div class="container">
        <div class="text-center">
            <h2 class="title white">
                {{ aiTrans('Expandimos el acceso a la educación en inversión con [website_title]', $locale, ['website_title' => $website_title]) }}
            </h2>
            <p><b>{{ aiTrans('[website_title] se dedica a democratizar la educación en inversión, derribando barreras de conocimiento financiero y conectando a aprendices de todos los orígenes con recursos educativos de excelencia.', $locale, ['website_title' => $website_title]) }}</b>
            </p>
        </div>
        <p>{{ aiTrans('Esta iniciativa va más allá de una simple introducción a las finanzas; se trata de cultivar una cultura de aprendizaje continuo y adaptación al mundo financiero en constante cambio, garantizando que cada aprendiz, sea novato o experto, esté preparado para triunfar.') }}
        </p>
    </div>
</section>

<section class="padding-60">
    <div class="container">
        <h2 class="title text-center mb-md-5">
            {{ aiTrans('Potencie su Estrategia de Inversión con [website_title]', $locale, ['website_title' => $website_title]) }}
        </h2>
        <div class="row count-item-row">
            <div class="col-md-6">
                <div class="count-item">
                    <h3 class="count-item-title">{{ aiTrans('Definición Estratégica de Metas Financieras') }}</h3>
                    <div class="count-item-content">
                        <p>{{ aiTrans('El éxito en la inversión comienza con una definición clara y alcanzable de las metas. [website_title] le ayuda a concretar sus aspiraciones financieras, ya sean proyectos ambiciosos o planes modestos, resaltando la importancia de una planificación estratégica en su camino financiero.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="count-item">
                    <h3 class="count-item-title">
                        {{ aiTrans('Optimización de los Horizontes Temporales de Inversión') }}</h3>
                    <div class="count-item-content">
                        <p>{{ aiTrans('El tiempo es un factor clave en las inversiones. [website_title] destaca la importancia de alinear sus estrategias de inversión con los horizontes temporales adecuados, maximizando las oportunidades de ganancias tanto a corto como a largo plazo.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="count-item">
                    <h3 class="count-item-title">{{ aiTrans('Dominio de Técnicas de Presupuesto') }}</h3>
                    <div class="count-item-content">
                        <p>{{ aiTrans('El presupuesto es la base de una sólida educación financiera. [website_title] promueve una gestión eficaz de los gastos y una asignación óptima de recursos, dirigiendo cada dólar hacia la consecución de sus objetivos financieros.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="count-item">
                    <h3 class="count-item-title">{{ aiTrans('Construcción de Fondos de Emergencia Sólidos') }}</h3>
                    <div class="count-item-content">
                        <p>{{ aiTrans('Prepararse para desafíos financieros imprevistos es vital. [website_title] subraya la importancia de contar con fondos de emergencia, creando un respaldo financiero que proteja sus inversiones y le brinde tranquilidad.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="count-item">
                    <h3 class="count-item-title">{{ aiTrans('Gestión de la Tolerancia al Riesgo') }}</h3>
                    <div class="count-item-content">
                        <p>{{ aiTrans('Conocer su tolerancia al riesgo es esencial para tomar decisiones de inversión informadas. [website_title] le ofrece orientación para evaluar su comodidad con el riesgo, asegurando que sus decisiones de inversión reflejen sus metas financieras y su apetito por el riesgo.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="count-item">
                    <h3 class="count-item-title">{{ aiTrans('Análisis del Comportamiento del Mercado') }}</h3>
                    <div class="count-item-content">
                        <p>{{ aiTrans('Entender la dinámica del mercado es fundamental. [website_title] se centra en las tendencias del mercado y los cambios potenciales, proporcionándole las herramientas necesarias para desarrollar estrategias resilientes que puedan soportar las fluctuaciones del mercado.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="half-8 bg-gray">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-4">
                <h2 class="title">{{ aiTrans('Tu pasarela hacia la maestría financiera') }}</h2>
                <p><b>{{ aiTrans('En el mundo dinámico de las finanzas, la relevancia de contar con estrategias de inversión sólidas es crucial. Esta realidad resalta la importancia de las finanzas informadas en nuestra vida diaria.') }}</b>
                </p>
                <p>{{ aiTrans('Te presentamos [website_title], tu socio innovador que simplifica la esfera de inversión para los entusiastas. Nuestra plataforma actúa como un puente esencial, conectando a los aprendices apasionados con instituciones educativas reputadas, brindando perspectivas claras y completas sobre el mundo de la inversión.', $locale, ['website_title' => $website_title]) }}
                </p>
                <p>{{ aiTrans('Para aquellos fascinados por los mercados financieros y que desean profundizar sus conocimientos en inversión, [website_title] es el portal hacia el saber experto, ofreciendo acceso gratuito a una vasta cantidad de recursos educativos, sentando las bases para decisiones de inversión inteligentes y un crecimiento financiero sostenido.', $locale, ['website_title' => $website_title]) }}
                </p>
            </div>
        </div>
    </div>
</section>

<section class="padding-60">
    <div class="container text-center mb-md-5">
        <h2 class="title text-center">{{ aiTrans('Preguntas Frecuentes') }}</h2>
    </div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="faq-item">
                    <input type="checkbox">
                    <h3 class="faq-item-title">
                        {{ aiTrans('¿Qué hace único a [website_title] si no proporciona directamente cursos?', $locale, ['website_title' => $website_title]) }}
                    </h3>
                    <div class="faq-item-content">
                        <p>{{ aiTrans('A diferencia de las plataformas educativas tradicionales, [website_title] actúa como su guía en el vasto campo de la educación en inversiones, facilitando conexiones fluidas con proveedores de élite. Nuestro objetivo es allanar su camino hacia la alfabetización financiera conectándolo con recursos y mentores de primer nivel.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                </div>
                <div class="faq-item">
                    <input type="checkbox">
                    <h3 class="faq-item-title">
                        {{ aiTrans('¿Hay algún costo por usar [website_title]?', $locale, ['website_title' => $website_title]) }}
                    </h3>
                    <div class="faq-item-content">
                        <p>{{ aiTrans('No, [website_title] ofrece acceso completamente gratuito a la educación para la inversión. Desde la inscripción hasta la conexión con proveedores educativos excepcionales, no se incurre en ningún costo. Estamos comprometidos con su viaje de educación financiera sin el obstáculo del costo.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="faq-item">
                    <input type="checkbox">
                    <h3 class="faq-item-title">{{ aiTrans('¿Cuánto tiempo debería dedicar al aprendizaje?') }}</h3>
                    <div class="faq-item-content">
                        <p>{{ aiTrans('La cantidad de tiempo que debería dedicar a la educación financiera dependerá de su ritmo de aprendizaje personal y sus objetivos. [website_title] se asegura de emparejarlo con educadores que adaptan sus programas a sus necesidades, proporcionando una experiencia de aprendizaje efectiva y personalizada.', $locale, ['website_title' => $website_title]) }}
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center mt-3 mt-md-4">
            <a href="#req-form-section" class="main-form-btn">{{ aiTrans('COMIENZA TU VIAJE') }}</a>
        </div>
    </div>
</section>

<section class="padding-60 highlight-bg">
    <div class="container">
        <table class="table-highlight">
            <caption>
                <h2 class="title">
                    {{ aiTrans('Ventajas clave en [website_title]', $locale, ['website_title' => $website_title]) }}
                </h2>
            </caption>
            <tbody id="emojtable">
                <tr>
                    <td>{{ aiTrans('🤖 Costo de inscripción') }}</td>
                    <td>{{ aiTrans('Ninguno') }}</td>
                </tr>
                <tr>
                    <td>{{ aiTrans('💰 Cargos adicionales') }}</td>
                    <td>{{ aiTrans('Ninguno') }}</td>
                </tr>
                <tr>
                    <td>{{ aiTrans('📋 Simplicidad de inscripción') }}</td>
                    <td>{{ aiTrans('Rápida y sencilla') }}</td>
                </tr>
                <tr>
                    <td>{{ aiTrans('📊 Orientación educativa') }}</td>
                    <td>{{ aiTrans('Blockchain, Mercados de acciones, Ingresos fijos y Estrategias de inversión completas') }}
                    </td>
                </tr>
                <tr>
                    <td>{{ aiTrans('🌎 Acceso') }}</td>
                    <td>{{ aiTrans('Disponible a nivel mundial, con algunas excepciones') }}</td>
                </tr>
            </tbody>
        </table>
    </div>
</section>
@endsection
