@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title - Conditions d’utilisation" }}</title>
    <meta name="description" content="{{ "Explorez vos obligations et droits pour une navigation sûre et efficace grâce à $website_title Soyez informés, prudents et intelligents." }}" />
@endpush

@section('content')
    <div class="container page-inner pt-5">
        <h1>{{ aiTrans('Conditions d’utilisation') }}</h1>
        <main>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Le fournisseur (la “Société“, “nous“, “notre“ ou “nos“) fournit indirectement via son logiciel et son site Web désigné (le “Site Web“) certains services de marketing, de publicité, de promotion et de services connexes (le “Service“; les utilisateurs du Service seront appelés les “Utilisateurs“, “vous“ ou “votre“). Ces Conditions d’utilisation (les “Conditions“) régissent l’accès et l’utilisation par les Utilisateurs du Site Web et des Services. Les Utilisateurs doivent accepter ces Conditions avant d’utiliser le Site Web.') }}</span>
            </p>
            <p><span style="font-weight: 400;">{{ aiTrans('Veuillez lire attentivement ces Conditions. Ces Conditions régissent votre accès au Site Web et votre utilisation des Services. En accédant, en vous inscrivant pour utiliser, en téléchargeant, en partageant ou en utilisant autrement le Site Web ou en utilisant tout script logiciel fourni par nous afin de rendre le Site Web disponible ou utilisable, vous signifiez votre accord à la fois avec ces Conditions et notre Politique de confidentialité, qui peuvent être modifiées ou autrement changées de temps à autre à notre seule discrétion. Votre utilisation continue du Site Web sera considérée comme une acceptation de toute condition modifiée ou mise à jour.') }}
                </span><span
                    style="font-weight: 400;">{{ aiTrans('Si vous n’acceptez pas l’une de ces Conditions, veuillez ne pas cliquer sur “ACCEPTER” et ne pas utiliser le Site Web.') }}</span>
            </p>
            <p><strong>{{ aiTrans('Site Web') }}</strong> {{ aiTrans('fait référence à [website_title], accessible depuis' ,$locale,['website_title' => $website_title]) }} <a
                    href="{{ route('home', $country) }}">{{$website_title}}</a></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li><a href="#1_Utilisation_du_site_web_et_des_services"><span class="toc_number toc_depth_2">0.1</span>
                                {{ aiTrans('1. Utilisation du Site Web et des Services') }}</a></li>
                    </ul>
                    <li><a href="#2_Restrictions"><span class="toc_number toc_depth_1">1</span>
                            {{ aiTrans('2. Restrictions') }}</a></li>
                    <li><a href="#3_Matériaux_promotionnels_et_bulletins"><span class="toc_number toc_depth_1">2</span>
                            {{ aiTrans('3. Matériaux promotionnels et bulletins') }}</a></li>
                    <li><a href="#4_Propriété_intellectuelle"><span class="toc_number toc_depth_1">3</span>
                            {{ aiTrans('4. Propriété intellectuelle') }}</a></li>
                    <li><a href="#5_Vie_privée"><span class="toc_number toc_depth_1">4</span> {{ aiTrans('5. Vie privée') }}</a>
                    </li>
                    <li><a href="#6_Liens"><span class="toc_number toc_depth_1">5</span> {{ aiTrans('6. Liens') }}</a></li>
                    <li><a href="#7_Utilisations_interdites"><span class="toc_number toc_depth_1">6</span>
                            {{ aiTrans('7. Utilisations interdites') }}</a></li>
                    <li><a href="#8_Soutien"><span class="toc_number toc_depth_1">7</span> {{ aiTrans('8. Soutien') }}</a>
                    </li>
                    <li><a href="#9_Avis_de_non-responsabilité"><span class="toc_number toc_depth_1">8</span>
                            {{ aiTrans('9. Avis de non-responsabilité') }}</a></li>
                    <li><a href="#10_Limitation_de_responsabilité"><span class="toc_number toc_depth_1">9</span>
                            {{ aiTrans('10. Limitation de responsabilité') }}</a></li>
                    <li><a href="#11_Indemnisation"><span class="toc_number toc_depth_1">10</span>
                            {{ aiTrans('11. Indemnisation') }}</a></li>
                    <li><a href="#12_Divers"><span class="toc_number toc_depth_1">11</span>
                            {{ aiTrans('12. Divers') }}</a></li>
                </ul>
            </div>
            <h5><span id="1_Utilisation_du_site_web_et_des_services"><b>{{ aiTrans('1. Utilisation du Site Web et des Services') }}</b></span></h5>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Sous réserve des termes et conditions énoncés dans les présentes, vous pouvez accéder et utiliser le Site Web dans le but d’utiliser les Services sur une base non exclusive. Vous reconnaissez que la Société peut, à sa seule discrétion et à tout moment, modifier, mettre à jour ou autrement changer le Site Web ou les Services, y compris cesser de fournir une partie ou la totalité du Site Web et/ou des Services ou modifier ou supprimer tout contenu disponible via le Site Web ou les Services, sans préavis.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('L’utilisation du Site Web et des Services est nulle là où elle est interdite. En utilisant le Site Web et les Services, vous déclarez et garantissez que : (a) toute information que vous soumettez (le cas échéant) est véridique et précise ; (b) vous maintiendrez l’exactitude de ces informations ; (c) vous avez au moins l’âge de la majorité dans votre juridiction ; et (d) votre utilisation du Site Web ou des Services ne viole pas ou ne promeut pas la violation de toute loi ou réglementation applicable ou de toute obligation légale ou contractuelle que vous pourriez avoir envers un tiers et vous avez et respecterez à tout moment toutes les lois, règles et règlements applicables en lien avec votre utilisation des Services et du Site Web, tous les services organisés via les Services et le Site Web, y compris sans limitation les services connectés de quelque manière que ce soit aux Produits ou aux Tiers, tels que ces termes sont définis ici.') }}</span>
            </p>
            <p><span style="font-weight: 400;">{{ aiTrans('Les sous-sections (a) à (d) seront appelées, conjointement, les') }}
                </span><b>{{ aiTrans('“Engagements et Garanties des Utilisateurs“') }}</b><span style="font-weight: 400;">.</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('En utilisant les Services ou le Site Web, vous comprenez et acceptez que la Société puisse, à sa seule discrétion, mais n’est pas tenue de, vérifier que l’un ou l’autre des Engagements et Garanties des Utilisateurs est respecté par tout Utilisateur et vous acceptez en outre que la Société n’est pas responsable d’assurer que les Engagements et Garanties des Utilisateurs sont respectés ou pour tout échec à suspendre, résilier ou empêcher l’utilisation des Services ou du Site Web par des Utilisateurs qui ne respectent pas les Engagements et Garanties des Utilisateurs. Vous comprenez que vous êtes seul responsable de vos propres évaluations, décisions et appréciations concernant l’engagement auprès de tout Tiers ou d’interagir de quelque manière que ce soit avec des Tiers. Si vous prenez connaissance de toute violation des Engagements et Garanties des Utilisateurs, vous êtes encouragé à le signaler à la Société.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('La Société se réserve le droit de ne pas vous fournir de Services avec ou sans préavis à sa seule discrétion, qu’elle prenne connaissance d’une violation des Engagements et Garanties des Utilisateurs (soit par des rapports fournis par d’autres Utilisateurs ou par d’autres moyens) par vous ou tout autre Utilisateur, ou pour toute autre raison. Sans préjudice de ce qui précède, la Société décline expressément, et vous déchargez expressément la Société de, toute responsabilité pour toute controverse, réclamation, poursuite, blessure, perte, dommage et/ou préjudice découlant de et/ou en lien avec : (i) toute inexactitude, inopportunité ou incomplétude des déclarations d’un Utilisateur ou d’un Tiers ; et (ii) des fausses déclarations et/ou des déclarations erronées faites, soit en lien avec, soit par l’intermédiaire de l’un des Tiers ou d’autres Utilisateurs, Produits ou autrement. En utilisant le Site Web et les Services, vous comprenez et acceptez que les Services offrent simplement une plateforme désignée pour aider les Utilisateurs à atteindre, acheter et/ou utiliser divers produits et services fournis par des vendeurs tiers et/ou des prestataires de services, par le biais des annonces ou des promotions que nous exécutons (respectivement, les “Produits” et les “Tiers“, respectivement).') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Vous comprenez et acceptez que la Société : (a) n’emploie, ne recommande ni n’endosse aucun Tiers ou Produit, selon le cas, ni aucune partie liée, et n’a aucun contrôle sur les actes ou omissions de tout Tiers, de son entreprise, de ses produits ou services ; (b) ne fait aucune déclaration ni garantie concernant les Tiers et les Produits, y compris leur qualité, leur prix, leur compatibilité, leur disponibilité ou toute autre caractéristique, ou concernant vos interactions ou relations avec des Tiers ; (c) ne fait aucune déclaration ni garantie concernant les droits de propriété ou d’autres droits ou caractéristiques ou aspects réglementaires liés aux Produits, y compris toute autorisation, permis ou licence requis pour le téléchargement, le partage ou autrement la mise à disposition, et pour l’utilisation, la vente et l’achat de tels Produits ; et (d) n’est pas responsable de la performance ou du comportement d’aucun Utilisateur ou d’autres tiers de quelque manière que ce soit en utilisant ou ayant utilisé les Services, et/ou sur ou en dehors du Site Web. La Société n’est pas tenue de filtrer ou de vérifier d’une autre manière toute information concernant les Tiers et/ou les Utilisateurs, les Produits ou toute autre caractéristique liée au Site Web ou aux Services et par conséquent, vous devez faire preuve de prudence et effectuer vos propres examens et vérifications avant de vous engager auprès de quiconque par le biais des Services ou du Site Web ou d’interagir autrement avec quiconque.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('La Société décline expressément, et vous déchargez expressément la Société de, toute responsabilité pour toute controverse, réclamation, poursuite, blessure, perte, dommage et/ou préjudice découlant de et/ou en lien avec les Tiers, Produits, Services et Site Web ou vos interactions ou relations avec des Tiers, y compris sans limitation tous les actes et/ou omissions des Tiers en lien avec ou connectés aux Services ou au Site Web de quelque manière que ce soit. En utilisant les Services ou le Site Web, vous reconnaissez que vous êtes seul responsable de cette utilisation et des connexions, interactions, achats ou toute autre action que vous effectuez et que toute utilisation des Services ou du Site Web se fait à vos propres risques. Pour éviter tout doute, la Société ne vend, ne loue ni autrement ne met à votre disposition des Produits ou services (autres que les Services) et n’aura aucune responsabilité pour les Produits ou services achetés par vous auprès d’un Tiers, y compris sans limitation, en ce qui concerne tout soutien et maintenance, défauts, erreurs, pannes, dommages ou coûts de toute nature.') }}</span>
            </p>
            <h4><span id="2_Restrictions"><span style="font-weight: 400;">{{ aiTrans('2. Restrictions') }}</span></span>
            </h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Sans préjudice des dispositions de la Section 1 ci-dessus, vous ne devez pas, et ne devez pas permettre à un tiers, de : (a) décompiler ou tenter de trouver le code sous-jacent du Site Web ou des Services ; (b) utiliser le Site Web ou les Services en violation de toute loi ou réglementation applicable, y compris mais sans s’y limiter, publier, partager ou autrement transférer tout matériel illégal ou offensant ; (c) copier, modifier ou créer des œuvres dérivées du Site Web, des Services ou du contenu de l’un des Site Web ou Services ; (d) tenter de désactiver ou de contourner tout mécanisme de sécurité ou de contrôle d’accès du Site Web ou des Services ; (e) concevoir ou aider à concevoir des cheats, exploits, logiciels d’automatisation, bots, hacks, modes ou tout autre logiciel non autorisé de tiers pour modifier ou interférer avec le Site Web ou les Services ; (f) utiliser le Site Web ou les Services ou interagir avec d’autres Utilisateurs à des fins qui violent toute loi ou réglementation applicable ; (g) tenter d’accéder sans autorisation au Site Web ou aux Services, aux comptes d’autres Utilisateurs, tel que défini ci-dessous, ou à d’autres dispositifs, systèmes informatiques, systèmes téléphoniques, ou réseaux connectés au Site Web ou aux Services ; et (h) recueillir ou autrement collecter des informations sur des Utilisateurs sans leur consentement.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Si vous publiez, partagez ou transférez autrement via le Site Web et/ou en utilisant les Services tout contenu, vous déclarez et garantissez que ce contenu fournit une image précise et complète de tous les produits ou services décrits, respecte ces Conditions ici, et ne : (a) enfreint pas la propriété intellectuelle, les droits moraux ou de publicité d’un tiers ; (b) ne contient pas de contenu diffamatoire, calomnieux, obscène, sexuellement suggestif ou autrement offensant (y compris le matériel promouvant ou glorifiant la haine, la violence ou le sectarisme) ; (c) ne contient pas de vers, virus ou autre logiciel malveillant ; (d) ne viole pas toute loi ou réglementation applicable, y compris toute loi ou réglementation concernant la publicité ou le marketing ; et (e) ne prend pas de mesures qui imposent une charge déraisonnable ou disproportionnée sur notre infrastructure.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('En publiant, téléchargeant, partageant ou transférant autrement tout contenu en utilisant le Site Web ou les Services, vous accordez par la présente à la Société et à ses filiales et/ou sous-licenciés une licence mondiale, non exclusive, perpétuelle, libre de redevances pour publier, partager, afficher et transférer autrement ce contenu sous toute forme raisonnable que la Société jugera à sa seule discrétion. La Société se réserve le droit de supprimer, suspendre l’accès ou supprimer définitivement tout contenu conformément à sa seule discrétion sans préavis, y compris sans limitation tout contenu qui viole les garanties énoncées ci-dessus ou les intérêts commerciaux de la Société, et vous n’aurez aucun droit ou revendication à cet égard.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('La Société n’est pas, et ne sera pas, responsable de tout contenu fourni, publié, téléchargé, partagé ou rendu disponible par des Utilisateurs, de tout produit ou service lié à ce contenu fourni, publié, téléchargé, partagé ou rendu disponible par des Utilisateurs. Chaque Utilisateur utilisant le Site Web ou les Services déclare par la présente assumer l’entière responsabilité à cet égard, et la Société ne supportera aucune responsabilité à cet égard.') }}</span>
            </p>
            <h4><span id="3_Matériaux_promotionnels_et_bulletins"><span
                        style="font-weight: 400;">{{ aiTrans('3. Matériaux promotionnels et bulletins') }}</span></span>
            </h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('En plus des dispositions de la Section 3 ci-dessus, l’Utilisateur donne son consentement explicite à la Société pour fournir à l’Utilisateur des matériaux promotionnels et des bulletins (les “Matériaux promotionnels et bulletins“) par tout moyen disponible, y compris par e-mail, SMS et messages texte, fax, courrier, services de numérotation automatique ou tout autre moyen, tout cela conformément à la seule discrétion de la Société tel qu’il sera de temps à autre, et de recevoir ces Matériaux promotionnels et bulletins.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('L’Utilisateur reconnaît en outre que les Matériaux promotionnels et bulletins peuvent inclure des publicités de tiers, et il consent explicitement à la réception de telles publicités dans le cadre des Matériaux promotionnels et bulletins. L’Utilisateur peut contacter la Société à tout moment en envoyant une demande par e-mail notifiant la Société de son refus de recevoir davantage les Matériaux promotionnels et bulletins.') }}</span>
            </p>
            <h4><span id="4_Propriété_intellectuelle"><span
                        style="font-weight: 400;">{{ aiTrans('4. Propriété intellectuelle') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('La Société est propriétaire de tous les droits, titres et intérêts dans le monde entier : (a) le Site Web et les Services, les améliorations, dérivés, corrections de bogues ou améliorations du Site Web et des Services ; et (b) les noms commerciaux, marques de commerce et logos de la Société, qui resteront à tout moment uniquement à la Société. Toutes les références dans ces Conditions ou toute autre communication à la vente, la revente ou l’achat de ce qui précède signifieront uniquement le droit d’utiliser le Site Web et les Services conformément à ces Conditions. Les Utilisateurs assument la pleine responsabilité de tout contenu, y compris tous les droits de propriété intellectuelle, fourni, partagé ou rendu disponible par les Utilisateurs utilisant le Site Web et/ou les Services, et la Société ne fait aucune déclaration à cet égard. La Société ne sera pas responsable des pertes ou dommages encourus par ce contenu, et les Utilisateurs acceptent d’indemniser et de dégager la Société de toute responsabilité pour tout dommage ou perte découlant de ce qui précède.') }}</span>
            </p>
            <h4><span id="5_Vie_privée"><span style="font-weight: 400;">{{ aiTrans('5. Vie privée') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Vous vous engagez à ne pas sauvegarder, collecter ou maintenir autrement en votre possession et à utiliser tout contenu fourni par les Services et le Site Web sans le consentement écrit préalable de la Société. Vous reconnaissez en outre que la Société se réserve le droit, à sa seule discrétion, de sauvegarder, collecter ou maintenir autrement en sa possession et d’utiliser tout contenu et information publique, y compris les informations qui pourraient vous identifier personnellement ou identifier tout autre Utilisateur ou Tiers ou décrire vos intérêts personnels. La Société se réserve le droit de faire tout usage autorisé en vertu de toute loi applicable de ce contenu et de ces informations publiques tel qu’il est énoncé dans la Politique de confidentialité de la Société. Sans préjudice des dispositions de la Section 1 ci-dessus, la Société ne révise, ne teste, ne confirme, n’approuve ni ne vérifie autrement tout contenu ou information publique. Chaque Utilisateur publiant, téléchargeant, partageant ou rendant disponible ce contenu ou cette information publique assumera l’entière responsabilité de ce contenu ou de cette information publique, y compris toutes les informations de tiers et les consentements requis. La Société ne sera pas responsable de toute perte ou dommage encourus en ne se conformant pas à ce qui précède, et vous acceptez d’indemniser et de dégager la Société de toute responsabilité pour tout dommage ou perte découlant de ce qui précède. NONOBSTANT CE QUI PRÉCÈDE, VOUS COMPRENEZ ET RECONNAISSEZ QUE LA SOCIÉTÉ N’EST PAS UN SERVICE DE STOCKAGE DE CONTENU. LA SOCIÉTÉ N’AURA AUCUNE RESPONSABILITÉ POUR TOUT CONTENU OU INFORMATION PUBLIQUE PERDUE OU SUPPRIMÉE. VOUS DEVEZ ÊTRE CONSCIENT QUE TOUT CONTENU PUBLIÉ, TÉLÉCHARGÉ, PARTAGÉ OU autrement rendu disponible PEUT ÊTRE LU, COLLECTÉ ET UTILISÉ PAR D’AUTRES UTILISATEURS, ET POURRAIT ÊTRE UTILISÉ POUR ENVOYER DU CONTENU NON SOLICITÉ.') }}</span>
            </p>
            <h4><span id="6_Liens"><span style="font-weight: 400;">{{ aiTrans('6. Liens') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Le Site Web ou les Services peuvent contenir des liens ou d’autres contenus liés à des sites Web, annonceurs, éditeurs ou Produits proposés par des tiers. La Société n’a aucun contrôle et ne fait aucune déclaration à cet égard ou concernant les informations fournies ou transmises par ceux-ci, ou autrement fournies par un tel tiers. VOUS COMPRENEZ ET ACCEPTEZ QUE L’UTILISATION DE CES LIENS OU D’AUTRES CONTENUS EST À VOS PROPRES RISQUES, QUE CES LIENS OU AUTRES CONTENUS SONT RÉGIS PAR LES CONDITIONS D’UTILISATION ET POLITIQUES DE CONFIDENTIALITÉ DE CES TIERS, ET QUE LA SOCIÉTÉ N’EST PAS RESPONSABLE DES PRATIQUES EN MATIÈRE DE CONFIDENTIALITÉ OU DES PRATIQUES COMMERCIALES OU D’AUTRES POLITIQUES DE CES TIERS. VOUS DEVEZ EXAMINER ATTENTIVEMENT LES CONDITIONS ET POLITIQUES APPLICABLES QUI S’APPLIQUENT À TOUT CE TIERS. LA SOCIÉTÉ N’EST PAS RESPONSABLE OU LIABLE EN AUCUNE MANIÈRE ENVERS CE TIERS, NI POUR TOUTE PERTE OU DOMMAGE DE QUELQUE NATURE QUE CE SOIT ENCOURUE EN RAISON DE CE QUI PRÉCEDE, ET LA SOCIÉTÉ DÉCLINE EXPRESSÉMENT, ET VOUS LIBÉREZ EXPRESSÉMENT LA SOCIÉTÉ DE, TOUTE RESPONSABILITÉ QUELCONQUE POUR TOUTES CONTROVERSES, RÉCLAMATIONS, POURSUITES, BLESSURES, PERTES, DOMMAGES ET/OU PRÉJUDICES, DÉCOULANT DE ET/OU EN TOUTE FAÇON LIÉS À CE TIERS, Y COMPRIS SANS LIMITATION EN CE QUI CONCERNE LA DISPONIBILITÉ, LES CONDITIONS D’UTILISATION, LA CONFIDENTIALITÉ, LES INFORMATIONS, LE CONTENU, LES MATÉRIAUX, LA PUBLICITÉ, LES FRAIS, LES PRODUITS ET/OU SERVICES.') }}</span>
            </p>
            <h4><span id="7_Utilisations_interdites"><span
                        style="font-weight: 400;">{{ aiTrans('7. Utilisations interdites') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Le Site Web et les Services ne peuvent pas être utilisés en rapport avec des efforts commerciaux (sauf autorisation contraire de la Société en ce qui concerne la mise en relation des Utilisateurs avec des Tiers) sans le consentement écrit explicite de la Société. Le Site Web et les Services ne peuvent pas être utilisés par quiconque ou par une organisation pour recruter pour un autre site Web, solliciter, faire de la publicité ou contacter sous une forme quelconque des Utilisateurs pour un emploi, un contrat ou toute autre raison pour une entreprise non affiliée à la Société sans autorisation écrite explicite de la Société. Vous acceptez de ne pas utiliser les Services et le Site Web pour contacter, faire de la publicité, solliciter ou vendre à tout autre Utilisateur sans leur consentement explicite, sauf autorisation contraire dans ces Conditions.') }}</span>
            </p>
            <h4><span id="8_Soutien"><span style="font-weight: 400;">{{ aiTrans('8. Soutien') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Les Utilisateurs peuvent contacter la Société concernant le soutien pour le Site Web et les Services en envoyant un e-mail') }}</span>
            </p>
            <h4><span id="9_Avis_de_non-responsabilité"><span style="font-weight: 400;">{{ aiTrans('9. Avis de non-responsabilité') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('La Société fait des efforts raisonnables pour s’assurer que sa technologie maintient le Site Web et les Services sûrs et sécurisés. Cependant, aucune technologie n’est 100 % sécurisée. Par conséquent, bien que nous nous efforçons d’utiliser des moyens commercialement acceptables pour protéger vos informations personnelles, nous ne pouvons garantir leur sécurité absolue. Sauf disposition expresse dans les présentes, votre utilisation du Site Web et des Services se fait à votre seule discrétion et à vos risques. Le Site Web et les Services sont fournis sur une base “EN L’ÉTAT” et “SELON LA DISPONIBILITÉ” sans garanties d’aucune sorte. La Société décline expressément toutes les garanties implicites ou statutaires de toute nature concernant le Site Web et les Services, y compris sans limitation les garanties de titre, de qualité marchande, d’adéquation à un usage particulier, de non-contrefaçon des droits de propriété, de cours de négociation ou de performance. La Société ne donne aucun conseil concernant le risque ou l’adéquation de toute transaction, échange ou engagement. La Société n’assume aucune responsabilité pour toute transaction ou engagement effectué par vous et vous reconnaissez que vous êtes seul responsable de l’évaluation de vos transactions et engagements. Vous ne devez pas tenir la Société, ses dirigeants, employés ou affiliés responsables des choix de transaction ou d’engagement effectués par vous. Aucun conseil ou information, qu’il soit oral ou écrit, obtenu par vous de la Société ou de ses dirigeants, employés ou affiliés, ne créera de garantie non expressément énoncée dans ces Conditions. Si vous choisissez de vous fier à ces informations, vous le faites uniquement à vos propres risques. Certains États ou juridictions ne permettent pas l’exclusion de certaines garanties. En conséquence, certaines des exclusions ci-dessus peuvent ne pas s’appliquer à vous.') }}</span>
            </p>
            <h4><span id="10_Limitation_de_responsabilité"><span
                        style="font-weight: 400;">{{ aiTrans('10. Limitation de responsabilité') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('La Société ne garantit pas la valeur, la qualité, la compatibilité ou toute autre caractéristique des Tiers, Produits ou toute autre information fournie, consommée ou autrement mise à disposition (ci-après dans cette Section : les “Fonctionnalités“). Toute Fonctionnalité est sous la seule responsabilité du Tiers ou de l’Utilisateur applicable qui l’utilise, selon le cas, ou utilise les Services ou le Site Web. La Société ne s’engage pas à surveiller cette conformité et peut agir lorsque la non-conformité est détectée, comme décidé à sa seule discrétion, comme décrit dans ces Conditions. Vous comprenez et acceptez que vous pourriez être exposé à du contenu ou d’autres informations qui sont inexactes, répréhensibles, inappropriées pour les enfants ou autrement inadaptées à vous.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('La Société n’est pas responsable de tout problème ou dysfonctionnement technique de tout réseau téléphonique ou lignes, systèmes informatiques en ligne, serveurs ou fournisseurs, équipement informatique, logiciel, défaillance de tout e-mail en raison de problèmes techniques ou de congestion de trafic sur Internet ou sur le Site Web ou les Services ou une combinaison de ceux-ci, y compris toute blessure ou dommage aux Utilisateurs ou à l’ordinateur de toute personne, téléphone mobile ou tout autre dispositif lié ou résultant de la participation ou du téléchargement de matériel en lien avec le Site Web ou les Services. En aucune circonstance, la Société ne sera responsable du comportement de tiers, y compris de tout Utilisateur, qu’il soit en ligne ou hors ligne, et des opérateurs de sites externes.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('En aucun cas, la Société ou l’un de ses dirigeants, directeurs, employés ou agents ne pourra être tenu responsable envers vous pour tout dommage indirect, accessoire, spécial, punitif ou consécutif, découlant de ou en rapport avec votre utilisation du Site Web ou des Services, que les dommages soient prévisibles ou non et que la Société ait été avisée ou non de la possibilité de tels dommages. La limitation de responsabilité ci-dessus s’applique dans toute la mesure permise par la loi dans la juridiction applicable.') }}</span>
            </p>
            <h4><span id="11_Indemnisation"><span
                        style="font-weight: 400;">{{ aiTrans('11. Indemnisation') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Vous défendrez, indemniserez et dégagerez la Société de toute responsabilité contre toute poursuite, procédure, assertion, dommage, coût, responsabilité ou dépense (y compris les frais judiciaires et les honoraires raisonnables d’avocat) que la Société pourrait subir ou encourir en lien avec toute réclamation, demande, action ou autre procédure par un tiers découlant ou se rapportant à toute violation de ces Conditions par vous ou toute utilisation par vous du Site Web ou des Services non conforme à la loi applicable.') }}</span>
            </p>
            <h4><span id="12_Divers"><span
                        style="font-weight: 400;">{{ aiTrans('12. Divers') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Ces Conditions seront régies par les lois de l’Angleterre, à l’exclusion de ses règles de choix de loi, et sans égard à la Convention des Nations Unies sur les ventes internationales de marchandises. Votre conduite peut également être soumise à d’autres lois locales, nationales et nationales. Tout litige découlant de ces Conditions ou concernant le Site Web ou le Service sera finalement réglé par les tribunaux compétents de l’Angleterre. Vous ne pouvez pas présenter de réclamations en action collective contre la Société, et en utilisant le Site Web ou les Services, vous acceptez de renoncer à vos droits de présenter de telles réclamations en action collective.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Tout recours contre la Société doit être intenté dans un délai d’un (1) an à compter de la date à laquelle un tel recours est né. Dans le cas où une disposition de ces Conditions est jugée inapplicable, cette disposition sera remplacée par une disposition applicable qui atteint le plus étroitement l’effet de la disposition d’origine, et les termes restants de ces Conditions resteront en vigueur et en vigueur. Rien dans ces Conditions ne crée d’agence, d’emploi, de coentreprise ou de partenariat entre vous et la Société ni ne vous autorise à agir au nom de la Société. Sauf mention expresse dans ces Conditions, ces Conditions constituent l’intégralité de l’accord entre la Société et vous concernant l’objet des présentes.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Tout avis que nous pourrions être tenus de vous fournir, que ce soit en vertu de la loi ou selon ces Conditions, pourra être fourni par la Société à toute information de contact que vous avez fournie dans vos informations de compte ou autres, directement ou indirectement, y compris par e-mail. Vous acceptez expressément de recevoir de telles communications et avis de cette manière.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('Vous ne pouvez pas céder de droits en vertu des présentes sans notre consentement écrit préalable. Rien dans ces Conditions ne doit être interprété comme limitant les actions ou les recours disponibles à la Société concernant toute activité ou comportement interdit. La non-application de toute disposition de ces Conditions ne constitue pas un consentement ou une renonciation, et la Société se réserve le droit d’appliquer cette disposition à sa seule discrétion. Aucune renonciation à une violation ou à un manquement aux présentes ne sera considérée comme une renonciation à toute violation ou manquement antérieur ou ultérieur.') }}</span>
            </p>
            <p> </p>
        </main>
    </div>
@endsection
