@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title $website_name | Platform Tepercaya Ini untuk Perdagangan Cryptocurrency" }}</title>
    <meta name="description" content="{{ "Lihat bagaimana $website_title membantu menyempurnakan strategi investasi kripto Anda. Platform kami menawarkan solusi trading lengkap dan alat tercanggih." }}" />
@endpush
@section('content')
    <section class="hero wf-section">
        <div class="container w-container">
            <h1 class="hero-title">{{ $website_title }}</h1>
            <div class="hero-description">
                <span class="change-by-command">{{ "$website_title Cari Kesempatan di Pasar Kripto yang Belum Terjamah Saat Ini!" }}</span>
                <br>
               <span class="change-by-command">{{ "$website_title adalah platform perdagangan cryptocurrency terbaru dan cara termudah untuk menginvestasikan uang Anda." }}</span>
                </div>
            <div class="main-cols">
                <div class="video-col"><img src="{{ asset('frontend/assets/id/dist') }}/images/poster_index.webp"
                        sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw"
                        alt="{{ $website_title }} - {{ $website_title }}" width="877" height="521" style="height: auto"
                        class="main-image"></div>
                <div class="form-col">
                    <div class="blurred-bg form-container">
                        <div class="form-title">{{aiTrans('DAFTAR UNTUK AKUN GRATIS ANDA')}}</div>
                        <div id="formTop" class="form-box w-form-wrapper">

                            @include('frontend.id.components.form')

                            <div class="w-form-done">
                                <div>{{aiTrans('Thank you! Your submission has been received!')}}</div>
                            </div>
                            <div class="w-form-fail">
                                <div>{{aiTrans('Oops! Something went wrong while submitting the form.')}}</div>
                            </div>
                        </div>
                    </div>
                    <img loading="lazy" src="{{ asset('frontend/assets/id/dist') }}/images/hmp-signup-float_coin.webp"
                        alt="{{ $website_title }} - {{ $website_title }}" class="signup-float-coin">
                </div>
            </div>
        </div>
    </section>
    <section class="trade w-clearfix wf-section"><img loading="lazy"
            src="{{ asset('frontend/assets/id/dist') }}/images/trade-img.webp"
            sizes="(max-width: 991px) 100vw, (max-width: 2234px) 55vw, 1229px"
            alt="{{ $website_title }} - Analisis Mata Uang Kripto" class="trade-img">
        <div class="container w-container">
            <h2 class="trade-title">
                {{ aiTrans(
                    'Temukan Aplikasi [website_title] Revolusioner dan Nikmati Manfaatnya yang Tak Terhingga',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </h2>
            <div class="blurred-bg trade-item">
                <img loading="lazy" src="{{ asset('frontend/assets/id/dist') }}/images/trade-icon1.webp"
                    alt="{{ $website_title }} - {{aiTrans('Analisis Mata Uang Kripto')}}" class="trade-item-icon">
                <h3 class="trade-item-title">{{aiTrans('Analisis Mata Uang Kripto')}}</h3>
                <div class="trade-item-text">
                    {{ aiTrans(
                        'Mencapai kesuksesan dalam perdagangan aset digital memerlukan pengambilan
                        keputusan yang tepat. Dengan memilih platform [website_title], Anda mendapatkan akses ke teknologi
                        canggih seperti analisis algoritmik dan kecerdasan buatan. Alat canggih ini memungkinkan Anda
                        melakukan analisis pasar yang komprehensif dan membuat pilihan perdagangan yang cerdas. Solusi
                        [website_title] melampaui pemindaian pasar sederhana dengan mempertimbangkan berbagai faktor,
                        termasuk tren pasar, pergerakan harga, data historis, indikator fundamental, dan banyak lagi. Ini
                        dengan mudah menggabungkan kekayaan informasi ini ke dalam laporan evaluasi pasar yang komprehensif,
                        yang dapat Anda gunakan saat melakukan perdagangan Anda. Dengan perangkat lunak [website_title]
                        yang
                        rajin memantau berbagai mata uang kripto setiap hari, Anda dapat dengan percaya diri mengandalkan
                        data yang akurat dan terkini untuk melakukan perdagangan yang menguntungkan. Baik Anda seorang
                        pemula atau trader berpengalaman, teknologi canggih ini akan memastikan Anda tetap menjadi yang
                        terdepan dalam pasar dan menjadi trader yang lebih efisien, bahkan jika Anda tidak memiliki
                        pengalaman sebelumnya dalam perdagangan mata uang kripto.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </div>
            </div>
            <div class="blurred-bg trade-item">
                <img loading="lazy" src="{{ asset('frontend/assets/id/dist') }}/images/trade-icon2.webp"
                    alt="{{ $website_title }} - {{aiTrans('KUSTOMISASI OTONOMI')}}" class="trade-item-icon">
                <h3 class="trade-item-title">{{aiTrans('KUSTOMISASI OTONOMI')}}</h3>
                <div class="trade-item-text">
                    {{ aiTrans(
                        'Rasakan kesederhanaan perdagangan mata uang kripto dengan
                        [website_title]. Aplikasi kami menggunakan teknologi canggih untuk analisis dan riset pasar, sekaligus memberikan
                        opsi fleksibel untuk menyesuaikan level perdagangan Anda. Kendalikan pengalaman trading Anda dengan
                        menyesuaikan pengaturan otonomi dan dukungan dengan mudah. Berdayakan diri Anda untuk meraih peluang
                        dalam Bitcoin dan mata uang kripto lainnya, apa pun pengalaman atau tujuan Anda. Bergabunglah dengan
                        kami hari ini dan berdagang dengan percaya diri dengan pilihan yang lebih cerdas!',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </div>
            </div>
            <div class="blurred-bg trade-item">
                <img loading="lazy" src="{{ asset('frontend/assets/id/dist') }}/images/trade-icon3.webp"
                    alt="{{ $website_title }} - {{aiTrans('TINDAKAN KEAMANAN LANJUTAN')}}" class="trade-item-icon">
                <h3 class="trade-item-title">{{aiTrans('TINDAKAN KEAMANAN LANJUTAN')}}</h3>
                <div class="trade-item-text">
                    {{ aiTrans(
                        'Di [website_title], kami mengutamakan keamanan aset dan data Anda. Kami
                        berkomitmen untuk melindungi dana semua pengguna kami saat mereka berdagang di platform kami. Tim
                        keamanan siber kami telah menerapkan protokol dan mekanisme keamanan canggih untuk memastikan
                        komunikasi antara browser Anda dan server kami aman saat mendaftar. Selain itu, kami menggunakan
                        teknologi keamanan mutakhir untuk memberi Anda kepercayaan penuh saat menggunakan aplikasi [website_title]
                        . Tenang saja mengetahui bahwa data pribadi Anda aman bersama kami.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </div>
            </div>
        </div>
    </section>
    <section class="machine wf-section">
        <div class="container w-container">
            <div class="w-row">
                <div class="w-col w-col-6 w-col-stack">
                    <h2 class="machine-title">{{aiTrans('SIAP MEMULAI PERDAGANGAN? AKSES AKUN PREMIUM ANDA SEKARANG')}}</h2>
                </div>
                <div class="w-col w-col-6 w-col-stack">
                    <div class="machine-text">
                        {{ aiTrans(
                            'Berdagang di pasar mata uang kripto bisa jadi menakutkan, terutama bagi
                            pemula dan profesional berpengalaman. Di [website_title], kami memahami tantangan ini dan
                            telah mengembangkan aplikasi yang mudah digunakan untuk menyederhanakan proses perdagangan bagi
                            pedagang dari semua tingkat keahlian. Aplikasi kami menggunakan kecerdasan buatan dan algoritme
                            mutakhir untuk menganalisis pasar dan mempertimbangkan berbagai faktor yang memengaruhi harga
                            mata uang digital. Analisis ini memberi para pedagang wawasan berharga untuk membuat keputusan
                            perdagangan yang tepat. Dengan antarmuka intuitif yang dapat diakses di ponsel cerdas, tablet,
                            dan komputer, aplikasi kami memandu Anda dengan analisis yang dapat ditindaklanjuti dan
                            berdasarkan data, memungkinkan Anda berdagang dengan percaya diri baik saat bepergian, belajar,
                            atau bersantai di kafe. Selain itu, aplikasi kami memitigasi risiko perdagangan dengan
                            melindungi dari volatilitas pasar, berkat data real-time di dalam aplikasi.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                    <div class="machine-action_button_wrapper">
                        <a href="#formTop" class="button anchor-js w-button">{{aiTrans('MULAI GRATIS SEKARANG')}}</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="no-scam w-clearfix wf-section"><img loading="lazy"
            src="{{ asset('frontend/assets/id/dist') }}/images/no-scam-img1.webp"
            sizes="(max-width: 991px) 100vw, (max-width: 2220px) 50vw, 1110px"
            alt="{{ $website_title }} - {{aiTrans('perdagangan')}} {{ $website_title }}" class="img-float-left max-width-50-percent">
        <div class="container w-container">
            <h2 class="no_scam-title margin-top-175">{{aiTrans('perdagangan')}} {{ $website_title }}</h2>
            <div class="no_scam-text">
                {{ aiTrans(
                    'Industri mata uang kripto berkembang pesat, menarik investasi besar dari raksasa
                    keuangan dan bisnis. Setiap koin memiliki kualitas yang unik, dan kemajuan yang berkelanjutan
                    menjanjikan masa depan yang cerah bagi sektor yang sedang berkembang ini. Meskipun ada tantangan,
                    entitas terkenal seperti Tesla, BlackRock, Square, dan Galaxy Digital menunjukkan minat pada ruang
                    kripto. Lonjakan Bitcoin yang mengesankan di atas $20rb pada tahun 2021 menciptakan jutawan, sama
                    seperti yang terjadi ketika melampaui $10rb tiga tahun sebelumnya. Namun, pasar berfluktuasi, dan tanpa
                    pengetahuan manajemen risiko, trader dapat mengalami kerugian yang signifikan. Di situlah aplikasi
                    [website_title] berperan. Aplikasi kami dirancang untuk memitigasi risiko dan memanfaatkan peluang
                    bahkan selama penurunan pasar. Memahami cara memanfaatkan volatilitas pasar sangatlah penting, dan
                    aplikasi [website_title] memberdayakan pedagang untuk melakukan hal itu.',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </div>
        </div>
        <img loading="lazy" src="{{ asset('frontend/assets/id/dist') }}/images/no-scam-img2.webp"
            sizes="(max-width: 991px) 100vw, (max-width: 1938px) 60vw, 1163px"
            alt="{{ $website_title }} - perdagangan {{ $website_title }}" class="scam-item2-img">
        <div class="container w-container">
            <h2 class="no_scam-title2">{{aiTrans('Waktu Optimal untuk Berdagang Mata Uang Kripto menggunakan')}} {{ $website_title }}</h2>
            <div class="no_scam-text2">
                {{ aiTrans(
                    'Sangat. Meskipun harga Bitcoin baru-baru ini menurun, sejarah telah menunjukkan
                    bahwa mata uang kripto ini memiliki kemampuan untuk bangkit kembali dan mencapai level baru. Penurunan
                    yang lebih besar sering kali menyebabkan rebound yang lebih kuat. Periode-periode ini memberikan peluang
                    optimal bagi investor baru dan berpengalaman. Dengan [website_title], Anda akan memiliki akses ke
                    wawasan pasar berharga yang didukung oleh data, memungkinkan Anda membuat keputusan yang tepat dalam
                    situasi pasar apa pun. Selain itu, adopsi teknologi blockchain oleh lebih banyak bisnis memastikan umur
                    cryptocurrency yang panjang, menjadikannya peluang menarik bagi investor.',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </div>
            <div class="no_scam-action_button_wrapper">
                <a href="#formTop" class="button anchor-js w-button">{{aiTrans('DAFTAR SEKARANG UNTUK AKUN GRATIS ANDA')}}</a>
            </div>
        </div>
    </section>
    <section class="steps w-clearfix wf-section"><img loading="lazy"
            src="{{ asset('frontend/assets/id/dist') }}/images/steps-img.webp"
            sizes="(max-width: 991px) 100vw, (max-width: 2113px) 60vw, 1268px"
            alt="{{ $website_title }} - LANGKAH 1 BUAT AKUN {{ $website_title }} GRATIS ANDA" class="steps-img">
        <div class="container w-container">
            <h2 class="steps-title">
                {{ aiTrans(
                    'MULAI PERJALANAN TRADING ANDA DENGAN [website_title] YANG TAK TERTANDINGI',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </h2>
            <div class="blurred-bg steps-item">
                <div class="steps-item-number">1</div>
                <h3 class="steps-item-title">{{aiTrans('LANGKAH 1')}}<br> 
                    {{ aiTrans(
                        'BUAT AKUN [website_title] GRATIS ANDA',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </h3>
                <div class="steps-item-text">
                    {{ aiTrans(
                        'Mulailah perjalanan [website_title] Anda dengan menyelesaikan proses
                        pendaftaran di situs web resmi kami. Pendaftaran hanya memerlukan detail pribadi penting, seperti
                        nama lengkap, alamat email, alamat tempat tinggal, dan tempat tinggal Anda. Yakinlah, prosedur ini
                        dapat diselesaikan dengan cepat dalam hitungan menit. Untuk mengaktifkan akun [website_title]
                        Anda, cukup kirimkan formulir yang telah diisi dan ikuti tautan verifikasi yang diberikan ke alamat email
                        Anda. Nikmati kemudahan untuk memulai dengan aplikasi [website_title] gratis kami, karena
                        pembukaan akun tidak dikenakan biaya terkait.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </div>
            </div>
            <div class="blurred-bg steps-item">
                <div class="steps-item-number">2</div>
                <h3 class="steps-item-title">{{aiTrans('LANGKAH 2 - PEMBIAYAAN AKUN ANDA')}}</h3>
                <div class="steps-item-text">
                    {{ aiTrans(
                        'Setelah Anda berhasil mendaftarkan akun [website_title] Anda, sekarang
                        saatnya menambah dana Anda untuk perdagangan mata uang kripto yang lancar. Persyaratan setoran
                        minimum adalah £250 (atau mata uang setara). Yakinlah, [website_title] tidak membebankan biaya
                        deposit atau penarikan apa pun, dan Anda memiliki kendali penuh atas modal Anda setiap saat. Jangan
                        ragu untuk berdagang atau menarik keuntungan Anda tanpa komplikasi atau batasan apa pun.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </div>
            </div>
            <div class="blurred-bg steps-item">
                <div class="steps-item-number">3</div>
                <h3 class="steps-item-title">{{aiTrans('Langkah 3: Rangkullah Dunia Perdagangan Cryptocurrency dengan')}} {{ $website_title }}
                    </h3>
                <div class="steps-item-text">
                    {{ aiTrans(
                        'Bebaskan kekuatan penuh [website_title] dengan mengaktifkannya di
                        platform broker Anda. Aplikasi mutakhir ini terus memantau pasar dan menerapkan strategi canggih untuk
                        menilai pergerakan pasar. Jika Anda lebih suka perdagangan manual, nonaktifkan mode otomatis dengan
                        mudah. Mulailah memanfaatkan potensi keuntungan besar dengan [website_title] hari ini!',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </div>
            </div>
            <div class="steps-action_button_wrapper">
                <a href="#formTop" class="button anchor-js w-button">
                    {{ aiTrans(
                        'MULAI DENGAN [website_title] DAN SELAM KE DUNIA CRYPTOCURRENCIES HARI INI',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </a>
            </div>
        </div>
    </section>
    <section class="faq wf-section">
        <div class="container w-container">
            <h2 class="text-center">
                {{ aiTrans(
                    'PERTANYAAN UMUM TENTANG [website_title]',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </h2>
            <div class="faq-accordion">
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title active">
                        <h3 class="faq-accordion-title-tag">
                            {{ aiTrans(
                                'Apa saja prasyarat untuk memulai perdagangan mata uang kripto dengan aplikasi [website_title] ?',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}</h3>
                        <div class="faq-arrow"></div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">

                            {{ aiTrans(
                                'Sangat! Setelah mengaktifkan akun [website_title] gratis Anda, Anda
                                dapat mulai berdagang mata uang kripto menggunakan aplikasi mutakhir kami. Kunjungi situs web
                                aplikasi [website_title] dan ikuti petunjuk untuk membuat akun gratis, untuk memastikan
                                informasi pribadi yang akurat. Setelah akun Anda siap, sesuaikan opsi perdagangan Anda dan
                                setorkan setidaknya £250. Aplikasi inovatif kami kemudian akan menganalisis berbagai mata
                                uang kripto atas nama Anda, memberdayakan Anda untuk membuat keputusan investasi yang tepat.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                        </p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h3 class="faq-accordion-title-tag">
                            
                            {{ aiTrans(
                                'Apakah Platform [website_title] Mendukung Perangkat Seluler dan Komputer?',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}</h3>
                        <div class="faq-arrow"></div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            {{ aiTrans(
                                '[website_title] melayani trader dari semua tingkatan, menyediakan
                                platform komprehensif untuk meningkatkan aktivitas perdagangan harian Anda. Baik Anda seorang pemula
                                atau trader berpengalaman yang ingin memaksimalkan kemenangan trading Anda, aplikasi kami
                                adalah solusi ideal. Dengan analisis real-time, Anda dapat melakukan perdagangan yang
                                terinformasi dan berinvestasi pada aset yang paling menguntungkan. Perangkat lunak berbasis
                                web kami yang ramah pengguna kompatibel dengan berbagai perangkat, termasuk ponsel cerdas,
                                komputer, dan tablet. Cukup sambungkan ke internet dan akses aplikasi melalui browser web
                                pilihan Anda. Bahkan tanpa pengalaman sebelumnya dengan mata uang kripto, antarmuka intuitif
                                kami akan membantu Anda dalam melakukan perdagangan yang akurat. Daftar untuk mendapatkan
                                akun gratis sekarang dan bergabunglah dengan kami.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h3 class="faq-accordion-title-tag">
                            {{ aiTrans(
                                'Bisakah saya menggunakan Aplikasi [website_title] tanpa pengalaman sebelumnya?',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </h3>
                        <div class="faq-arrow"></div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            
                            {{ aiTrans(
                                'Masuki dunia perdagangan mata uang kripto dengan platform
                                [website_title] yang inovatif. Di pasar yang selalu berubah, meraih peluang yang menguntungkan memerlukan
                                perdagangan yang tepat waktu. Algoritme canggih kami memungkinkan analisis pasar yang tepat,
                                menawarkan teknologi prediktif yang tak tertandingi untuk mengidentifikasi pengaturan
                                perdagangan yang optimal. Selain itu, antarmuka kami yang intuitif dan ramah pengguna
                                memastikan bahkan pemula pun dapat berdagang dengan lancar dan percaya diri di [website_title]',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                            .</p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h3 class="faq-accordion-title-tag">
                            
                            {{ aiTrans(
                                'Berapa biaya perdagangan Kripto di [website_title] ?',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </h3>
                        <div class="faq-arrow"></div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            {{ aiTrans(
                                'Nikmati perdagangan transparan dan bebas biaya di aplikasi [website_title]
                                . Tidak seperti platform lain yang membebankan komisi dan spread, [website_title]
                                memberikan pengalaman perdagangan yang lancar tanpa biaya tersembunyi apa pun. Tidak ada
                                biaya pendaftaran, biaya deposit, atau biaya penarikan. Mulailah berdagang mata uang kripto
                                dan jadilah bagian dari komunitas kami yang berkembang dengan mendaftarkan akun VIP gratis
                                dan menyetor £250. Manfaatkan peluang luar biasa ini dan manfaatkan perangkat lunak kami
                                yang luar biasa saat ini.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h3 class="faq-accordion-title-tag">{{aiTrans('Manfaat apa yang dapat saya peroleh dari penggunaan Aplikasi')}}
                            {{ $website_title }}?</h3>
                        <div class="faq-arrow"></div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            {{ aiTrans(
                                'Meskipun [website_title] tidak dapat menjamin profitabilitas, ini
                                adalah perangkat lunak perdagangan mata uang kripto otomatis yang dirancang untuk memaksimalkan
                                keuntungan bagi investor di pasar kripto.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
            </div>
            <div class="max-width-30-percent">
                <a href="#formTop" class="button anchor-js w-button">{{aiTrans('PERDAGANGAN SEKARANG')}}</a>
            </div>
        </div>
    </section>
@endsection
