@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Neem contact met ons op" }}</title>
    <meta name="description" content="{{ "Voor al uw vragen en ondersteuning bij cryptocurrency-handel, staat het team van  $website_title  voor u klaar. Contacteer ons vandaag nog." }}" />
@endpush
@section('content')
<section class="bnr-bg">
    <div class="uk-container uk-text-center uk-margin-medium-bottom">
        <h1 class="about-header white">{{aiTrans('Neem contact op met')}}</h1>
        <h2 class="uk-h3 uk-text-bold">{{aiTrans('Neem contact met ons op via dit contactformulier')}}</h2>
    </div>
    <div class="gb-shape gb-shape-1"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 211.2" preserveAspectRatio="none">
            <path d="M600 188.4C321.1 188.4 84.3 109.5 0 0v211.2h1200V0c-84.3 109.5-321.1 188.4-600 188.4z"></path>
        </svg></div>
</section>


<div class="uk-container uk-margin-xlarge-bottom">
    <div uk-grid>
        <div class="uk-width-expand@s"></div>
        <div class="uk-width-2-5@s">
            <div class="contact-form">

                <form uk-grid>

                    <div class="uk-width-1-1@s">
                        <label for="voornaam">{{aiTrans('Voornaam')}}</label>
                        <input id="voornaam" class="uk-input" type="text" placeholder="Voer je voornaam in">
                    </div>

                    <div class="uk-width-1-1@s">
                        <label for="achternaam">{{aiTrans('Achternaam')}}</label>
                        <input id="achternaam" class="uk-input" type="text" placeholder="Voer je achternaam in">
                    </div>

                    <div class="uk-width-1-1@s">
                        <label for="e-mail">E-mail</label>
                        <input id="e-mail" class="uk-input" type="email">
                    </div>

                    <div class="uk-width-1-1@s">
                        <label for="opmerking">{{aiTrans('Opmerking of bericht')}}</label>
                        <textarea id="opmerking" class="uk-textarea" rows="5" type="textarea"></textarea>
                    </div>

                    <div class=" uk-width-1-1@s uk-margin-small-top">
                        <input class="btn-submit" value="INDIENEN" type="submit">
                    </div>

                </form>

            </div>
        </div>
        <div class="uk-width-expand@s"></div>

    </div>
</div>

    @push('css')
        <style>
            /* Custom CSS for the success message */
            .success-message {
                background-color: #d4edda;
                color: #155724;
                padding: 15px;
                border: 1px solid #c3e6cb;
                border-radius: 5px;
                margin-bottom: 20px;
            }

            /* Hide the message by default */
            .d-none {
                display: none;
            }

            /* Custom button styling */
            .btn-submit {
                background-color: #28a745; /* Custom green color */
                color: white;
                padding: 10px 20px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                font-size: 18px;
            }

            .btn-submit:hover {
                background-color: #218838; /* Darker green on hover */
            }

            /* Basic form styling */
            .form-group input, .form-group textarea {
                width: 100%;
                padding: 10px;
                border: 1px solid #ccc;
                border-radius: 5px;
            }

        </style>
    @endpush
    @push('js')
        <script>
            document.getElementById('contactForm').addEventListener('submit', function(event) {
                event.preventDefault(); // Prevent traditional form submission

                // Simulate form submission
                setTimeout(function() {
                    // Show the success message
                    document.getElementById('successMessage').classList.remove('d-none');

                    // Optionally, clear the form fields
                    document.getElementById('contactForm').reset();
                }, 500); // Simulate server response delay
            });
        </script>
    @endpush
@endsection
