@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title | Stránka O nás" }}</title>
    <meta name="description" content="{{ "Pozrite sa, ako $website_title ponúka pokročilé nástroje a úplnú podporu pre posilnenie vašich kryptomienových investícií." }}" />
@endpush
@section('content')
    <section class="banner">
        <div class="container">
            <h1 class="banner-title display-4 fw-bold text-center mb-4">{{aiTrans('O nás')}}</h1>
            <h2 class="banner-desc display-7 text-center mb-5">
                <p><strong>
                    {{ aiTrans(
                        'Ako základný pilier vo vzdelávacom prostredí zohráva [website_title] kľúčovú úlohu pri vedení
                        študentov počas ich vzdelávacej odysey. Eliminuje osamelý boj so zvládnutím náročných predmetov
                        prepojením študentov s odbornými mentormi. Títo znalci vedomostí zjednodušujú zložité myšlienky,
                        robia ich prístupnými a ľahko absorbovateľnými.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </strong></p>
            </h2>
        </div>
    </section>
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="display-5 fw-bold mb-4">
                        {{ aiTrans(
                            '[website_title] Tím',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h2>
                    <div>
                        <p>{{aiTrans('Začiatok')}} <a href="{{ route('home', $country) }}" class="text-secondary">{{$website_title}}</a> {{aiTrans('bol výsledkom synergického úsilia skupiny vizionárov, z ktorých každý sa zaviazal k ušľachtilej veci zjednodušenia a vyrovnania investičného prostredia pre masy.')}}</p>
                        <p>{{aiTrans('Títo priekopníci, ktorí pochádzajú z mozaiky profesionálnych sfér, rozpoznali zložitosť, ktorá často zahaľuje investičné vzdelávanie pre začínajúceho investora. V reakcii na to sa zaviazali napraviť tento rozkol tým, že sprístupnia všeobecne dostupnú investičnú múdrosť.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Tak sa zrodil [website_title], ktorý slúžil ako ideálny kanál spájajúci začínajúcich investorov s múdrym vedením finančných majstrov zručných v dekódovaní zložitej tapisérie investičného sveta.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                '[website_title] vedie svojich používateľov k vzdelávaciemu obsahu na mieru, čím zabezpečuje vzdelávaciu odyseu, ktorá je hlboká a prispôsobená individuálnym potrebám, osvetľuje cestu k investičnej zdatnosti.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            
                            {{ aiTrans(
                                '[website_title] je v podstate majákom posilnenia, ktorý umožňuje používateľom spravovať svoje finančné zdroje s bystrosťou a informovanou rozlišovacou schopnosťou. Bez ohľadu na skúsenosti vo finančnej aréne je [website_title] vzorom investičných platforiem pre každého, kto má záujem zvládnuť umenie investovania.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/412_459__459_659eb9aa2bc04_about-half-1.webp" type="image/webp">
                        <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/_459_659eb9aa2bc04_about-half-1.webp" type="image/webp">
                        <img src="{{ asset('frontend/assets/sk/dist') }}/images/_459_659eb9aa2bc04_about-half-1.webp" loading="lazy" width="459" height="412" alt="">
                    </picture>
                </div>
            </div>
        </div>
    </section>
    
    <section class="py-5">
        <div class="container">
            <div class="row flex-md-row flex-column-reverse ">
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/234_459__459_659eb9f8a9cc8_about-half-2.webp" type="image/webp">
                        <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/_459_659eb9f8a9cc8_about-half-2.webp" type="image/webp">
                        <img src="{{ asset('frontend/assets/sk/dist') }}/images/_459_659eb9f8a9cc8_about-half-2.webp" loading="lazy" width="459" height="234" alt="">
                    </picture>
                </div>
                <div class="col-md-8">
                    <h2 class="display-5 fw-bold mb-4">
                        {{ aiTrans(
                            'Prečo bol vytvorený [website_title]?',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h2>
                    <div>
                        <p>
                            
                            {{ aiTrans(
                                'Genéza [website_title] sa zrodila z kľúčového uvedomenia: labyrint finančného vzdelávania často vrhá nováčikov do mätúceho víru ezoterických pojmov a spletitých grafov. Bola to práve táto medzera na trhu, ktorá zasiala semienka riešenia – svätyne, kde by sa učenie dalo zjednodušiť.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            
                            {{ aiTrans(
                                'S neochvejným záväzkom posilňovať postavenie nováčikov [website_title] premosťuje priepasť medzi tupými investičnými princípmi a nezasvätenými tým, že prenáša prúd jasných a stručných vedomostí. Základnou filozofiou je skôr osvetľovať ako zahlcovať.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'Vízia [website_title] sa zrealizovala odhalením platformy [website_title] v 2024, starostlivo vybraného prepojenia, ktoré uvádza nováčikov k pokladnici vzdelávacieho obsahu. Táto iniciatíva zabezpečuje, že zložitá tapiséria investovania je pre masy odhalená a posilňuje oficiálnu webovú stránku [website_title] ako maják osvietenia vo finančnej oblasti.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <section class="banner">
        <div class="container">
            <h1 class="banner-title display-4 fw-bold text-center mb-4">{{aiTrans('Cesta k univerzálnemu učeniu')}}</h1>
            <div class="text-center">
                <p>
                    {{ aiTrans(
                        '[website_title] presadzuje filozofiu, že prístup k investičným vzdelávacím zdrojom by mal byť univerzálny. Tento maják, ktorý prispôsobuje svoj prístup tak, aby prijal nováčikov, oslavoval jazykovú rozmanitosť a vyhovel jednotlivcom, ktorí si uvedomujú rozpočet, osvetľuje rozsiahle investičné znalosti. Úsilie sa zaviazalo pestovať zložité pochopenie základných konceptov investovania. Objavte túto múdrosť na oficiálnej webovej stránke [website_title], ktorá je optimalizovaná pre interakciu s aplikáciou [website_title], a dozviete sa viac prostredníctvom komplexnej recenzie [website_title].',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
            </div>
    
            <div class="text-center mt-3 mt-md-4 mb-4 mb-md-0">
                <button class="show-modal btn btn-primary text-white btn-lg shadow-lg px-3 px-md-5 fs-4">{{aiTrans('Zistiť viac')}}</button>
            </div>
        </div>
    </section>
@endsection
