@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Kontaktujte nás na stránke" }}</title>
    <meta name="description" content="{{ "Neváhajte sa na nás obrátiť na $website_title ! Odpovedáme na vaše otázky a poskytujeme podporu vo vašich transakciách s kryptomenami." }}" />
@endpush
@section('content')
    <section class="p-5">
        <div class="container">
            <h1 class="display-4 fw-bold text-center mb-4">{{aiTrans('Kontakt')}}</h1>
            <form class="">
                <div class="form-group">
                    <input type="text" name="name" class="form-control" placeholder="Meno">
                </div>
                <br>
                <div class="form-group">
                    <input type="email" name="name" class="form-control" placeholder="Email">
                </div>
                <br>
                <div class="form-group">
                    <textarea cols="40" rows="10" class="form-control" placeholder="Správa" name="content"></textarea>
                </div>
                <br>
                <button class="btn btn-primary btn-lg shadow-lg px-3 px-md-5 fs-4" type="submit">Odoslať správu</button>
            </form>
        </div>
    </section>
    @push('css')
        <style>
            /* Custom CSS for the success message */
            .success-message {
                background-color: #d4edda;
                color: #155724;
                padding: 15px;
                border: 1px solid #c3e6cb;
                border-radius: 5px;
                margin-bottom: 20px;
            }

            /* Hide the message by default */
            .d-none {
                display: none;
            }

            /* Custom button styling */
            .btn-submit {
                background-color: #28a745;
                /* Custom green color */
                color: white;
                padding: 10px 20px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                font-size: 18px;
            }

            .btn-submit:hover {
                background-color: #218838;
                /* Darker green on hover */
            }

            /* Basic form styling */
            .form-group input,
            .form-group textarea {
                width: 100%;
                padding: 10px;
                border: 1px solid #ccc;
                border-radius: 5px;
            }
        </style>
    @endpush
    @push('js')
        <script>
            document.getElementById('contactForm').addEventListener('submit', function(event) {
                event.preventDefault(); // Prevent traditional form submission

                // Simulate form submission
                setTimeout(function() {
                    // Show the success message
                    document.getElementById('successMessage').classList.remove('d-none');

                    // Optionally, clear the form fields
                    document.getElementById('contactForm').reset();
                }, 500); // Simulate server response delay
            });
        </script>
    @endpush
@endsection
