<?php

namespace App\Http\Controllers\API\Job;

use App\Domain\Job\Models\JobApply;
use App\Domain\Service\Models\Service;
use App\Http\Controllers\API\ApiController;
use App\Http\Resources\API\Job\OfferResource;
use App\Http\Resources\API\Job\JobApplyResource;
use Arr;
use Illuminate\Http\Request;

class JobApplyController extends ApiController
{
    public function jobApply(Request $request)
    {

        $data = $request->validate([
            'name' => 'required|string',
            'email' => 'required|string',
            'phone' => 'required|string',
            'previous_experiences' => 'required|string',
            'job_id' => 'required|exists:jobs,id',
            'cv' => 'required|file|mimes:pdf,doc,docx|max:2048',
        ]);
        $file = Arr::pull($data, 'cv');

        $newJobApply = JobApply::create($data);

        if ($request->hasFile('cv')) {
            $cvFile = $request->file('cv');
           $newJobApply->addMedia($cvFile)->toMediaCollection('cv');
            // You can customize the media collection name 'cv' as needed
        }

        return $this->sendResponse(
            new JobApplyResource($newJobApply),
            __('Jobs retrieved Successfully')
        );
    }
}
