<?php

namespace App\Http\Resources\API\Offer;

use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class OfferResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'benefits' => $this->benefits,
            'price_before_discount' => (string)$this->price_before_discount,
            'price_after_discount' => (string)($this->price_after_discount),
            'discount_percentage_text' => $this->discount_percentage ? round($this->discount_percentage) . '% ' . __('Off') : '',
            'discount_percentage' => (string)$this->discount_percentage,
            'starts_at' => $this->starts_at,
            'expires_at' => $this->expires_at,
            'logo' => asset('frontend/assets/img/logo.jpg'),
            'image' => !empty($this->getFirstMediaUrl('image')) ? $this->getFirstMediaUrl('image') : asset('brands/car-service.png'),
        ];
    }
}
