# Codebase Page Builder

You can use this package to build static pages that any use can edit

## Installation

1. `composer require jd-dotlogics/laravel-grapesjs`

2. add `PageBuilderServiceProvider.php` to your `config/app.php` file

3. In your `composer.json` under **psr-4**

` "Codebase\\PageBuilder\\": "packages/Codebase/PageBuilder/src", `

4. `composer dumpautoload`
5. include `routes.php` file in your routes file
6. add your frontend styles in `config.php` file
7. run `php artisan migrate`
8. `php artisan db:seed Codebase\PageBuilder\Database\Seeders\StaticPageSeeder`
9. copy `Resources/Views/Dashboard` to your dashboard views

# Usage

```PHP
use Codebase\PageBuilder\PageBuilder;

PageBuilder::getPage('your page key') //default locale version
PageBuilder::getPage('your page key','ar') // arabic version
```