<?php

namespace Codebase\PageBuilder\Concerns;

use Codebase\PageBuilder\Editor\Config;
use Codebase\PageBuilder\Editor\GenerateBlocks;

trait WithEditablePage
{
    protected function showPageEditor($model, bool $withBasicBlocks = false)
    {

        if (!class_uses($model, HasEditablePage::class)) {
            throw new \RuntimeException("You should use HasEditablePage on the given model");
        }
        $factory = app(Config::class);

        $currentLang = request('language', 'en');
        $editorConfig = $factory->initialize($model->fetchEditablePage($currentLang));
        $blocks = GenerateBlocks::forModel($model, $currentLang);

        $fallbackRoute = route($this->path . '.index');

        return view('PageBuilder::editor', compact([
            'editorConfig',
            'model',
            'currentLang',
            'blocks',
            'fallbackRoute',
            'withBasicBlocks',
        ]));
    }
}
