<script>

    $(document).ready(function () {
        window.loadAjaxFormData = loadAjaxFormData
        $(".dashboard-form-select-ajax").each(function () {
            loadAjaxFormData($(this))
        });

        function loadAjaxFormData(that) {
            const model = that;
            const modelClass = model.data('model-class');
            const modelDilagId = model.data('model-dialog-id');
            const currentClass = model.data('current-class');
            const columnName = model.data('column-name');
            const whereColumnName = model.data('where-column-name');
            const whereColumnId = model.data('where-column-id');
            const placeholderAjax = model.data('placeholder-ajax');
            const selectedId = model.data('selected-id');
            let country_id = $("#countriesSelection").val();
            let state_id = $("#statesSelection").val();
            const route = model.data('route');
            const selectedRoute = model.data('selected-route');

            if (modelDilagId == 'add_new_shipping') {
                country_id = $("#shipping-countriesSelection").val();
                state_id = $("#shipping-statesSelection").val();
            }

            model.select2({
                dropdownParent: (modelDilagId) ? $('#' + modelDilagId) : null,
                ajax: {
                    url: route,
                    dataType: 'json',
                    delay: 250,
                    type: 'post',

                    data: function (params) {
                        return {
                            q: params.term, // search term
                            page: params.page,
                            columnName: columnName,
                            whereColumnName: whereColumnName,
                            whereColumnId: whereColumnId,
                            country_id: country_id,
                            state_id: state_id,
                        };
                    },
                    processResults: function (data, params) {
                        params.page = params.page || 1;

                        return {
                            results: data.data,
                            pagination: {
                                more: params.page < data.last_page
                            }
                        };
                    },
                    cache: false
                },
                placeholder: placeholderAjax,
                allowClear: true
            });


            if (selectedId) {
                $.ajax({
                    type: 'post',
                    url: selectedRoute,
                }).then(function (data) {
                    // create the option and append to Select2
                    var option = new Option(data.text, data.id, true, true);
                    model.append(option).trigger('change');

                    // manually trigger the `select2:select` event
                    model.trigger({
                        type: 'select2:select',
                        params: {
                            data: data
                        }
                    });

                });
            }


        }
    });

    $("body").on('change', '#countriesSelection', function (e) {
        let CitySelection = $('#citiesSelection');
        let statesSelection = $('#statesSelection');
        CitySelection.val(null).trigger('change');
        statesSelection.val(null).trigger('change');

        CitySelection.select2('destroy');
        statesSelection.select2('destroy');

        window.loadAjaxFormData(CitySelection);
        window.loadAjaxFormData(statesSelection);
    });


    $("body").on('change', '#citiesSelection', function (e) {
        let stateSelection = $('#statesSelection');
        stateSelection.val(null).trigger('change');
        stateSelection.select2('destroy');
        window.loadAjaxFormData(stateSelection);
    });


    $("body").on('change', '#shipping-countriesSelection', function (e) {
        let CitySelection = $('#shipping-citiesSelection');
        let statesSelection = $('#shipping-statesSelection');
        CitySelection.val(null).trigger('change');
        statesSelection.val(null).trigger('change');

        CitySelection.select2('destroy');
        statesSelection.select2('destroy');

        window.loadAjaxFormData(CitySelection);
        window.loadAjaxFormData(statesSelection);
    });


    $("body").on('change', '#shipping-statesSelection', function (e) {
        let CitySelection = $('#shipping-citiesSelection');
        CitySelection.val(null).trigger('change');
        CitySelection.select2('destroy');
        window.loadAjaxFormData(CitySelection);
    });

</script>
