<?php

use App\Domain\Link\Models\Link;
use App\Jobs\TakeScreenshotJob;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use App\Http\Controllers\Frontend\HomeController;
Route::group([
    'namespace' => 'Frontend'], function () {
    // The home route with an optional locale parameter
    //Route::get('/{locale?}', 'HomeController')->name('welcome');
    //Route::get('/{locale?}/about', 'HomeController@about')->name('about');

   //Route::post('/translate', 'HomeController@translateHtml')->name('translate');
    Route::get('/about', [HomeController::class, 'about'])->name('about.en');
    Route::get('/contact', [HomeController::class, 'contact'])->name('contact.en');
    Route::get('/privacy-policy', [HomeController::class, 'privacy'])->name('privacy.en');
    Route::get('/terms-of-use', [HomeController::class, 'terms'])->name('terms.en');


    Route::group(['prefix' => '{country?}','middleware' => ['setlocale','check.country']], function () {
        Route::get('/', [HomeController::class, 'home'])->name('home');
        Route::get('/about', [HomeController::class, 'about'])->name('about');
        Route::get('/contact', [HomeController::class, 'contact'])->name('contact');
        Route::get('/privacy-policy', [HomeController::class, 'privacy'])->name('privacy');
        Route::get('/terms-of-use', [HomeController::class, 'terms'])->name('terms');
        Route::get('/thank-you', [HomeController::class, 'thankYou'])->name('thank-you');
    });
    Route::get('/set-language/{lang}', [HomeController::class, 'setLanguage'])->name('set.language');
    Route::any('submit-form', 'SubmitFormApiController@SubmitForm')->name('submit-form');
    Route::get('/', function () {
        return redirect()->route('home');
    });
});



