@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title $website_name | Zdroj pre bezpečné kryptomeny" }}</title>
    <meta name="description" content="{{ "$website_title ponúka celoplošnú pomoc a pokročilé nástroje na dosiahnutie vašich kryptoměnových investičných cieľov. Zistite, ako vám môžeme byť nápomocní." }}" />
@endpush

@section('content')
    <section class="banner py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h1 class="display-4 fw-bold mb-4">{{$website_title}}</h1>
                    <div class="fs-4 mb-5">
                        <h2><strong class="change-by-command">{{ "$website_title Vedenie v krypto svete: odhalte tajomstvá úspechu a prekonajte konkurenciu" }}</strong></h2>
                        <p><strong class="change-by-command">{{ "$website_title Odhaľte krypto tajomstvá a prekročte konkurenciu" }}</strong></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="shadow position-relative banner-form form-height">
                        @include('frontend.sk.components.form')
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="display-5 fw-bold mb-4">
                        
                        {{ aiTrans(
                            'Čo je [website_title]?',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h2>
                    <div>
                        <p><strong>{{aiTrans('Predstavte si digitálneho veľvyslanca, katalyzátora vedomostí, uhniezdeného v digitálnom
                                éteri, aby spojil zvedavé mysle s majstrami investičného vzdelávania. Umenie investovania
                                presahuje jednoduchosť čísel a vzorov na grafoch.')}}</strong></p>
                        <p>{{aiTrans('Ak chcete skutočne zvládnuť investičnú hru, musíte sa ponoriť do zložitosti dynamiky trhu,
                            odhaliť záhadu cenových posunov a dekódovať vplyv celosvetových javov na nespočetné množstvo
                            sektorov. Pre mnohých je táto úloha herkulovská.')}}</p>
                        <p>
                            
                            {{ aiTrans(
                                'Vstúpte do [website_title], virtuálneho prepojenia, ktoré bez námahy premosťuje priepasť medzi
                                nováčikmi a strážcami investičnej múdrosti. Pre tých, ktorí majú horlivosť po demystifikácii
                                finančného labyrintu, je tento portál vaším vstupom do vzdelávacieho obsahu na mieru.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>{{aiTrans('Poslanie je jasné: demokratizovať šírenie vedomostí a zabezpečiť, aby všetci, bez ohľadu na svoj
                            východiskový bod, mohli využiť množstvo kritických poznatkov. Stránka v podstate demystifikuje
                            zložitosť investovania a slúži ako erudovaný sprievodca zoznamom oddaných špecialistov.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Okrem toho [website_title] predznamenáva nevyhnutnú povahu učenia. V rozľahlom teréne
                                investícií, v oblasti, kde číhajú výzvy a cesty sa často krútia, je prvoradá schopnosť robiť
                                informované rozhodnutia. Rýchle reflexy musia byť vyvážené neochvejným záväzkom k vzdelávaniu a
                                premyslenej analýze.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'V srdci tejto finančnej odysey leží sila vzdelávania a záväzok webovej stránky nasmerovať
                                hľadačov k optimálnym vzdelávacím pokladom je neochvejný. Či už ste na začiatku svojho
                                investičného hľadania alebo sa snažíte o zvýšené odborné znalosti, platforma [website_title] je
                                vaším kompasom pre pedagógov, ktorí rezonujú s vašimi ambíciami.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                    <div class="text-md-start text-center mt-3 mt-md-4 mb-4 mb-md-0">
                        <button class="show-modal btn  text-white btn-secondary btn-lg shadow-lg px-3 px-md-5 fs-4">{{aiTrans('Zistiť viac')}}</button>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/asdasd.jpeg" type="image/webp">
                        <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/_asdasd.jpeg" type="image/jpeg">
                        <img src="{{ asset('frontend/assets/sk/dist') }}/images/_asdasd.jpeg" loading="lazy" width="459"
                            height="459" alt="">
                    </picture>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light">
        <div class="container mb-5">
            <h2 class="display-5 fw-bold mb-4 text-center">
                
                {{ aiTrans(
                    'Odhalenie tajomstva [website_title]',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </h2>
            <div class="text-center">
                <p><strong>
                    {{ aiTrans(
                        'Vydajte sa na erudovanú odyseu cez mnohostranné sféry investícií s [website_title]. Táto
                        iniciatíva sa venuje zvýšeniu vašej bystrosti a osvetleniu jemných, ale nevyhnutných nuancií a
                        zložitostí, ktoré prenikajú do investičnej sféry.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </strong></p>
                <p><strong>
                    {{ aiTrans(
                        'S hlbokou oddanosťou pedagogike [website_title] zaisťuje, že vaše pochopenie investičných
                        princípov je robustné a komplexné predtým, ako pokročíte ďalej na svojej finančnej ceste.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </strong>
                </p>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-md-4 d-flex align-items-stretch mb-5">
                    <div class="card shadow rounded-3 border-0 border-bottom border-4 border-secondary">
                        <picture>
                            <source
                                srcset="{{ asset('frontend/assets/sk/dist') }}/images/330_449__473_659eb2e974365_img-1.webp"
                                type="image/webp">
                            <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb2e974365_img-1.jpg"
                                type="image/jpeg">
                            <img src="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb2e974365_img-1.jpg"
                                style="max-height: 320px" loading="lazy" class="w-100 shadow-lg" width="449"
                                height="330" alt="">
                        </picture>
                        <div class="card-body">
                            <h3 class="card-title">{{aiTrans('Vytváranie ciest k investičnému vzdelávaniu')}}</h3>
                            <input type="checkbox" id="parameter-checkbox0">
                            <div class="card-text">
                                <p>✔️ 
                                    {{ aiTrans(
                                        '[website_title] slúži ako most vo finančnom vesmíre a spája začínajúcich investorov s
                                        lídrami v odvetví, ktorí sú pripravení odovzdať zásadnú múdrosť trhu.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <p>✔️ {{aiTrans('Hlavným cieľom tohto portálu je vyrovnať podmienky vo finančnom vzdelávaní, odstrániť
                                    obvyklé prekážky, ako sú prehnané náklady alebo jazykové obmedzenia.')}}</p>
                                <p>✔️ 
                                    {{ aiTrans(
                                        'Zdôrazňujúc dôležitosť pevného vzdelávacieho základu, [website_title] zdôrazňuje
                                        potrebu komplexného pochopenia trhu pred začatím investičného úsilia.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="parameter-checkbox0" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-stretch mb-5">
                    <div class="card shadow rounded-3 border-0 border-bottom border-4 border-secondary">
                        <picture>
                            <source
                                srcset="{{ asset('frontend/assets/sk/dist') }}/images/349_449__473_659eb30360ca5_img-2.webp"
                                type="image/webp">
                            <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb30360ca5_img-2.jpg"
                                type="image/jpeg">
                            <img src="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb30360ca5_img-2.jpg"
                                style="max-height: 320px" loading="lazy" class="w-100 shadow-lg" width="449"
                                height="349" alt="">
                        </picture>
                        <div class="card-body">
                            <h3 class="card-title">{{aiTrans('Uvoľnenie potenciálu prostredníctvom štruktúrovaného učenia')}}</h3>
                            <input type="checkbox" id="parameter-checkbox1">
                            <div class="card-text">
                                <p>✅ 
                                    
                                    {{ aiTrans(
                                        'Spolupráca so školskými podnikmi prostredníctvom [website_title] poskytuje komplexné,
                                        metodicky organizované vzdelávacie investičné skúsenosti.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <p>✅ 
                                    
                                    {{ aiTrans(
                                        'Využitie múdrosti skúsených odborníkov prostredníctvom aplikácie [website_title]
                                        objasňuje aj tie najlabyrintové témy a zefektívňuje cestu k porozumeniu.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <p>✅ 
                                    
                                    {{ aiTrans(
                                        'Zámerná vzdelávacia trajektória na platforme [website_title] začína upevňovaním
                                        základných princípov, čím sa pripravuje pôda pre skúmanie vyspelejších území.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="parameter-checkbox1" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-stretch mb-5">
                    <div class="card shadow rounded-3 border-0 border-bottom border-4 border-secondary">
                        <picture>
                            <source
                                srcset="{{ asset('frontend/assets/sk/dist') }}/images/313_449__473_659eb31ade698_img-3.webp"
                                type="image/webp">
                            <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb31ade698_img-3.jpg"
                                type="image/jpeg">
                            <img src="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb31ade698_img-3.jpg"
                                style="max-height: 320px" loading="lazy" class="w-100 shadow-lg" width="449"
                                height="313" alt="">
                        </picture>
                        <div class="card-body">
                            <h3 class="card-title">{{aiTrans('Pustenie sa do misie založenej na znalostiach')}}</h3>
                            <input type="checkbox" id="parameter-checkbox2">
                            <div class="card-text">
                                <p><strong>✨ </strong>{{aiTrans('Oblasť investícií presahuje jednoduchosť číslic, spriada príbehy o
                                    kolísajúcich trhových silách a vývoji ekonomiky – tapiséria, ktorú stojí za to študovať
                                    všetci.')}}</p>
                                <p><strong>✨ </strong>
                                    {{ aiTrans(
                                        '[website_title] slúži ako portál, ktorý ponúka pohľad na tieto
                                        podmanivé príbehy tým, že premosťuje priepasť medzi zvedavými mysľami a baštami
                                        vzdelávacích odborníkov.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="parameter-checkbox2" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary btn-lg text-uppercase shadow-lg px-3 px-md-5 fs-4">
                    {{aiTrans('Zistite viac')}}
                </button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container mb-5">
            <div class="row">
                <div class="col-md-10">
                    <h2 class="display-5 fw-bold mb-4">{{aiTrans('Odhalenie jadra investičného vzdelávania')}}</h2>
                    <p>{{aiTrans('Vstup do sveta investícií si vyžaduje rozumné rozhodnutia ukotvené v dôkladnom pochopení viacerých
                        faktorov. Ponorte sa do hodnoty spoločnosti, zvážte váhy medzi rizikom a odmenou alebo zostaňte
                        naladení na medzinárodné udalosti, ktoré formujú pulz trhu – je to cesta poznačená strmým vzostupom
                        vedomostí.')}}</p>
                    <p>
                        {{ aiTrans(
                            '[website_title] sa javí ako žiarivý sprievodca, ktorý zahŕňa komplexnú povahu investícií a snaží sa
                            demystifikovať proces pre nováčikov. Toto prepojenie podporuje spojenie medzi nováčikmi a ctihodnými
                            firmami a udeľuje kľúče k pokladnici relevantných zdrojov a vedeckého obsahu.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                    <p>
                        
                        {{ aiTrans(
                            'Vytváraním spojenectiev so školskými orgánmi portál [website_title] umožňuje svojim patrónom
                            získavať múdrosť od odborníkov. Či už sa pustíte do úvodného podniku alebo sa snažíte obohatiť svoju
                            fiškálnu bystrosť, presadzuje vaše vzdelávacie hľadanie a uľahčuje prechod spletitým terénom
                            investícií.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                    <p>
                        
                        {{ aiTrans(
                            'Investičné nástroje predpokladajú nespočetné množstvo inkarnácií, z ktorých každá podlieha svojmu
                            vlastnému súboru princípov a pohybu. Od akciového trhu a cenných papierov s pevným výnosom až po
                            hmotné aktíva, ako sú nehnuteľnosti a záhadný svet komodít, výber je obrovský. Platforma [website_title] je navigačným nástrojom, ktorý dekóduje tieto alternatívy a usmerňuje používateľov cez objemné
                            more údajov.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">{{aiTrans('Nadácia je kľúčová')}}</h3>
                            <input type="checkbox" id="howworks-checkbox0">
                            <div>
                                <p>
                                    {{ aiTrans(
                                        'Ako dobre postavená budova stojaca na pevnej pôde, cesta do investičnej sféry začína
                                        pochopením základných princípov. [website_title] kladie značný dôraz na túto úvodnú
                                        fázu a ponúka komplexný základ pre nováčikov. Takéto základné znalosti navyše poskytujú
                                        jednotlivcom zdatnosť na obratné manévrovanie v zložitom investičnom prostredí a
                                        prinášajú jasnosť a pochopenie každého rozhodnutia. Výsledkom je, že zapojenie sa do
                                        platformy [website_title] sa stáva poučným zážitkom.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="howworks-checkbox0" class="text-decoration-underline fw-bold fs-5">{{aiTrans("Prečítať všetko")}}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">{{aiTrans('Za hranicami základov')}}</h3>
                            <input type="checkbox" id="howworks-checkbox1">
                            <div>
                                <p>
                                    
                                    {{ aiTrans(
                                        'Akonáhle sú základné princípy pevne v rukách, odysea postupuje do prepracovanejších
                                        území. Investičné prostredie je široké a mnohostranné a [website_title] slúži ako kanál
                                        pre tento vylepšený prieskum. Dláždi cesty pre zvedavé mysle, aby prešli rozmanitými
                                        aspektmi investícií, dekódovali nuansy dynamiky trhu a rozoznali vznikajúce trendy.
                                        Prostredníctvom nástrojov a poznatkov, ktoré poskytuje [website_title], možno
                                        demystifikovať a odhaliť aj labyrintové aspekty financií.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="howworks-checkbox1" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">{{aiTrans('Zostaňte informovaní')}}</h3>
                            <input type="checkbox" id="howworks-checkbox2">
                            <div>
                                <p>
                                    {{ aiTrans(
                                        'Sféra financií je neustále sa vyvíjajúca tapiséria, pretkaná vláknami čerstvých údajov,
                                        trendov a progresívneho vývoja každý deň. Chápajúc význam držania kroku s týmito
                                        neustálymi tokmi, toto prepojenie vedomostí sľubuje vybaviť ašpirantov najaktuálnejším
                                        osvietením. Bezproblémovým prepojením návštevníkov s úložiskom aktualizovaného
                                        pedagogického obsahu [website_title] zaisťuje, že jednotlivci sú vhodne vyzbrojení, aby
                                        kráčali popri svižnej kadencii investičného terénu.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="howworks-checkbox2" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">
                                {{ aiTrans(
                                    'Odborné poradenstvo od [website_title]',
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                                </h3>
                            <input type="checkbox" id="howworks-checkbox3">
                            <div>
                                <p>
                                    {{ aiTrans(
                                        'Vydať sa na cestu neprebádanými ríšami je menej skľučujúce s bystrým mentorom po vašom
                                        boku. [website_title] prijíma tento étos preklenutím priepasti medzi tými, ktorí sú
                                        smädní po múdrosti, a strojcami, ktorí ju vlastnia. Títo mudrci čerpajú zo svojich
                                        hlbokých rezervoárov vedomostí a bystrosti, aby rozdávali kritické rady, čím
                                        zabezpečujú, že každý študent získa robustné a holistické pochopenie investičných
                                        stratégií na platforme [website_title]. Systém recenzií [website_title] odráža kvalitu
                                        poskytovaných poznatkov, vďaka čomu je aplikácia [website_title] základným nástrojom
                                        pre mnohých.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="howworks-checkbox3" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary btn-lg text-uppercase shadow-lg px-3 px-md-5 fs-4">
                    {{aiTrans('Zistiť viac')}}
                </button>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light">
        <div class="container">
            <div class="row flex-md-row flex-column-reverse ">
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/sk/dist') }}/images/459_459__459_66a9ff9dc7516_immediate-alora-3000.webp"
                            type="image/webp">
                        <source
                            srcset="{{ asset('frontend/assets/sk/dist') }}/images/_459_66a9ff9dc7516_immediate-alora-3000.jpeg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/sk/dist') }}/images/_459_66a9ff9dc7516_immediate-alora-3000.jpeg"
                            loading="lazy" width="459" height="459" alt="">
                    </picture>
                </div>
                <div class="col-md-8">
                    <input type="checkbox" id="about2-checkbox">
                    <div>
                        <h3>{{aiTrans('Pustenie sa do investičných základov')}}</h3>
                        <p><strong>{{aiTrans('Ponorenie sa do investičnej oblasti si vyžaduje bystré rozhodovanie založené na množstve
                                faktorov. Človek môže skúmať trhovú hodnotu korporácie, vážiť váhy rizika a odmeny alebo
                                zostať ostražitý, aby sledoval pulz globálnych udalostí, ktoré riadia finančné trhy –
                                zložitá cesta poznania.')}}</strong></p>
                        <p>
                            
                            {{ aiTrans(
                                'Tu sa [website_title] objavuje ako svetiel, ktorý si uvedomuje zložitosť investícií a snaží sa
                                ich demystifikovať pre nováčikov. Platforma poskytuje prepojenie medzi nováčikmi a ctihodnými
                                firmami a zaručuje obstarávanie relevantných zdrojov a didaktického obsahu.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>{{aiTrans('V spojenectve so scholastickými orgánmi odovzdáva múdrosť prostredníctvom poručníctva ctihodných
                            trhových mudrcov. Posilňuje vašu vzdelávaciu túžbu, či už je to vaša prvá plavba alebo snaha o
                            zlepšenie vašej bystrosti, a pomáha vám prekonať labyrint investičného prostredia.')}}</p>
                        <p>{{aiTrans('Investičné nástroje sú rozmanité a každý z nich sa riadi vlastným súborom princípov a pohybu. Od
                            ríše akcií a dlhopisov až po hmotné aktíva, ako sú nehnuteľnosti a suroviny, spektrum možností
                            je rozsiahle. Tento portál slúži ako astroláb, dešifruje tieto rozhodnutia a vedie cestovateľov
                            cez obrovský oceán údajov.')}}</p>
                        <p><strong>✔️ {{aiTrans('Vyplnenie priepasti investičných znalostí')}}</strong><br>{{aiTrans('V investičnom svete existujú
                            múdri veteráni a horliví tyri.')}}</p>
                        <p>{{aiTrans('Zatiaľ čo mudrci sú pripravení šíriť svoju bystrosť, zelenáči často zápasia s hádankou získavania
                            neochvejného smerovania a rozlišovania skutočných informácií.')}}</p>
                        <p><strong>✔️ {{aiTrans('Podpora spojení')}}</strong><br>
                            {{ aiTrans(
                                'Toto je križovatka, v ktorej zasahuje [website_title]. Je
                                to spojenie, ktoré vytvára väzby medzi tými, ktorí sa usilujú o finančné osvietenie, a váženými
                                akadémiami.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>{{aiTrans('Žiadna otázka nie je príliš základná alebo prepracovaná, pretože platforma je odhodlaná
                            zabezpečiť, aby sa každý stretol s komplexným objasnením, jednoducho tým, že je
                            sprostredkovateľom spojení.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Či už niekto prechováva zvedavosť na peripetiách trhov alebo hľadá jasné vysvetlenia týkajúce sa
                                spektra investičných ciest, [website_title] sa stavia do pozície vášho popredného úložiska.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'Podstatou [website_title] je poskytnúť prístup k pedagógom známym svojou prenikavosťou,
                                prenikavými vysvetleniami a pedagogickou zdatnosťou. Tieto inštitúcie šikovne rozoberajú zložité
                                predstavy o investovaní do stráviteľného učenia.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>{{aiTrans('S podporou tejto platformy nezhromažďujete len údaje; Púšťate sa do starostlivo zostavenej
                            vzdelávacej odysey. Nasmeruje vás od základných aspektov investovania k jeho ezoterickým
                            aspektom, čím zabezpečí vašu ľahkosť a majstrovstvo v každej fáze.')}}</p>
                        <label for="about2-checkbox" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                    </div>
                    <div class="text-md-start text-center mt-3 mt-md-4 mb-4 mb-md-0">
                        <button class="show-modal btn  text-white btn-secondary btn-lg shadow-lg px-3 px-md-5 fs-4">{{aiTrans('Zistiť viac')}}</button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container mb-5">
            <h2 class="display-5 text-center fw-bold mb-4">{{aiTrans('Orientácia v investičnom prostredí s istotou')}}</h2>
            <div>
                <p><strong>
                    {{ aiTrans(
                        'Pustiť sa do obrovskej odysey finančných trhov sa môže zdať ohromujúce, pripomínajúce labyrintový
                        graf, ktorý láka neohrozených. Avšak s [website_title] ako vaším neomylným navigátorom sa táto
                        expedícia premení na plynulý prechod.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </strong></p>
                <p><strong>
                    {{ aiTrans(
                        '[website_title] pôsobí ako portál ku kritickým nástrojom a spolupracuje s elitnými vzdelávacími
                        subjektmi na odhaľovaní zložitosti finančných podnikov. Svojim používateľom poskytuje schopnosť
                        prechádzať a chápať rozmanité prvky investovania s bezprecedentnou jasnosťou a istotou.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </strong></p>
            </div>
        </div>

        <div class="container">
            <div class="row p-4 align-items-center rounded-3 border shadow mb-5">
                <div class="col-lg-7 ">
                    <h3 class=" fw-bold lh-1"> {{aiTrans('Budovanie pevných základov')}}</h3>
                    <input type="checkbox" id="mustknow-checkbox0">
                    <div class="lead">
                        <p>
                            {{ aiTrans(
                                'Začatie vašej cesty do sveta investícií sa podobá vybudovaniu odolného príbytku; Vytvorenie
                            pevných základov je nevyhnutné. [website_title] zdôrazňuje tento princíp n
                            a svojom',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                            {{route('home',$country)}} {{aiTrans('a zabezpečuje, že 2024 je rok, v ktorom začnete na pevných základoch.
                            Tým, že sa stanete zdatnými v základných princípoch, vybavíte sa pevným porozumením potrebným na
                            zvládnutie zložitostí, ktoré sú pred vami.')}}</p>
                        <label for="mustknow-checkbox0" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 p-0 overflow-hidden shadow h-100">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/sk/dist') }}/images/330_449__473_659eb34674076_img-4.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb34674076_img-4.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb34674076_img-4.jpg"
                            loading="lazy" class="w-100 rounded-3" width="449" height="330" alt="">
                    </picture>
                </div>
            </div>
            <div class="row p-4 align-items-center rounded-3 border shadow mb-5">
                <div class="col-lg-7 ">
                    <h3 class=" fw-bold lh-1"> {{aiTrans('Odhaľovanie zložitých konceptov')}}</h3>
                    <input type="checkbox" id="mustknow-checkbox1">
                    <div class="lead">
                        <p>{{aiTrans('Doménou investovania je tapiséria jemných a často mätúcich tém. V tejto chvíli sa [website_title] javí ako kľúčový maják, ktorý demystifikuje labyrint tém premostením bezproblémových
                            interakcií so skúsenými znalcami.',$locale,
                            ['website_title' => $website_title],)}}</p>
                        <label for="mustknow-checkbox1" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 p-0 overflow-hidden shadow h-100">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/sk/dist') }}/images/349_449__473_659eb36075b92_img-5.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb36075b92_img-5.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb36075b92_img-5.jpg"
                            loading="lazy" class="w-100 rounded-3" width="449" height="349" alt="">
                    </picture>
                </div>
            </div>
            <div class="row p-4 align-items-center rounded-3 border shadow mb-5">
                <div class="col-lg-7 ">
                    <h3 class=" fw-bold lh-1"> {{aiTrans('Prijatie neustáleho vzdelávania a adaptácie')}}</h3>
                    <input type="checkbox" id="mustknow-checkbox2">
                    <div class="lead">
                        <p>
                            {{ aiTrans(
                                'Oblasť investícií je podobná nepokojným svetom technológií a módy, nikdy nie statická, vždy sa
                            menia. Ako rozmary módy a inovácií formujú ich domény, aj investičné prostredie osciluje s
                            novými tendenciami. V srdci tejto neustále sa meniacej arény sa [website_title] objavuje ako
                            základný kameň, ktorý ponúka stály prúd súčasných pohľadov. Prostredníctvom svojich ponúk 2024,
                            vrátane aplikácie [website_title] a komplexnej recenzie [website_title], zaisťuje, že
                            uchádzači sú dobre oboznámení s nuansami obchodu.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <label for="mustknow-checkbox2" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Prečítať všetko')}}</label>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 p-0 overflow-hidden shadow h-100">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/sk/dist') }}/images/313_449__473_659eb374aa8ca_img-6.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb374aa8ca_img-6.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/sk/dist') }}/images/_473_659eb374aa8ca_img-6.jpg"
                            loading="lazy" class="w-100 rounded-3" width="449" height="313" alt="">
                    </picture>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary text-uppercase btn-lg shadow-lg px-3 px-md-5 fs-4">
                    
                    {{ aiTrans(
                        'PRESKÚMAŤ [website_title]',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    
                </button>
            </div>
        </div>
    </section>

    <section class="py-5 bg-phone text-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h2 class="display-5 fw-bold mb-4">
                        {{aiTrans('Top 3 predpovede BTC!')}}
                    </h2>
                    <p class="fw-bold fs-4 test-uppercase">
                        {{ aiTrans(
                            'Môžete sa stať obchodníkom s bitcoinmi ako mnohí iní na celom svete, ak sa zaregistrujete na [website_title].',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        
                    </p>
                </div>
                <div class="col-lg-4 d-flex flex-column">
                    <div class="mb-4 position-relative px-5">
                        <div class="position-absolute start-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                <path
                                    d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z">
                                </path>
                            </svg>
                        </div>
                        <div>
                            <p>{{aiTrans('Bitcoin dosiahne 90% mainstreamové prijatie v budúcom roku - Matrixport')}}</p>
                        </div>
                    </div>
                    <div class="mb-4 position-relative px-5">
                        <div class="position-absolute start-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                <path
                                    d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z">
                                </path>
                            </svg>
                        </div>
                        <div>
                            <p>{{aiTrans('Očakávajte mimoriadny nárast v oblasti bitcoinu, pričom prognózy naznačujú pozoruhodný
                                vzostup na 45 000 dolárov do marca 2024.')}}</p>
                        </div>
                    </div>
                    <div class="mb-4 position-relative px-5">
                        <div class="position-absolute start-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                <path
                                    d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z">
                                </path>
                            </svg>
                        </div>
                        <div>
                            <p>{{aiTrans('Bitcoin do konca budúceho roka dosiahne 130 000 dolárov – Cointelegraph')}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <h2 class="display-5 fw-bold mb-5 text-center">
                {{aiTrans('Často kladené otázky')}}
            </h2>
            <div class="row">
                <div class="accordion mx-auto">
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading0">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="false"
                                aria-controls="collapse0">

                                {{ aiTrans(
                                    'Potrebujem pred použitím [website_title] predchádzajúce znalosti?',
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                                
                            </button>
                        </h3>
                        <div id="collapse0" class="accordion-collapse collapse" aria-labelledby="heading0"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    
                                    {{ aiTrans(
                                        'Nebojte sa, pretože [website_title] je starostlivo vytvorený tak, aby slúžil nováčikom
                                    aj informovaným a nasmeroval každého návštevníka k vzdelávacím zdrojom na mieru, ktoré
                                    sú v súlade s ich jedinečnými predpokladmi.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading1">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false"
                                aria-controls="collapse1">
                                {{aiTrans('Ponúka táto webová stránka investičné poradenstvo?')}}
                            </button>
                        </h3>
                        <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="heading1"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p><strong>{{$website_title}}</strong>{{aiTrans(', v 2024, sa vytrvalo zdržuje vydávania investičného
                                    poradenstva alebo ponúk. Jeho podstata spočíva skôr v preklenutí priepasti medzi
                                    jednotlivcami a vedeckými inštitúciami, ktoré sú zbehnuté v umení finančného
                                    opatrovníctva.')}}</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading2">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false"
                                aria-controls="collapse2">

                                {{ aiTrans(
                                    'Ako si [website_title] vyberá svoje partnerské vzdelávacie firmy?',
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                                
                            </button>
                        </h3>
                        <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="heading2"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    {{ aiTrans(
                                        'V spolupráci s uznávanými akademickými subjektmi špecializovanými na investičné stratégie
                                    poskytuje [website_title] svojim používateľom špičkový vzdelávací obsah. Od 2024 toto
                                    partnerstvo podčiarkuje záväzok platformy [website_title] uľahčiť výnimočnú vzdelávaciu
                                    cestu.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading3">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false"
                                aria-controls="collapse3">
                                {{aiTrans('Je táto webová stránka bezplatná?')}}
                            </button>
                        </h3>
                        <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="heading3"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    {{ aiTrans(
                                        'Základným poslaním [website_title] je bezproblémovo premostiť používateľov s množstvom
                                    vzdelávacích materiálov a zabezpečiť, aby prístup zostal úplne bezplatný.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary text-uppercase btn-lg shadow-lg px-3 px-md-5 fs-4">
                    {{aiTrans('Ďalšie informácie o službách platformy')}}
                </button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <h2 class="display-5 fw-bold mb-5 text-center">

                {{ aiTrans(
                    '[website_title] Najdôležitejšie informácie',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                
            </h2>
            <div class="row">
                <figure class="table">
                    <table>
                        <tbody>
                            <tr>
                                <td><strong>{{aiTrans('🤖 Náklady na registráciu')}}</strong></td>
                                <td><strong>{{aiTrans('Zadarmo')}}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>{{aiTrans('📋 Registrácia')}}</strong></td>
                                <td><strong>{{aiTrans('Rýchly a jednoduchý proces')}}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>{{aiTrans('💰 Finančné poplatky')}}</strong></td>
                                <td><strong>{{aiTrans('Žiadne ďalšie poplatky')}}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>{{aiTrans('💱 Zameranie na vzdelávanie')}}</strong></td>
                                <td><strong>{{aiTrans('Kryptomeny, forex, podielové fondy a iné investície')}}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>{{aiTrans('📊 Typ plošiny')}}</strong></td>
                                <td><strong>{{aiTrans('Internetové, prístupné cez akýkoľvek webový prehliadač')}}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>{{aiTrans('🌎 Krajín')}}</strong></td>
                                <td><strong>{{aiTrans('Väčšina krajín – okrem USA')}}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                </figure>
            </div>
        </div>
    </section>
@endsection
